/*
* wmacpimon v0.2.1
* (C) 2002 Costantino Pistagna (valvoline@vrlteam.org)
* wmacpimon homepage: http://www.vlrteam.org/wmacpimon
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* GNU General Public License for more details.
* 
* You should have received a copy of the GNU General Public License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <termios.h>
#include <signal.h>
#include <unistd.h>
#include <syslog.h>
#include <fcntl.h>
#include <time.h>
#include <errno.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <sys/times.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "wmacpimon.h"

#define TRUE 1
#define FALSE 0
#define MAXFD 64

static int daemon_proc;
static char daemonize=TRUE;

void usage() {
	printf("\n\n");
}

void daemon_init(const char *pname, int facility) {
	int i;
	pid_t pid;
	
	if( (pid = fork()) != 0)
		exit(0);
	setsid();
	signal(SIGHUP, SIG_IGN);
	if( (pid = fork() != 0) )
		exit(0);
	daemon_proc = 1;
	chdir("/");
	umask(0);
	for(i=0; i<MAXFD; i++)
		close(i);
	openlog(pname, LOG_PID, facility);
}

int main (int argc, char **argv) {
	FILE *fd;
	char *buff;
	char *batt;
	char *thrott;
	char *prcfile;
	int ibatt, ithrott, obatt, othrott;

	if(getuid() != 0) {
		printf("this program requires root privileges!\n");
		exit(-1);
	}
	
	if(argc<2) {
		printf("wmacpimond v%s (c) 2002 Costantino Pistagna (valvoline@vrlteam.org)\n"
		"usage: wmacpimond userfile\n\n"
		"userfile is an inter-process comunication\n"
		"you've to specify the same file in wmacpimon (client)\n\n",ver);
		exit(-1);
	}
	prcfile = (char *)malloc(sizeof(char)*128);
	strncpy(prcfile, argv[1], 128);
	
	if(daemonize==TRUE) daemon_init(argv[0], 0);
	
	buff = (char *)malloc(sizeof(char)*30);
	batt = (char *)malloc(sizeof(char)*5);
	thrott = (char *)malloc(sizeof(char)*5);
	ibatt=ithrott=obatt=othrott=0;
	
	while (1) {
		bzero(batt, 5);
		bzero(thrott, 5);
		bzero(buff, 30);
		fd = fopen(prcfile, "r");
		if(fd) {
			fread(buff, 30, 1, fd);
			fclose(fd);
			if(strstr(buff, "HALT")) {
				syslog(LOG_WARNING, "wmacpimon: shutdown pc - for battery LOW power\n");
				system("/sbin/halt");
				exit(0);
			}
			batt=strtok(buff, ":");
			thrott=strtok(NULL, ":");
			if(batt!=NULL && thrott !=NULL) {
				obatt=ibatt;
				ibatt=atoi(batt);
				othrott=ithrott;
				ithrott=atoi(thrott);
				if(obatt != ibatt) {
					bzero(buff, 30);
					sprintf(buff, "echo %d > /proc/acpi/processor/CPU0/performance", ibatt);
					system(buff);
					printf("battery: %d\n", ibatt);
				}
				if(othrott != ithrott) {
					bzero(buff, 30);
					sprintf(buff, "echo %d > /proc/acpi/processor/CPU0/throttling", ithrott);
					system(buff);
					printf("thrott: %d\n", ithrott);
				}
			}
		}
		sleep(1);
	}
	return 0;
}
