/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.html;

import com.google.jstestdriver.html.HtmlDocParser;
import com.google.jstestdriver.html.TextNode;
import com.google.jstestdriver.token.BufferedTokenStream;
import com.google.jstestdriver.token.ConcreteToken;
import com.google.jstestdriver.token.Nodes;
import com.google.jstestdriver.token.Token;

public class BlockNodeFactory
implements HtmlDocParser.NodeFactory {
    private static final ConcreteToken BLOCK_START_TOKEN = new ConcreteToken("{".toCharArray());
    private static final ConcreteToken BLOCK_END_TOKEN = new ConcreteToken("}".toCharArray());
    private final HtmlDocParser.NodeFactory[] factories;

    public BlockNodeFactory(HtmlDocParser.NodeFactory[] factories) {
        this.factories = factories;
    }

    public void create(BufferedTokenStream stream, Nodes nodes) {
        if (!BLOCK_START_TOKEN.equals(stream.read())) {
            stream.reset();
            return;
        }
        nodes.add(new TextNode(BLOCK_START_TOKEN));
        stream.mark();
        while (stream.available()) {
            Token token = stream.read();
            if (BLOCK_END_TOKEN.equals(token)) {
                stream.mark();
                nodes.add(new TextNode(BLOCK_END_TOKEN));
                return;
            }
            if (BLOCK_START_TOKEN.equals(token)) {
                stream.reset();
                this.create(stream, nodes);
                return;
            }
            stream.reset();
            for (HtmlDocParser.NodeFactory factory : this.factories) {
                factory.create(stream, nodes);
            }
        }
    }
}

