/** 
GCalc 3.0
Copyright (C) 2005 Jiho Kim 

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

Email: jiho@gcalc.net
Web: http://gcalc.net

Snail Mail: 
  Jiho Kim
  1002 Monterey Lane
  Tacoma, WA 98466
*/


package net.gcalc.calc.math.functions;

import java.util.Vector;

import net.gcalc.calc.main.SymbolTable;
import net.gcalc.calc.main.ValueTable;
import net.gcalc.calc.parser.ParseTree;

public class Maximum extends VariableArityFunction{
    public Maximum(ParseTree pt)
    {
    	super(pt); 
    }

    public double evaluate(SymbolTable st, ValueTable vt)
    {
        if (this.getNumberOfArgs()==0)
            return Double.NaN;
        
        double t;
        double max = Double.NEGATIVE_INFINITY;
     
        Vector args = getArgs();
        
        
        for (int i=0; i<args.size(); i++) {
        	t = ((Function) args.elementAt(i)).evaluate(st, vt);
            if (Double.isNaN(t))
                return t;
            
            if (max<t)
                max = t;
        }
        
        
        return max;
    }
    
    
    public Function derivative(Vector vars)
    {
        if (getNumberOfArgs()==1)
            return ((Function) getArgs().elementAt(0)).derivative(vars);
        
        Function f = maximum(0, (getNumberOfArgs()-1)/2);
        Function g = maximum((getNumberOfArgs()-1)/2+1, getNumberOfArgs()-1);
       
        Function df = f.derivative(vars);
        Function dg = g.derivative(vars);
        
        Function derDiff = FunctionFactory.getFunction(MINUS_TOKEN, df, dg);
        Function derSum = FunctionFactory.getFunction(PLUS_TOKEN, df, dg);
        Function diff = FunctionFactory.getFunction(MINUS_TOKEN, f, g);

        Function der =FunctionFactory.getFunction(DIV_TOKEN,
                FunctionFactory.getFunction(PLUS_TOKEN, 
                        derSum,
                        FunctionFactory.getFunction(MULT_TOKEN,
                                FunctionFactory.getFunction(SGN_TOKEN, diff),
                                derDiff)                                
                ),
                TWO
        );
        
        return der;
    }
    
   
    
    private Function maximum(int a, int b)
    {
        Vector v = new Vector();
        for (int i=a; i<=b; i++)
            v.add(this.getArg(i));
            
        return FunctionFactory.getFunction(MAX_TOKEN, v);
    }

}

