/*
 * Decompiled with CFR 0.152.
 */
package net.gcalc.calc.main;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import javax.swing.RepaintManager;

public class PrintUtilities
implements Printable {
    private Component componentToBePrinted;
    int dpi;

    public static void printComponent(Component c) {
        new PrintUtilities(c).print();
    }

    protected PrintUtilities(Component componentToBePrinted) {
        this(componentToBePrinted, -1);
    }

    protected PrintUtilities(Component componentToBePrinted, int dpi) {
        this.componentToBePrinted = componentToBePrinted;
        this.dpi = dpi;
    }

    public void print() {
        PrinterJob printJob = PrinterJob.getPrinterJob();
        printJob.setPrintable(this);
        if (printJob.printDialog()) {
            try {
                printJob.print();
            }
            catch (PrinterException pe) {
                System.out.println("Error printing: " + pe);
            }
        }
    }

    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2d = (Graphics2D)g;
        g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        if (this.dpi != -1) {
            double scale = 72.0 / (double)this.dpi;
            g2d.scale(scale, scale);
        }
        PrintUtilities.disableDoubleBuffering(this.componentToBePrinted);
        this.componentToBePrinted.paint(g2d);
        PrintUtilities.enableDoubleBuffering(this.componentToBePrinted);
        return 0;
    }

    public static void disableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(false);
    }

    public static void enableDoubleBuffering(Component c) {
        RepaintManager currentManager = RepaintManager.currentManager(c);
        currentManager.setDoubleBufferingEnabled(true);
    }
}

