/* #includes *//*{{{C}}}*//*{{{*/
#undef  _POSIX_SOURCE
#define _POSIX_SOURCE   1
#undef  _POSIX_C_SOURCE
#define _POSIX_C_SOURCE 2

#include "config.h"

#include <errno.h>

#ifdef DMALLOC
#include "dmalloc.h"
#endif

#include <stdlib.h>
#ifdef BROKEN_REALLOC
#define realloc(s,l) myrealloc(s,l)
#endif

#include "macro.h"
/*}}}*/

/* variables *//*{{{*/
static struct MacroChar *mac=(struct MacroChar*)0;
static size_t len=0,maxlen=0,runlen=0;
static int defining=0,runtimes;
static struct Macro *running=(struct Macro*)0;
/*}}}*/

/* mc_start    -- start macro *//*{{{*/
int mc_start(struct Macro *m, int count)
{
  if (defining) return -1;
  else
  {
    runtimes=count;
    running=m;
    runlen=0;
    return 0;
  }
}
/*}}}*/
/* mc_get      -- get character or function key, from macro or keyboard *//*{{{*/
void mc_get(struct MacroChar *mch, int utf8term)
{
  if (running!=(struct Macro*)0 && running->len>runlen)
  {
    *mch=*(running->mac+runlen);
    if (++runlen==running->len)
    {
      if (--runtimes) runlen=0;
      else running=(struct Macro*)0;
    }
  }
  else
  {
    int key;

    (void)refresh();
    /* SIGWINCH may cause one error (interrupted system call, but errno     */
    /* is not set to EINTR after getch(), but never two errors in sequence. */
    if ((key=getch())==ERR) key=getch();

    if (utf8term && (key&~0x7f)==0x80)
    {
      /* No function key, but set MSB: Begin of UTF-8 sequence.
       * Read remaining characters.
       */
      int more;
      char *u;

      u=mch->ch.c;
      *u=(char)key;
      more=bf_rcharlen(u)-1;
      while (more--) *++u=getch();
      mch->key=KEY_MAX;
    }
    else
    {
      mch->key=key;
      if (!(mch->key&~0xff))
      {
        ASCII(mch->ch)=(char)key;
        if (key=='\0')
        {
          MARK(mch->ch)=QUOTE;
          QUOTED(mch->ch)='\0';
        }
      }
    }

    if (defining)
    {
      if (len==maxlen) mac=realloc(mac,(maxlen+=256)*sizeof(*mac));
      *(mac+len++)=*mch;
    }
  }
}
/*}}}*/
/* mc_defstart -- start recording a macro *//*{{{*/
int mc_defstart(void)
{
  if (defining) return 0;
  else
  {
    len=0;
    defining=1;
    return 1;
  }
}
/*}}}*/
/* mc_defend   -- end macro recording *//*{{{*/
int mc_defend(struct Macro *m, int delete)
{
  if (defining)
  {
    m->len=len-delete;
    if (m->mac) free(m->mac);
    m->mac=mac;
    mac=(struct MacroChar*)0;
    len=0;
    maxlen=0;
    defining=0;
    return 1;
  }
  else return 0;
}
/*}}}*/
/* mc_null     -- init macro *//*{{{*/
void mc_null(struct Macro *m)
{
  m->mac=(struct MacroChar*)0;
  m->len=0;
}
/*}}}*/
