// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/pubsub/v1/pubsub.proto

#include "google/cloud/pubsub/internal/publisher_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace pubsub_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

PublisherTracingStub::PublisherTracingStub(std::shared_ptr<PublisherStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::pubsub::v1::Topic> PublisherTracingStub::CreateTopic(
    grpc::ClientContext& context, google::pubsub::v1::Topic const& request) {
  auto span =
      internal::MakeSpanGrpc("google.pubsub.v1.Publisher", "CreateTopic");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateTopic(context, request));
}

StatusOr<google::pubsub::v1::Topic> PublisherTracingStub::UpdateTopic(
    grpc::ClientContext& context,
    google::pubsub::v1::UpdateTopicRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.pubsub.v1.Publisher", "UpdateTopic");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateTopic(context, request));
}

StatusOr<google::pubsub::v1::PublishResponse> PublisherTracingStub::Publish(
    grpc::ClientContext& context,
    google::pubsub::v1::PublishRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.Publisher", "Publish");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->Publish(context, request));
}

StatusOr<google::pubsub::v1::Topic> PublisherTracingStub::GetTopic(
    grpc::ClientContext& context,
    google::pubsub::v1::GetTopicRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.Publisher", "GetTopic");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span, child_->GetTopic(context, request));
}

StatusOr<google::pubsub::v1::ListTopicsResponse>
PublisherTracingStub::ListTopics(
    grpc::ClientContext& context,
    google::pubsub::v1::ListTopicsRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.pubsub.v1.Publisher", "ListTopics");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTopics(context, request));
}

StatusOr<google::pubsub::v1::ListTopicSubscriptionsResponse>
PublisherTracingStub::ListTopicSubscriptions(
    grpc::ClientContext& context,
    google::pubsub::v1::ListTopicSubscriptionsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.Publisher",
                                     "ListTopicSubscriptions");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTopicSubscriptions(context, request));
}

StatusOr<google::pubsub::v1::ListTopicSnapshotsResponse>
PublisherTracingStub::ListTopicSnapshots(
    grpc::ClientContext& context,
    google::pubsub::v1::ListTopicSnapshotsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.Publisher",
                                     "ListTopicSnapshots");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListTopicSnapshots(context, request));
}

Status PublisherTracingStub::DeleteTopic(
    grpc::ClientContext& context,
    google::pubsub::v1::DeleteTopicRequest const& request) {
  auto span =
      internal::MakeSpanGrpc("google.pubsub.v1.Publisher", "DeleteTopic");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteTopic(context, request));
}

StatusOr<google::pubsub::v1::DetachSubscriptionResponse>
PublisherTracingStub::DetachSubscription(
    grpc::ClientContext& context,
    google::pubsub::v1::DetachSubscriptionRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.Publisher",
                                     "DetachSubscription");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DetachSubscription(context, request));
}

future<StatusOr<google::pubsub::v1::PublishResponse>>
PublisherTracingStub::AsyncPublish(
    google::cloud::CompletionQueue& cq,
    std::shared_ptr<grpc::ClientContext> context,
    google::pubsub::v1::PublishRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.pubsub.v1.Publisher", "Publish");
  internal::OTelScope scope(span);
  internal::InjectTraceContext(*context, *propagator_);
  auto f = child_->AsyncPublish(cq, context, request);
  return internal::EndSpan(std::move(context), std::move(span), std::move(f));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<PublisherStub> MakePublisherTracingStub(
    std::shared_ptr<PublisherStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<PublisherTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace pubsub_internal
}  // namespace cloud
}  // namespace google
