// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dialogflow/v2/context.proto

#include "google/cloud/dialogflow_es/internal/contexts_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace dialogflow_es_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

ContextsTracingStub::ContextsTracingStub(std::shared_ptr<ContextsStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::dialogflow::v2::ListContextsResponse>
ContextsTracingStub::ListContexts(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::ListContextsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Contexts",
                                     "ListContexts");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListContexts(context, request));
}

StatusOr<google::cloud::dialogflow::v2::Context>
ContextsTracingStub::GetContext(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::GetContextRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Contexts",
                                     "GetContext");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetContext(context, request));
}

StatusOr<google::cloud::dialogflow::v2::Context>
ContextsTracingStub::CreateContext(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::CreateContextRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Contexts",
                                     "CreateContext");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateContext(context, request));
}

StatusOr<google::cloud::dialogflow::v2::Context>
ContextsTracingStub::UpdateContext(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::UpdateContextRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Contexts",
                                     "UpdateContext");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateContext(context, request));
}

Status ContextsTracingStub::DeleteContext(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::DeleteContextRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Contexts",
                                     "DeleteContext");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteContext(context, request));
}

Status ContextsTracingStub::DeleteAllContexts(
    grpc::ClientContext& context,
    google::cloud::dialogflow::v2::DeleteAllContextsRequest const& request) {
  auto span = internal::MakeSpanGrpc("google.cloud.dialogflow.v2.Contexts",
                                     "DeleteAllContexts");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteAllContexts(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<ContextsStub> MakeContextsTracingStub(
    std::shared_ptr<ContextsStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<ContextsTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dialogflow_es_internal
}  // namespace cloud
}  // namespace google
