// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/datastore/v1/datastore.proto

#include "google/cloud/datastore/v1/internal/datastore_tracing_connection.h"
#include "google/cloud/internal/opentelemetry.h"
#include <memory>

namespace google {
namespace cloud {
namespace datastore_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DatastoreTracingConnection::DatastoreTracingConnection(
    std::shared_ptr<datastore_v1::DatastoreConnection> child)
    : child_(std::move(child)) {}

StatusOr<google::datastore::v1::LookupResponse>
DatastoreTracingConnection::Lookup(
    google::datastore::v1::LookupRequest const& request) {
  auto span = internal::MakeSpan("datastore_v1::DatastoreConnection::Lookup");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Lookup(request));
}

StatusOr<google::datastore::v1::RunQueryResponse>
DatastoreTracingConnection::RunQuery(
    google::datastore::v1::RunQueryRequest const& request) {
  auto span = internal::MakeSpan("datastore_v1::DatastoreConnection::RunQuery");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RunQuery(request));
}

StatusOr<google::datastore::v1::RunAggregationQueryResponse>
DatastoreTracingConnection::RunAggregationQuery(
    google::datastore::v1::RunAggregationQueryRequest const& request) {
  auto span = internal::MakeSpan(
      "datastore_v1::DatastoreConnection::RunAggregationQuery");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->RunAggregationQuery(request));
}

StatusOr<google::datastore::v1::BeginTransactionResponse>
DatastoreTracingConnection::BeginTransaction(
    google::datastore::v1::BeginTransactionRequest const& request) {
  auto span =
      internal::MakeSpan("datastore_v1::DatastoreConnection::BeginTransaction");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->BeginTransaction(request));
}

StatusOr<google::datastore::v1::CommitResponse>
DatastoreTracingConnection::Commit(
    google::datastore::v1::CommitRequest const& request) {
  auto span = internal::MakeSpan("datastore_v1::DatastoreConnection::Commit");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Commit(request));
}

StatusOr<google::datastore::v1::RollbackResponse>
DatastoreTracingConnection::Rollback(
    google::datastore::v1::RollbackRequest const& request) {
  auto span = internal::MakeSpan("datastore_v1::DatastoreConnection::Rollback");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->Rollback(request));
}

StatusOr<google::datastore::v1::AllocateIdsResponse>
DatastoreTracingConnection::AllocateIds(
    google::datastore::v1::AllocateIdsRequest const& request) {
  auto span =
      internal::MakeSpan("datastore_v1::DatastoreConnection::AllocateIds");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->AllocateIds(request));
}

StatusOr<google::datastore::v1::ReserveIdsResponse>
DatastoreTracingConnection::ReserveIds(
    google::datastore::v1::ReserveIdsRequest const& request) {
  auto span =
      internal::MakeSpan("datastore_v1::DatastoreConnection::ReserveIds");
  auto scope = opentelemetry::trace::Scope(span);
  return internal::EndSpan(*span, child_->ReserveIds(request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<datastore_v1::DatastoreConnection>
MakeDatastoreTracingConnection(
    std::shared_ptr<datastore_v1::DatastoreConnection> conn) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  if (internal::TracingEnabled(conn->options())) {
    conn = std::make_shared<DatastoreTracingConnection>(std::move(conn));
  }
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return conn;
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace datastore_v1_internal
}  // namespace cloud
}  // namespace google
