// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/dataplex/v1/service.proto

#include "google/cloud/dataplex/v1/internal/dataplex_connection_impl.h"
#include "google/cloud/dataplex/v1/internal/dataplex_option_defaults.h"
#include "google/cloud/background_threads.h"
#include "google/cloud/common_options.h"
#include "google/cloud/grpc_options.h"
#include "google/cloud/internal/async_long_running_operation.h"
#include "google/cloud/internal/pagination_range.h"
#include "google/cloud/internal/retry_loop.h"
#include <memory>

namespace google {
namespace cloud {
namespace dataplex_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN
namespace {

std::unique_ptr<dataplex_v1::DataplexServiceRetryPolicy> retry_policy(
    Options const& options) {
  return options.get<dataplex_v1::DataplexServiceRetryPolicyOption>()->clone();
}

std::unique_ptr<BackoffPolicy> backoff_policy(Options const& options) {
  return options.get<dataplex_v1::DataplexServiceBackoffPolicyOption>()
      ->clone();
}

std::unique_ptr<dataplex_v1::DataplexServiceConnectionIdempotencyPolicy>
idempotency_policy(Options const& options) {
  return options
      .get<dataplex_v1::DataplexServiceConnectionIdempotencyPolicyOption>()
      ->clone();
}

std::unique_ptr<PollingPolicy> polling_policy(Options const& options) {
  return options.get<dataplex_v1::DataplexServicePollingPolicyOption>()
      ->clone();
}

}  // namespace

DataplexServiceConnectionImpl::DataplexServiceConnectionImpl(
    std::unique_ptr<google::cloud::BackgroundThreads> background,
    std::shared_ptr<dataplex_v1_internal::DataplexServiceStub> stub,
    Options options)
    : background_(std::move(background)),
      stub_(std::move(stub)),
      options_(internal::MergeOptions(std::move(options),
                                      DataplexServiceConnection::options())) {}

future<StatusOr<google::cloud::dataplex::v1::Lake>>
DataplexServiceConnectionImpl::CreateLake(
    google::cloud::dataplex::v1::CreateLakeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Lake>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::CreateLakeRequest const& request) {
        return stub->AsyncCreateLake(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Lake>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateLake(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::Lake>>
DataplexServiceConnectionImpl::UpdateLake(
    google::cloud::dataplex::v1::UpdateLakeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Lake>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::UpdateLakeRequest const& request) {
        return stub->AsyncUpdateLake(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Lake>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateLake(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceConnectionImpl::DeleteLake(
    google::cloud::dataplex::v1::DeleteLakeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::DeleteLakeRequest const& request) {
        return stub->AsyncDeleteLake(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteLake(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::Lake>
DataplexServiceConnectionImpl::ListLakes(
    google::cloud::dataplex::v1::ListLakesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLakes(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Lake>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListLakesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::dataplex::v1::ListLakesRequest const& request) {
              return stub->ListLakes(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListLakesResponse r) {
        std::vector<google::cloud::dataplex::v1::Lake> result(r.lakes().size());
        auto& messages = *r.mutable_lakes();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::Lake>
DataplexServiceConnectionImpl::GetLake(
    google::cloud::dataplex::v1::GetLakeRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetLake(request),
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::GetLakeRequest const& request) {
        return stub_->GetLake(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceConnectionImpl::ListLakeActions(
    google::cloud::dataplex::v1::ListLakeActionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListLakeActions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Action>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListLakeActionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::dataplex::v1::ListLakeActionsRequest const&
                       request) {
              return stub->ListLakeActions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListActionsResponse r) {
        std::vector<google::cloud::dataplex::v1::Action> result(
            r.actions().size());
        auto& messages = *r.mutable_actions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::dataplex::v1::Zone>>
DataplexServiceConnectionImpl::CreateZone(
    google::cloud::dataplex::v1::CreateZoneRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Zone>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::CreateZoneRequest const& request) {
        return stub->AsyncCreateZone(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Zone>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateZone(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::Zone>>
DataplexServiceConnectionImpl::UpdateZone(
    google::cloud::dataplex::v1::UpdateZoneRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Zone>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::UpdateZoneRequest const& request) {
        return stub->AsyncUpdateZone(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Zone>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateZone(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceConnectionImpl::DeleteZone(
    google::cloud::dataplex::v1::DeleteZoneRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::DeleteZoneRequest const& request) {
        return stub->AsyncDeleteZone(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteZone(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::Zone>
DataplexServiceConnectionImpl::ListZones(
    google::cloud::dataplex::v1::ListZonesRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListZones(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Zone>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListZonesRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::dataplex::v1::ListZonesRequest const& request) {
              return stub->ListZones(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListZonesResponse r) {
        std::vector<google::cloud::dataplex::v1::Zone> result(r.zones().size());
        auto& messages = *r.mutable_zones();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::Zone>
DataplexServiceConnectionImpl::GetZone(
    google::cloud::dataplex::v1::GetZoneRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetZone(request),
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::GetZoneRequest const& request) {
        return stub_->GetZone(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceConnectionImpl::ListZoneActions(
    google::cloud::dataplex::v1::ListZoneActionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListZoneActions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Action>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListZoneActionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::dataplex::v1::ListZoneActionsRequest const&
                       request) {
              return stub->ListZoneActions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListActionsResponse r) {
        std::vector<google::cloud::dataplex::v1::Action> result(
            r.actions().size());
        auto& messages = *r.mutable_actions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::dataplex::v1::Asset>>
DataplexServiceConnectionImpl::CreateAsset(
    google::cloud::dataplex::v1::CreateAssetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Asset>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::CreateAssetRequest const& request) {
        return stub->AsyncCreateAsset(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Asset>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateAsset(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::Asset>>
DataplexServiceConnectionImpl::UpdateAsset(
    google::cloud::dataplex::v1::UpdateAssetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Asset>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::UpdateAssetRequest const& request) {
        return stub->AsyncUpdateAsset(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Asset>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateAsset(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceConnectionImpl::DeleteAsset(
    google::cloud::dataplex::v1::DeleteAssetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::DeleteAssetRequest const& request) {
        return stub->AsyncDeleteAsset(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteAsset(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::Asset>
DataplexServiceConnectionImpl::ListAssets(
    google::cloud::dataplex::v1::ListAssetsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAssets(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Asset>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListAssetsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::dataplex::v1::ListAssetsRequest const& request) {
              return stub->ListAssets(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListAssetsResponse r) {
        std::vector<google::cloud::dataplex::v1::Asset> result(
            r.assets().size());
        auto& messages = *r.mutable_assets();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::Asset>
DataplexServiceConnectionImpl::GetAsset(
    google::cloud::dataplex::v1::GetAssetRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetAsset(request),
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::GetAssetRequest const& request) {
        return stub_->GetAsset(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::dataplex::v1::Action>
DataplexServiceConnectionImpl::ListAssetActions(
    google::cloud::dataplex::v1::ListAssetActionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListAssetActions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Action>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListAssetActionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::dataplex::v1::ListAssetActionsRequest const&
                       request) {
              return stub->ListAssetActions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListActionsResponse r) {
        std::vector<google::cloud::dataplex::v1::Action> result(
            r.actions().size());
        auto& messages = *r.mutable_actions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

future<StatusOr<google::cloud::dataplex::v1::Task>>
DataplexServiceConnectionImpl::CreateTask(
    google::cloud::dataplex::v1::CreateTaskRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Task>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::CreateTaskRequest const& request) {
        return stub->AsyncCreateTask(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Task>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateTask(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::Task>>
DataplexServiceConnectionImpl::UpdateTask(
    google::cloud::dataplex::v1::UpdateTaskRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Task>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::UpdateTaskRequest const& request) {
        return stub->AsyncUpdateTask(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Task>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateTask(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceConnectionImpl::DeleteTask(
    google::cloud::dataplex::v1::DeleteTaskRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::DeleteTaskRequest const& request) {
        return stub->AsyncDeleteTask(cq, std::move(context), options, request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteTask(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::Task>
DataplexServiceConnectionImpl::ListTasks(
    google::cloud::dataplex::v1::ListTasksRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListTasks(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Task>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListTasksRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::dataplex::v1::ListTasksRequest const& request) {
              return stub->ListTasks(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListTasksResponse r) {
        std::vector<google::cloud::dataplex::v1::Task> result(r.tasks().size());
        auto& messages = *r.mutable_tasks();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::Task>
DataplexServiceConnectionImpl::GetTask(
    google::cloud::dataplex::v1::GetTaskRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetTask(request),
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::GetTaskRequest const& request) {
        return stub_->GetTask(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::dataplex::v1::Job>
DataplexServiceConnectionImpl::ListJobs(
    google::cloud::dataplex::v1::ListJobsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListJobs(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Job>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListJobsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](
                grpc::ClientContext& context,
                google::cloud::dataplex::v1::ListJobsRequest const& request) {
              return stub->ListJobs(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListJobsResponse r) {
        std::vector<google::cloud::dataplex::v1::Job> result(r.jobs().size());
        auto& messages = *r.mutable_jobs();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::RunTaskResponse>
DataplexServiceConnectionImpl::RunTask(
    google::cloud::dataplex::v1::RunTaskRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->RunTask(request),
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::RunTaskRequest const& request) {
        return stub_->RunTask(context, request);
      },
      request, __func__);
}

StatusOr<google::cloud::dataplex::v1::Job>
DataplexServiceConnectionImpl::GetJob(
    google::cloud::dataplex::v1::GetJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetJob(request),
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::GetJobRequest const& request) {
        return stub_->GetJob(context, request);
      },
      request, __func__);
}

Status DataplexServiceConnectionImpl::CancelJob(
    google::cloud::dataplex::v1::CancelJobRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CancelJob(request),
      [this](grpc::ClientContext& context,
             google::cloud::dataplex::v1::CancelJobRequest const& request) {
        return stub_->CancelJob(context, request);
      },
      request, __func__);
}

future<StatusOr<google::cloud::dataplex::v1::Environment>>
DataplexServiceConnectionImpl::CreateEnvironment(
    google::cloud::dataplex::v1::CreateEnvironmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Environment>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::CreateEnvironmentRequest const&
              request) {
        return stub->AsyncCreateEnvironment(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Environment>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->CreateEnvironment(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::Environment>>
DataplexServiceConnectionImpl::UpdateEnvironment(
    google::cloud::dataplex::v1::UpdateEnvironmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::Environment>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::UpdateEnvironmentRequest const&
              request) {
        return stub->AsyncUpdateEnvironment(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultResponse<
          google::cloud::dataplex::v1::Environment>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->UpdateEnvironment(request),
      polling_policy(*current), __func__);
}

future<StatusOr<google::cloud::dataplex::v1::OperationMetadata>>
DataplexServiceConnectionImpl::DeleteEnvironment(
    google::cloud::dataplex::v1::DeleteEnvironmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::AsyncLongRunningOperation<
      google::cloud::dataplex::v1::OperationMetadata>(
      background_->cq(), current, request,
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::cloud::dataplex::v1::DeleteEnvironmentRequest const&
              request) {
        return stub->AsyncDeleteEnvironment(cq, std::move(context), options,
                                            request);
      },
      [stub = stub_](google::cloud::CompletionQueue& cq,
                     std::shared_ptr<grpc::ClientContext> context,
                     Options const& options,
                     google::longrunning::GetOperationRequest const& request) {
        return stub->AsyncGetOperation(cq, std::move(context), options,
                                       request);
      },
      [stub = stub_](
          google::cloud::CompletionQueue& cq,
          std::shared_ptr<grpc::ClientContext> context, Options const& options,
          google::longrunning::CancelOperationRequest const& request) {
        return stub->AsyncCancelOperation(cq, std::move(context), options,
                                          request);
      },
      &google::cloud::internal::ExtractLongRunningResultMetadata<
          google::cloud::dataplex::v1::OperationMetadata>,
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->DeleteEnvironment(request),
      polling_policy(*current), __func__);
}

StreamRange<google::cloud::dataplex::v1::Environment>
DataplexServiceConnectionImpl::ListEnvironments(
    google::cloud::dataplex::v1::ListEnvironmentsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListEnvironments(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Environment>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListEnvironmentsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::dataplex::v1::ListEnvironmentsRequest const&
                       request) {
              return stub->ListEnvironments(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListEnvironmentsResponse r) {
        std::vector<google::cloud::dataplex::v1::Environment> result(
            r.environments().size());
        auto& messages = *r.mutable_environments();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

StatusOr<google::cloud::dataplex::v1::Environment>
DataplexServiceConnectionImpl::GetEnvironment(
    google::cloud::dataplex::v1::GetEnvironmentRequest const& request) {
  auto current = google::cloud::internal::SaveCurrentOptions();
  return google::cloud::internal::RetryLoop(
      retry_policy(*current), backoff_policy(*current),
      idempotency_policy(*current)->GetEnvironment(request),
      [this](
          grpc::ClientContext& context,
          google::cloud::dataplex::v1::GetEnvironmentRequest const& request) {
        return stub_->GetEnvironment(context, request);
      },
      request, __func__);
}

StreamRange<google::cloud::dataplex::v1::Session>
DataplexServiceConnectionImpl::ListSessions(
    google::cloud::dataplex::v1::ListSessionsRequest request) {
  request.clear_page_token();
  auto current = google::cloud::internal::SaveCurrentOptions();
  auto idempotency = idempotency_policy(*current)->ListSessions(request);
  char const* function_name = __func__;
  return google::cloud::internal::MakePaginationRange<
      StreamRange<google::cloud::dataplex::v1::Session>>(
      std::move(request),
      [idempotency, function_name, stub = stub_,
       retry = std::shared_ptr<dataplex_v1::DataplexServiceRetryPolicy>(
           retry_policy(*current)),
       backoff = std::shared_ptr<BackoffPolicy>(backoff_policy(*current))](
          google::cloud::dataplex::v1::ListSessionsRequest const& r) {
        return google::cloud::internal::RetryLoop(
            retry->clone(), backoff->clone(), idempotency,
            [stub](grpc::ClientContext& context,
                   google::cloud::dataplex::v1::ListSessionsRequest const&
                       request) {
              return stub->ListSessions(context, request);
            },
            r, function_name);
      },
      [](google::cloud::dataplex::v1::ListSessionsResponse r) {
        std::vector<google::cloud::dataplex::v1::Session> result(
            r.sessions().size());
        auto& messages = *r.mutable_sessions();
        std::move(messages.begin(), messages.end(), result.begin());
        return result;
      });
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace dataplex_v1_internal
}  // namespace cloud
}  // namespace google
