// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/cloud/contentwarehouse/v1/document_schema_service.proto

#include "google/cloud/contentwarehouse/v1/internal/document_schema_tracing_stub.h"
#include "google/cloud/internal/grpc_opentelemetry.h"

namespace google {
namespace cloud {
namespace contentwarehouse_v1_internal {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

DocumentSchemaServiceTracingStub::DocumentSchemaServiceTracingStub(
    std::shared_ptr<DocumentSchemaServiceStub> child)
    : child_(std::move(child)), propagator_(internal::MakePropagator()) {}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceTracingStub::CreateDocumentSchema(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::CreateDocumentSchemaRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contentwarehouse.v1.DocumentSchemaService",
      "CreateDocumentSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->CreateDocumentSchema(context, request));
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceTracingStub::UpdateDocumentSchema(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::UpdateDocumentSchemaRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contentwarehouse.v1.DocumentSchemaService",
      "UpdateDocumentSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->UpdateDocumentSchema(context, request));
}

StatusOr<google::cloud::contentwarehouse::v1::DocumentSchema>
DocumentSchemaServiceTracingStub::GetDocumentSchema(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::GetDocumentSchemaRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contentwarehouse.v1.DocumentSchemaService",
      "GetDocumentSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->GetDocumentSchema(context, request));
}

Status DocumentSchemaServiceTracingStub::DeleteDocumentSchema(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::DeleteDocumentSchemaRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contentwarehouse.v1.DocumentSchemaService",
      "DeleteDocumentSchema");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->DeleteDocumentSchema(context, request));
}

StatusOr<google::cloud::contentwarehouse::v1::ListDocumentSchemasResponse>
DocumentSchemaServiceTracingStub::ListDocumentSchemas(
    grpc::ClientContext& context,
    google::cloud::contentwarehouse::v1::ListDocumentSchemasRequest const&
        request) {
  auto span = internal::MakeSpanGrpc(
      "google.cloud.contentwarehouse.v1.DocumentSchemaService",
      "ListDocumentSchemas");
  auto scope = opentelemetry::trace::Scope(span);
  internal::InjectTraceContext(context, *propagator_);
  return internal::EndSpan(context, *span,
                           child_->ListDocumentSchemas(context, request));
}

#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY

std::shared_ptr<DocumentSchemaServiceStub> MakeDocumentSchemaServiceTracingStub(
    std::shared_ptr<DocumentSchemaServiceStub> stub) {
#ifdef GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
  return std::make_shared<DocumentSchemaServiceTracingStub>(std::move(stub));
#else
  return stub;
#endif  // GOOGLE_CLOUD_CPP_HAVE_OPENTELEMETRY
}

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace contentwarehouse_v1_internal
}  // namespace cloud
}  // namespace google
