// Copyright 2021 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Generated by the Codegen C++ plugin.
// If you make any local changes, they will be lost.
// source: google/bigtable/admin/v2/bigtable_instance_admin.proto

#ifndef GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGTABLE_ADMIN_BIGTABLE_INSTANCE_ADMIN_CONNECTION_H
#define GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGTABLE_ADMIN_BIGTABLE_INSTANCE_ADMIN_CONNECTION_H

#include "google/cloud/bigtable/admin/bigtable_instance_admin_connection_idempotency_policy.h"
#include "google/cloud/bigtable/admin/internal/bigtable_instance_admin_retry_traits.h"
#include "google/cloud/backoff_policy.h"
#include "google/cloud/future.h"
#include "google/cloud/internal/retry_policy_impl.h"
#include "google/cloud/options.h"
#include "google/cloud/polling_policy.h"
#include "google/cloud/status_or.h"
#include "google/cloud/stream_range.h"
#include "google/cloud/version.h"
#include <google/bigtable/admin/v2/bigtable_instance_admin.pb.h>
#include <google/longrunning/operations.grpc.pb.h>
#include <memory>

namespace google {
namespace cloud {
namespace bigtable_admin {
GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_BEGIN

/// The retry policy for `BigtableInstanceAdminConnection`.
class BigtableInstanceAdminRetryPolicy : public ::google::cloud::RetryPolicy {
 public:
  /// Creates a new instance of the policy, reset to the initial state.
  virtual std::unique_ptr<BigtableInstanceAdminRetryPolicy> clone() const = 0;
};

/**
 * A retry policy for `BigtableInstanceAdminConnection` based on counting
 * errors.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - More than a prescribed number of transient failures is detected.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kAborted`](@ref google::cloud::StatusCode)
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class BigtableInstanceAdminLimitedErrorCountRetryPolicy
    : public BigtableInstanceAdminRetryPolicy {
 public:
  /**
   * Create an instance that tolerates up to @p maximum_failures transient
   * errors.
   *
   * @note Disable the retry loop by providing an instance of this policy with
   *     @p maximum_failures == 0.
   */
  explicit BigtableInstanceAdminLimitedErrorCountRetryPolicy(
      int maximum_failures)
      : impl_(maximum_failures) {}

  BigtableInstanceAdminLimitedErrorCountRetryPolicy(
      BigtableInstanceAdminLimitedErrorCountRetryPolicy&& rhs) noexcept
      : BigtableInstanceAdminLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}
  BigtableInstanceAdminLimitedErrorCountRetryPolicy(
      BigtableInstanceAdminLimitedErrorCountRetryPolicy const& rhs) noexcept
      : BigtableInstanceAdminLimitedErrorCountRetryPolicy(
            rhs.maximum_failures()) {}

  int maximum_failures() const { return impl_.maximum_failures(); }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<BigtableInstanceAdminRetryPolicy> clone() const override {
    return std::make_unique<BigtableInstanceAdminLimitedErrorCountRetryPolicy>(
        maximum_failures());
  }

  // This is provided only for backwards compatibility.
  using BaseType = BigtableInstanceAdminRetryPolicy;

 private:
  google::cloud::internal::LimitedErrorCountRetryPolicy<
      bigtable_admin_internal::BigtableInstanceAdminRetryTraits>
      impl_;
};

/**
 * A retry policy for `BigtableInstanceAdminConnection` based on elapsed time.
 *
 * This policy stops retrying if:
 * - An RPC returns a non-transient error.
 * - The elapsed time in the retry loop exceeds a prescribed duration.
 *
 * In this class the following status codes are treated as transient errors:
 * - [`kAborted`](@ref google::cloud::StatusCode)
 * - [`kUnavailable`](@ref google::cloud::StatusCode)
 */
class BigtableInstanceAdminLimitedTimeRetryPolicy
    : public BigtableInstanceAdminRetryPolicy {
 public:
  /**
   * Constructor given a `std::chrono::duration<>` object.
   *
   * @tparam DurationRep a placeholder to match the `Rep` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the underlying
   *     arithmetic type used to store the number of ticks. For our purposes it
   *     is simply a formal parameter.
   * @tparam DurationPeriod a placeholder to match the `Period` tparam for @p
   *     duration's type. The semantics of this template parameter are
   *     documented in `std::chrono::duration<>`. In brief, the length of the
   *     tick in seconds, expressed as a `std::ratio<>`. For our purposes it is
   *     simply a formal parameter.
   * @param maximum_duration the maximum time allowed before the policy expires.
   *     While the application can express this time in any units they desire,
   *     the class truncates to milliseconds.
   *
   * @see https://en.cppreference.com/w/cpp/chrono/duration for more information
   *     about `std::chrono::duration`.
   */
  template <typename DurationRep, typename DurationPeriod>
  explicit BigtableInstanceAdminLimitedTimeRetryPolicy(
      std::chrono::duration<DurationRep, DurationPeriod> maximum_duration)
      : impl_(maximum_duration) {}

  BigtableInstanceAdminLimitedTimeRetryPolicy(
      BigtableInstanceAdminLimitedTimeRetryPolicy&& rhs) noexcept
      : BigtableInstanceAdminLimitedTimeRetryPolicy(rhs.maximum_duration()) {}
  BigtableInstanceAdminLimitedTimeRetryPolicy(
      BigtableInstanceAdminLimitedTimeRetryPolicy const& rhs) noexcept
      : BigtableInstanceAdminLimitedTimeRetryPolicy(rhs.maximum_duration()) {}

  std::chrono::milliseconds maximum_duration() const {
    return impl_.maximum_duration();
  }

  bool OnFailure(Status const& status) override {
    return impl_.OnFailure(status);
  }
  bool IsExhausted() const override { return impl_.IsExhausted(); }
  bool IsPermanentFailure(Status const& status) const override {
    return impl_.IsPermanentFailure(status);
  }
  std::unique_ptr<BigtableInstanceAdminRetryPolicy> clone() const override {
    return std::make_unique<BigtableInstanceAdminLimitedTimeRetryPolicy>(
        maximum_duration());
  }

  // This is provided only for backwards compatibility.
  using BaseType = BigtableInstanceAdminRetryPolicy;

 private:
  google::cloud::internal::LimitedTimeRetryPolicy<
      bigtable_admin_internal::BigtableInstanceAdminRetryTraits>
      impl_;
};

/**
 * The `BigtableInstanceAdminConnection` object for
 * `BigtableInstanceAdminClient`.
 *
 * This interface defines virtual methods for each of the user-facing overload
 * sets in `BigtableInstanceAdminClient`. This allows users to inject custom
 * behavior (e.g., with a Google Mock object) when writing tests that use
 * objects of type `BigtableInstanceAdminClient`.
 *
 * To create a concrete instance, see `MakeBigtableInstanceAdminConnection()`.
 *
 * For mocking, see `bigtable_admin_mocks::MockBigtableInstanceAdminConnection`.
 */
class BigtableInstanceAdminConnection {
 public:
  virtual ~BigtableInstanceAdminConnection() = 0;

  virtual Options options() { return Options{}; }

  virtual future<StatusOr<google::bigtable::admin::v2::Instance>>
  CreateInstance(
      google::bigtable::admin::v2::CreateInstanceRequest const& request);

  virtual StatusOr<google::bigtable::admin::v2::Instance> GetInstance(
      google::bigtable::admin::v2::GetInstanceRequest const& request);

  virtual StatusOr<google::bigtable::admin::v2::ListInstancesResponse>
  ListInstances(
      google::bigtable::admin::v2::ListInstancesRequest const& request);

  virtual StatusOr<google::bigtable::admin::v2::Instance> UpdateInstance(
      google::bigtable::admin::v2::Instance const& request);

  virtual future<StatusOr<google::bigtable::admin::v2::Instance>>
  PartialUpdateInstance(
      google::bigtable::admin::v2::PartialUpdateInstanceRequest const& request);

  virtual Status DeleteInstance(
      google::bigtable::admin::v2::DeleteInstanceRequest const& request);

  virtual future<StatusOr<google::bigtable::admin::v2::Cluster>> CreateCluster(
      google::bigtable::admin::v2::CreateClusterRequest const& request);

  virtual StatusOr<google::bigtable::admin::v2::Cluster> GetCluster(
      google::bigtable::admin::v2::GetClusterRequest const& request);

  virtual StatusOr<google::bigtable::admin::v2::ListClustersResponse>
  ListClusters(google::bigtable::admin::v2::ListClustersRequest const& request);

  virtual future<StatusOr<google::bigtable::admin::v2::Cluster>> UpdateCluster(
      google::bigtable::admin::v2::Cluster const& request);

  virtual future<StatusOr<google::bigtable::admin::v2::Cluster>>
  PartialUpdateCluster(
      google::bigtable::admin::v2::PartialUpdateClusterRequest const& request);

  virtual Status DeleteCluster(
      google::bigtable::admin::v2::DeleteClusterRequest const& request);

  virtual StatusOr<google::bigtable::admin::v2::AppProfile> CreateAppProfile(
      google::bigtable::admin::v2::CreateAppProfileRequest const& request);

  virtual StatusOr<google::bigtable::admin::v2::AppProfile> GetAppProfile(
      google::bigtable::admin::v2::GetAppProfileRequest const& request);

  virtual StreamRange<google::bigtable::admin::v2::AppProfile> ListAppProfiles(
      google::bigtable::admin::v2::ListAppProfilesRequest request);

  virtual future<StatusOr<google::bigtable::admin::v2::AppProfile>>
  UpdateAppProfile(
      google::bigtable::admin::v2::UpdateAppProfileRequest const& request);

  virtual Status DeleteAppProfile(
      google::bigtable::admin::v2::DeleteAppProfileRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> GetIamPolicy(
      google::iam::v1::GetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::Policy> SetIamPolicy(
      google::iam::v1::SetIamPolicyRequest const& request);

  virtual StatusOr<google::iam::v1::TestIamPermissionsResponse>
  TestIamPermissions(google::iam::v1::TestIamPermissionsRequest const& request);

  virtual StreamRange<google::bigtable::admin::v2::HotTablet> ListHotTablets(
      google::bigtable::admin::v2::ListHotTabletsRequest request);
};

/**
 * A factory function to construct an object of type
 * `BigtableInstanceAdminConnection`.
 *
 * The returned connection object should not be used directly; instead it
 * should be passed as an argument to the constructor of
 * BigtableInstanceAdminClient.
 *
 * The optional @p options argument may be used to configure aspects of the
 * returned `BigtableInstanceAdminConnection`. Expected options are any of the
 * types in the following option lists:
 *
 * - `google::cloud::CommonOptionList`
 * - `google::cloud::GrpcOptionList`
 * - `google::cloud::UnifiedCredentialsOptionList`
 * - `google::cloud::bigtable_admin::BigtableInstanceAdminPolicyOptionList`
 *
 * @note Unexpected options will be ignored. To log unexpected options instead,
 *     set `GOOGLE_CLOUD_CPP_ENABLE_CLOG=yes` in the environment.
 *
 * @param options (optional) Configure the `BigtableInstanceAdminConnection`
 * created by this function.
 */
std::shared_ptr<BigtableInstanceAdminConnection>
MakeBigtableInstanceAdminConnection(Options options = {});

GOOGLE_CLOUD_CPP_INLINE_NAMESPACE_END
}  // namespace bigtable_admin
}  // namespace cloud
}  // namespace google

#endif  // GOOGLE_CLOUD_CPP_GOOGLE_CLOUD_BIGTABLE_ADMIN_BIGTABLE_INSTANCE_ADMIN_CONNECTION_H
