/*
 * Copyright (c) 2020-2023, Stalwart Labs Ltd.
 *
 * This file is part of the Stalwart Sieve Interpreter.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as
 * published by the Free Software Foundation, either version 3 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 * in the LICENSE file at the top-level directory of this distribution.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * You can be released from the requirements of the AGPLv3 license by
 * purchasing a commercial license. Please contact licensing@stalw.art
 * for more details.
*/

use sieve::{Compiler, Sieve};

fn main() {
    let script = br#"if header :matches \"List-ID\" \"*<*@*\" {
        fileinto \"INBOX.lists.${2}\"; stop;
    }"#;

    // Compile
    let compiled_script = Compiler::new().compile(script).unwrap();

    // Serialize
    let serialized_script = compiled_script.serialize().unwrap();

    // Deserialize
    let deserialized_script = Sieve::deserialize(&serialized_script).unwrap();

    assert_eq!(compiled_script, deserialized_script);
}
