// (c) Copyright 2000 Justin F. Chapweske
// (c) Copyright 2000 Ry4an C. Brase

import com.onionnetworks.fec.*;

import com.onionnetworks.util.Util;
import com.onionnetworks.util.Buffer;
/*
 * Java port of test code for the fec codes.  
 * Original is (C) 1997-98 Luigi Rizzo (luigi@iet.unipi.it)
 *
 * @author Justin F. Chapweske (orasis@acm.cs.umn.edu)
 */
public class CodeTest {

    public static FECMath fecMath = new FECMath(8);

    public static final int KK = 64; // 255
    public static final int PACKET_SIZE = 1024;

    public static void printMatrix(char[] matrix, int rows, int cols, 
				   String msg) {
	System.err.println(msg);
	for (int r=0; r<rows; r++) {
	    for (int c=0; c<cols; c++) {
		System.err.print(((int) matrix[r*cols+c])+" ");
	    }
	    System.err.println("");
	}
	System.err.println("");
    }

    /**
     * Creates k packets of size sz of random data, encodes them,
     * and tries to decode.
     * Index contains the permutation entry.
     */
    public static final void testDecode(FECCode code, int k, int index[], 
                                        int packetSize, String s) {
	
        byte[] src = new byte[k*packetSize];
        Util.rand.nextBytes(src);
        Buffer[] srcBufs = new Buffer[k];
	for (int i=0;i<srcBufs.length;i++) {
	    srcBufs[i] = new Buffer(src,i*packetSize,packetSize);
	}

        byte[] repair = new byte[k*packetSize];
        Buffer[] repairBufs = new Buffer[k];
	for (int i=0;i<repairBufs.length;i++) {
	    repairBufs[i] = new Buffer(repair,i*packetSize,packetSize);
	}

	int reconstruct = 0 ;
	for(int i = 0 ; i < k ; i++) {
	    if (index[i] >= k ) {
                reconstruct++;
            }
	}

	long time1 = System.currentTimeMillis();
        code.encode(srcBufs, repairBufs, index);
	time1 = System.currentTimeMillis() - time1;
	
	long time2 = System.currentTimeMillis();
        code.decode(repairBufs, index);
	time2 = System.currentTimeMillis() - time2;

        /*	for (int i=0; i<k; i++) {
	    if (!Util.byteArraysEqual
                (srcBufs[i].b,srcBufs[i].off,repairBufs[i].b,repairBufs[i].off,
                 packetSize)) {
                
                System.err.println("error reconstructing block "+i);
                System.out.println
                    ("orig="+
                     new String(srcBufs[i].b,srcBufs[i].off,packetSize));
                System.out.println
                    ("new ="+new String(repairBufs[i].b,repairBufs[i].off,packetSize));
                System.exit(-1);
	    }
            }*/

        if (!Util.arraysEqual(src,0,repair,0,packetSize*k)) {
            System.err.println("error reconstructing packet.");
            System.err.println("orig="+new String(src));
            System.err.println("new="+new String(repair));
            System.exit(-1);
        }
        

        if (time1 == 0 || time2 == 0) {
            System.err.print("Too fast too measure.\r");
            return;
        } 

	System.err.print("  k "+
			 Util.getSpaces(3-new Integer(k).toString().length())+
			 k+", l "+
			 Util.getSpaces(3-new Integer(reconstruct).toString().
				   length())+
			 reconstruct+
			 "  c_enc "+
                         (((k*packetSize*reconstruct)/time1)/(float) 1000)
			 +" MB/s c_dec "
			 + (((k*packetSize*reconstruct)/time2)/(float) 1000)
                         +" MB/s     \r");
    }
    
    public static void printEncoded(char[] c) {
        for (int i=0;i<c.length;i++) {
            System.out.print(((int) c[i])+",");
        }
        System.out.println("");
    }


    public static void test() {
	int lim = fecMath.gfSize + 1;
	
	for (int k = KK; k > 2; k--) {
	    FECCode code = FECCodeFactory.getDefault().createFECCode(k,lim);
            if (code == null) {
                throw new IllegalStateException("FECCode is null!");
            }
	    int[] index = new int[k];
	    
            int i;

	    for (i=0; i<k; i++) {
                index[i] = k - i;
            }

	    String buf = "k="+k+", k - i"; 
	    testDecode(code, k, index, PACKET_SIZE, buf);
	    
	    for (i=0; i<k; i++) {
                index[i] = i ;
            }
	    testDecode(code, k, index, PACKET_SIZE, "i");
	    
            int j, max_i0 = KK/2 ;
            if (max_i0 + KK > lim) {
                max_i0 = lim - KK ;
            }
            for (i= 0 ; i <= max_i0 ; i++) {
                for (j=0; j<k; j++) {
			index[j] = j + i ;
                }
                testDecode(code, k, index, PACKET_SIZE, "shifted j");
            }
	    System.out.println();
        }
    }

    public static void main(String[] args) {
        try {
            test();
        } catch (ExceptionInInitializerError e) {
            e.getException().printStackTrace();
        }
    }
}
