/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.io;

import com.onionnetworks.io.FilterRAF;
import com.onionnetworks.io.RAF;
import com.onionnetworks.util.FileUtil;
import java.io.File;
import java.io.IOException;

public class TempRaf
extends FilterRAF {
    public static final int NEVER = 0;
    public static final int RENAMED_AND_DONE_WRITING = 1;
    public static final int RENAMED = 2;
    public static final int ALWAYS = 3;
    public static final int DEFAULT_KEEP_POLICY = 0;
    int keepPolicy;
    boolean renamed = false;

    public synchronized void renameTo(File newFile) throws IOException {
        this.renamed = true;
        super.renameTo(newFile);
    }

    public synchronized void close() throws IOException {
        switch (this.keepPolicy) {
            case 3: {
                break;
            }
            case 0: {
                this.deleteOnClose();
                break;
            }
            case 2: {
                if (this.renamed) break;
                this.deleteOnClose();
                break;
            }
            case 1: {
                if (this.renamed && this.getMode().equals("r")) break;
                this.deleteOnClose();
                break;
            }
        }
        super.close();
    }

    public TempRaf() throws IOException {
        this(0);
    }

    public TempRaf(int keepPolicy) throws IOException {
        this(new RAF(FileUtil.createTempFile(null), "rw"), keepPolicy);
    }

    public TempRaf(RAF raf) {
        this(raf, 0);
    }

    public TempRaf(RAF raf, int keepPolicy) {
        super(raf);
        if (keepPolicy != 3) {
            raf.getFile().deleteOnExit();
        }
        this.keepPolicy = keepPolicy;
    }
}

