/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j;

import java.util.Enumeration;
import java.util.Hashtable;
import org.apache.log4j.Appender;
import org.apache.log4j.Category;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.or.ObjectRenderer;

public class BasicConfigurator {
    public static final String DISABLE_OVERRIDE_KEY = "log4j.disableOverride";
    public static final String INHERITED = "inherited";
    private static /* synthetic */ Class class$Lorg$apache$log4j$or$ObjectRenderer;

    protected void addRenderer(String string, String string2) {
        LogLog.debug("Rendering class: [" + string2 + "], Rendered class: [" + string + "].");
        ObjectRenderer objectRenderer = (ObjectRenderer)OptionConverter.instantiateByClassName(string2, class$Lorg$apache$log4j$or$ObjectRenderer != null ? class$Lorg$apache$log4j$or$ObjectRenderer : (class$Lorg$apache$log4j$or$ObjectRenderer = BasicConfigurator.class$("org.apache.log4j.or.ObjectRenderer")), null);
        if (objectRenderer == null) {
            LogLog.error("Could not isntantiate renderer [" + string2 + "].");
            return;
        }
        try {
            Class<?> clazz = Class.forName(string);
            Category.defaultHierarchy.rendererMap.put(clazz, objectRenderer);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LogLog.error("Could not find class [" + string + "].", classNotFoundException);
        }
    }

    public static void configure() {
        Category category = Category.getRoot();
        category.addAppender(new FileAppender((Layout)new PatternLayout("%r [%t] %p %c %x - %m%n"), System.out));
    }

    public static void configure(Appender appender) {
        Category category = Category.getRoot();
        category.addAppender(appender);
    }

    public static void disable(Priority priority) {
        if (Category.disable != -21) {
            Category.disable = priority.level;
        }
    }

    public static void disableAll() {
        BasicConfigurator.disable(Priority.FATAL);
    }

    public static void disableDebug() {
        BasicConfigurator.disable(Priority.DEBUG);
    }

    public static void disableInfo() {
        BasicConfigurator.disable(Priority.INFO);
    }

    public static void enableAll() {
        Category.disable = -1;
    }

    public static void flagAsShippedCode() {
        BasicConfigurator.disableInfo();
    }

    protected static void overrideAsNeeded(String string) {
        if (string != null) {
            LogLog.debug("Handling non-null disable override directive: \"" + string + "\".");
            if (OptionConverter.toBoolean(string, true)) {
                LogLog.debug("Overriding all disable methods.");
                Category.disable = -21;
            }
        }
    }

    public static void resetConfiguration() {
        Category.defaultHierarchy.getRoot().setPriority(Priority.DEBUG);
        Category.defaultHierarchy.root.setResourceBundle(null);
        Category.disable = -1;
        Hashtable hashtable = Category.defaultHierarchy.ht;
        synchronized (hashtable) {
            Category.defaultHierarchy.shutdown();
            Enumeration enumeration = Category.getCurrentCategories();
            while (enumeration.hasMoreElements()) {
                Category category = (Category)enumeration.nextElement();
                category.setPriority(null);
                category.setAdditivity(true);
                category.setResourceBundle(null);
            }
        }
        Category.defaultHierarchy.rendererMap.clear();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected BasicConfigurator() {
    }

    static {
        String string = null;
        String string2 = DISABLE_OVERRIDE_KEY;
        try {
            string = System.getProperty(string2, string);
        }
        catch (SecurityException securityException) {
            LogLog.debug("Could not read system property \"" + string2 + "\".", securityException);
        }
        if (string != null && OptionConverter.toBoolean(string, true)) {
            LogLog.debug("Overriding disable. Non-null system property log4j.disableOverride=[" + string + "].");
            Category.disable = -21;
        }
    }
}

