Examples of the blink(1) application URL API
============================================

Below is a series of command-line "curl" commands you can use to 
play with the underlying URL API that the blink(1) control application
uses. ("curl" is a command-line program installed on many operating systems
to let you fetch the contents of URLs from the command-line)


Is there a blink(1)?
--------------------

    $ curl 'http://localhost:8934/blink1/id'

    {
      "blink1_id": "3D52B69200000000",
      "blink1_serialnums": [
      ],
      "status": "blink1 id"
    }

- Nope, no blink(1)s detected.
- Autogenerated 'blink1_id' for test IFTTT use, with zeroed out serialnum.
- A blink(1) is not required to test system (e.g. use 'lastColor').


Plug blink(1) in and check again.  Now is there a blink(1)?
----------------------------------------------------------

    $ curl 'http://localhost:8934/blink1/enumerate'
    {
      "blink1_id": "3D52B69201AA1A23",
      "blink1_id_old": "3D52B69200000000",
      "blink1_serialnums": [
        "01AA1A23"
      ],
      "status": "enumerate"
    }

- Yup, there it is. 
- "/blink1/enumerate" causes a bus rescan.  
- New serial number means new blink1_id.
- blink1_id is persistent across application restarts for a given blink(1).
- blink1_id can be regenerated with '/blink1/regenerateid'.


Set the blink(1)'s color to #FFCC33
-----------------------------------

    $ curl 'http://localhost:8934/blink1/fadeToRGB?rgb=%23ffcc00'
    {
      "rgb": "#ffcc00",
      "status": "fadeToRGB: #FFCC00 t:0.100",
      "time": "0.100"
    }

- Must escape the '#' in hex color codes in query arg.
- If "time" is not specified, defaults to "0.1".


Get the last color sent to blink(1)
-----------------------------------

    $ curl 'http://localhost:8934/blink1/lastColor'
    {
      "lastColor": "#FFCC00",
      "status": "lastColor"
    }

- "lastColor" can change on each request if a pattern is running.


--------------------------------------------------------------------------

Color Patterns!
===============

Add some color patterns
-----------------------

Let's create "blink3green" = "blink green 3 times, 1.5 secs on, 0.5 secs off".

    $ curl 'http://localhost:8934/blink1/pattern/add?pname=blink3green&pattern=3,%2300ff00,1.5,%23000000,0.5'
    {
      "pattern": {
        "name": "blink3green",
        "pattern": "3,#00FF00,1.5,#000000,0.5",
        "playcount": 0,
        "playing": false,
        "playpos": 0
        "playedColor": "#000000",
      },
      "status": "pattern add"
    }

And create "policeflash" = "alternate between red & blue, every second, repeat forever".

    $ curl 'http://localhost:8934/blink1/pattern/add?pname=policeflash&pattern=0,%23ff0000,0.5,%230000ff,0.5'
    {
      "pattern": {
        "name": "policeflash",
        "pattern": "0,#FF0000,0.5,#0000FF,0.5",
        "playcount": 0,
        "playedColor": "#000000",
        "playing": false,
        "playpos": 0,
        "repeats": 0
      },
      "status": "pattern add"
    }

- Parsed pattern is returned in "pattern" array for verification.


List color patterns
-------------------

    $ curl 'http://localhost:8934/blink1/pattern' 
    {
      "patterns": [
        {
          "name": "blink3green",
          "pattern": "3,#00FF00,1.5,#000000,0.5",
          "playcount": 0,
          "playedColor": "#000000",
          "playing": false,
          "playpos": 0,
          "repeats": 3
        },
        {
          "name": "policeflash",
          "pattern": "0,#FF0000,0.5,#0000FF,0.5",
          "playcount": 0,
          "playedColor": "#000000",
          "playing": false,
          "playpos": 0,
          "repeats": 0
        }
      ],
      "status": "pattern results"
    }

- Patterns are returned in "patterns" array.
- if "playing" is true, pattern is currently running.
- "playedColor" is last color that was played (if pattern is/was playing).
- "playcount" is how many times (up to "repeats") pattern has played.


Play a pattern
--------------

    $ curl 'http://localhost:8934/blink1/pattern/play?pname=policeflash'
    {
      "status": "pattern 'policeflash' playing"
    }

- Short-lived patterns (repeats>0), will finish and stop themselves.
- Infinite patterns (repeats=0) will repeat forever.


Stop a pattern
--------------

    $ curl 'http://localhost:8934/blink1/pattern/stop?pname=policeflash'
    {
      "status": "pattern 'policeflash' stopped"
    }

- Can use "/blink1/pattern/stopall" to stop all patterns.


Delete a pattern
----------------

    $ curl 'http://localhost:8934/blink1/pattern/del?pname=policeflash'
    {
      "status": "pattern 'policeflash' removed"
    }

- Deleted patterns are stopped.
- Can use "/blink1/pattern/delall" to remove all patterns


--------------------------------------------------------------------------

Data Inputs!
============

Add an URL watching input
-------------------------

Start watching URL "http://todbot.com/tst/color.txt".
I'll call it "mycolorfile".

    $ curl 'http://localhost:8934/blink1/input/url?iname=mycolorfile&arg1=http://todbot.com/tst/color.txt'
    {
      "input": {
        "arg1": "http://todbot.com/tst/color.txt",
        "iname": "mycolorfile",
        "lastVal": "#9970FF",
        "type": "url"
      },
      "status": "input url"
    }

- Parsed input is returned in array called "input".
- On a bad URL, "lastVal" is set to "bad url".
- For this URL, data returned is an RGB hex color code, sent to blink(1) 
- Other URLs can receive pattern names.
- "iname" can be any user-desirable string.
- Input watching happens once on add.
- Input watching continue on next update cycle (every 30 seconds).


Do a test watch of a hex RGB URL input
---------------------------------------

    $ curl 'http://localhost:8934/blink1/input/url?iname=mycolorfile&arg1=http://todbot.com/tst/color.txt&test=true'
    {
      "input": {
        "arg1": "http://todbot.com/tst/color.txt",
        "iname": "mycolorfile",
        "lastVal": "#9970FF",
        "type": "url"
      },
      "status": "input url"
    }

- A test watch of an input does not add it to the input scheduler


Do a test watch of a color pattern URL input
--------------------------------------------

Watch JSON URL "http://todbot.com/tst/pattern.txt" for "pattern" entry:

    $ curl 'http://localhost:8934/blink1/input/url?iname=mypattern&arg1=http://todbot.com/tst/pattern.txt&test=on'
    {
      "input": {
        "arg1": "http://todbot.com/tst/pattern.txt",
        "iname": "mypattern",
        "lastVal": "policeflash",
        "type": "url"
      },
      "status": "input url"
    }

- "lastVal" is a pattern for this URL.


List all inputs
---------------

First let's add a view inputs, same as before:

    $ curl 'http://localhost:8934/blink1/input/url?iname=mycolorfile&arg1=http://todbot.com/tst/color.txt' 
    $ curl 'http://localhost:8934/blink1/input/url?iname=mypattern&arg1=http://todbot.com/tst/pattern.txt'

Now look at the list:

    $ curl 'http://localhost:8934/blink1/inputs'
    {
      "enabled": true,
      "inputs": [
        {
          "arg1": "http://todbot.com/tst/color.txt",
          "iname": "mycolorfile",
          "lastVal": "#9970FF",
          "type": "url"
        },
        {
          "arg1": "http://todbot.com/tst/pattern.txt",
          "iname": "mypattern",
          "lastVal": "policeflash",
          "type": "url"
        }
      ],
      "status": "input results"
    }

- Inputs are returned in "inputs" array.
- Inputs will have a "lastVal" 
- Use "enabled=false" queryarg to turn off running of all inputs
- URL and IFTTT inputs was fetched every 30 seconds


Delete the input
----------------

    $ curl 'http://localhost:8934/blink1/input/del?iname=mycolorfile'
    {
      "status": "input 'mycolorfile' removed"
    }

- can use "/blink1/input/delall" to remove all inputs at once



-eof-
