/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples.media;

import java.io.File;
import twitter4j.TwitterException;
import twitter4j.conf.Configuration;
import twitter4j.conf.ConfigurationBuilder;
import twitter4j.media.ImageUpload;
import twitter4j.media.ImageUploadFactory;
import twitter4j.media.MediaProvider;

public final class PlixiImageUpload {
    public static void main(String[] args) {
        if (args.length < 2) {
            System.out.println("Usage: java twitter4j.examples.media.PlixiImageUpload [API key] [image file path] [message]");
            System.exit(-1);
        }
        try {
            Configuration conf = new ConfigurationBuilder().setMediaProviderAPIKey(args[0]).build();
            ImageUpload upload = new ImageUploadFactory(conf).getInstance(MediaProvider.PLIXI);
            String url = args.length >= 3 ? upload.upload(new File(args[1]), args[2]) : upload.upload(new File(args[1]));
            System.out.println("Successfully uploaded image to Plixi at " + url);
            System.exit(0);
        }
        catch (TwitterException te) {
            te.printStackTrace();
            System.out.println("Failed to upload the image: " + te.getMessage());
            System.exit(-1);
        }
    }
}

