/*
 * Decompiled with CFR 0.152.
 */
package twitter4j.examples.list;

import java.util.Iterator;
import twitter4j.Paging;
import twitter4j.ResponseList;
import twitter4j.Status;
import twitter4j.Twitter;
import twitter4j.TwitterException;
import twitter4j.TwitterFactory;

public final class GetUserListStatuses {
    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: java twitter4j.examples.list.GetUserListStatuses [list id]");
            System.exit(-1);
        }
        try {
            ResponseList statuses;
            Twitter twitter = new TwitterFactory().getInstance();
            Paging page = new Paging(1);
            do {
                statuses = twitter.getUserListStatuses(Integer.parseInt(args[0]), page);
                Iterator i$ = statuses.iterator();
                while (i$.hasNext()) {
                    Status status = (Status)i$.next();
                    System.out.println("@" + status.getUser().getScreenName() + " - " + status.getText());
                }
                page.setPage(page.getPage() + 1);
            } while (statuses.size() > 0 && page.getPage() <= 10);
            System.out.println("done.");
            System.exit(0);
        }
        catch (TwitterException te) {
            te.printStackTrace();
            System.out.println("Failed to list statuses: " + te.getMessage());
            System.exit(-1);
        }
    }
}

