// Copyright © 2015, Peter Atashian
// Licensed under the MIT License <LICENSE.md>
//! FFI bindings to shell32.
#![cfg(windows)]
extern crate winapi;
use winapi::*;
extern "system" {
    // pub fn AssocCreateForClasses();
    // pub fn AssocGetDetailsOfPropKey();
    // pub fn CDefFolderMenu_Create2();
    // pub fn CIDLData_CreateFromIDArray();
    // pub fn CheckEscapesW();
    // pub fn CommandLineToArgvW();
    // pub fn DAD_AutoScroll();
    // pub fn DAD_DragEnterEx();
    // pub fn DAD_DragEnterEx2();
    // pub fn DAD_DragLeave();
    // pub fn DAD_DragMove();
    // pub fn DAD_SetDragImage();
    // pub fn DAD_ShowDragImage();
    // pub fn DoEnvironmentSubstA();
    // pub fn DoEnvironmentSubstW();
    pub fn DragAcceptFiles(hWnd: HWND, fAccept: BOOL);
    pub fn DragFinish(hDrop: HDROP);
    // pub fn DragQueryFile();
    pub fn DragQueryFileA(hDrop: HDROP, iFile: UINT, lpszFile: LPSTR, cch: UINT) -> UINT;
    // pub fn DragQueryFileAorW();
    pub fn DragQueryFileW(hDrop: HDROP, iFile: UINT, lpszFile: LPWSTR, cch: UINT) -> UINT;
    pub fn DragQueryPoint(hDrop: HDROP, lppt: *mut POINT) -> BOOL;
    // pub fn DriveType();
    // pub fn DuplicateIcon();
    // pub fn ExtractAssociatedIconA();
    // pub fn ExtractAssociatedIconExA();
    // pub fn ExtractAssociatedIconExW();
    // pub fn ExtractAssociatedIconW();
    // pub fn ExtractIconA();
    // pub fn ExtractIconEx();
    // pub fn ExtractIconExA();
    // pub fn ExtractIconExW();
    // pub fn ExtractIconW();
    // pub fn FindExecutableA();
    // pub fn FindExecutableW();
    // pub fn GetCurrentProcessExplicitAppUserModelID();
    // pub fn GetFileNameFromBrowse();
    // pub fn ILAppendID();
    // pub fn ILClone();
    // pub fn ILCloneFirst();
    // pub fn ILCombine();
    // pub fn ILCreateFromPath();
    // pub fn ILCreateFromPathA();
    // pub fn ILCreateFromPathW();
    // pub fn ILFindChild();
    // pub fn ILFindLastID();
    // pub fn ILFree();
    // pub fn ILGetNext();
    // pub fn ILGetSize();
    // pub fn ILIsEqual();
    // pub fn ILIsParent();
    // pub fn ILLoadFromStreamEx();
    // pub fn ILRemoveLastID();
    // pub fn ILSaveToStream();
    // pub fn InitNetworkAddressControl();
    // pub fn IsLFNDrive();
    // pub fn IsLFNDriveA();
    // pub fn IsLFNDriveW();
    // pub fn IsNetDrive();
    // pub fn IsUserAnAdmin();
    // pub fn OpenRegStream();
    // pub fn PathCleanupSpec();
    // pub fn PathCleanupSpecWorker();
    // pub fn PathGetShortPath();
    // pub fn PathIsExe();
    // pub fn PathIsExeWorker();
    // pub fn PathIsSlowA();
    // pub fn PathIsSlowW();
    // pub fn PathMakeUniqueName();
    // pub fn PathQualify();
    // pub fn PathResolve();
    // pub fn PathYetAnotherMakeUniqueName();
    // pub fn PickIconDlg();
    // pub fn PifMgr_CloseProperties();
    // pub fn PifMgr_GetProperties();
    // pub fn PifMgr_OpenProperties();
    // pub fn PifMgr_SetProperties();
    // pub fn ReadCabinetState();
    // pub fn RealDriveType();
    // pub fn RestartDialog();
    // pub fn RestartDialogEx();
    // pub fn SHAddDefaultPropertiesByExt();
    // pub fn SHAddFromPropSheetExtArray();
    // pub fn SHAddToRecentDocs();
    // pub fn SHAlloc();
    // pub fn SHAppBarMessage();
    // pub fn SHAssocEnumHandlers();
    // pub fn SHAssocEnumHandlersForProtocolByApplication();
    // pub fn SHBindToFolderIDListParent();
    // pub fn SHBindToFolderIDListParentEx();
    // pub fn SHBindToObject();
    // pub fn SHBindToParent();
    // pub fn SHBrowseForFolder();
    // pub fn SHBrowseForFolderA();
    // pub fn SHBrowseForFolderW();
    // pub fn SHCLSIDFromString();
    // pub fn SHChangeNotification_Lock();
    // pub fn SHChangeNotification_Unlock();
    // pub fn SHChangeNotify();
    // pub fn SHChangeNotifyDeregister();
    // pub fn SHChangeNotifyRegister();
    // pub fn SHChangeNotifyRegisterThread();
    pub fn SHCloneSpecialIDList(hwnd: HWND, csidl: c_int, fCreate: BOOL) -> PIDLIST_ABSOLUTE;
    // pub fn SHCoCreateInstance();
    // pub fn SHCoCreateInstanceWorker();
    // pub fn SHCreateAssociationRegistration();
    // pub fn SHCreateDataObject();
    // pub fn SHCreateDefaultContextMenu();
    // pub fn SHCreateDefaultExtractIcon();
    // pub fn SHCreateDefaultPropertiesOp();
    pub fn SHCreateDirectory(hwnd: HWND, pszPath: PCWSTR) -> c_int;
    pub fn SHCreateDirectoryExA(
        hwnd: HWND, pszPath: LPCSTR, psa: *const SECURITY_ATTRIBUTES,
    ) -> c_int;
    pub fn SHCreateDirectoryExW(
        hwnd: HWND, pszPath: LPCWSTR, psa: *const SECURITY_ATTRIBUTES,
    ) -> c_int;
    // pub fn SHCreateDirectoryExWWorker();
    // pub fn SHCreateFileExtractIconW();
    // pub fn SHCreateItemFromIDList();
    // pub fn SHCreateItemFromParsingName();
    // pub fn SHCreateItemFromRelativeName();
    // pub fn SHCreateItemInKnownFolder();
    // pub fn SHCreateItemWithParent();
    // pub fn SHCreateProcessAsUserW();
    // pub fn SHCreatePropSheetExtArray();
    // pub fn SHCreateQueryCancelAutoPlayMoniker();
    // pub fn SHCreateShellFolderView();
    // pub fn SHCreateShellFolderViewEx();
    pub fn SHCreateShellItem(
        pidlParent: PCIDLIST_ABSOLUTE, psfParent: *mut IShellFolder, pidl: PCUITEMID_CHILD,
        ppsi: *mut *mut IShellItem,
    ) -> HRESULT;
    // pub fn SHCreateShellItemArray();
    // pub fn SHCreateShellItemArrayFromDataObject();
    // pub fn SHCreateShellItemArrayFromIDLists();
    // pub fn SHCreateShellItemArrayFromShellItem();
    // pub fn SHCreateStdEnumFmtEtc();
    // pub fn SHDefExtractIconA();
    // pub fn SHDefExtractIconW();
    // pub fn SHDestroyPropSheetExtArray();
    // pub fn SHDoDragDrop();
    // pub fn SHEmptyRecycleBinA();
    // pub fn SHEmptyRecycleBinW();
    // pub fn SHEnumerateUnreadMailAccountsW();
    // pub fn SHEvaluateSystemCommandTemplate();
    // pub fn SHFileOperation();
    // pub fn SHFileOperationA();
    // pub fn SHFileOperationW();
    // pub fn SHFindFiles();
    // pub fn SHFind_InitMenuPopup();
    pub fn SHFlushSFCache();
    // pub fn SHFormatDrive();
    // pub fn SHFree();
    // pub fn SHFreeNameMappings();
    // pub fn SHGetAttributesFromDataObject();
    // pub fn SHGetDataFromIDListA();
    // pub fn SHGetDataFromIDListW();
    // pub fn SHGetDesktopFolder();
    // pub fn SHGetDesktopFolderWorker();
    // pub fn SHGetDiskFreeSpaceA();
    // pub fn SHGetDiskFreeSpaceExA();
    // pub fn SHGetDiskFreeSpaceExW();
    // pub fn SHGetDriveMedia();
    // pub fn SHGetFileInfo();
    // pub fn SHGetFileInfoA();
    // pub fn SHGetFileInfoW();
    // pub fn SHGetFileInfoWWorker();
    pub fn SHGetFolderLocation(
        hwnd: HWND, csidl: c_int, hToken: HANDLE, dwFlags: DWORD, ppidl: *mut PIDLIST_ABSOLUTE,
    ) -> HRESULT;
    // pub fn SHGetFolderLocationWorker();
    pub fn SHGetFolderPathA(
        hwnd: HWND, csidl: c_int, hToken: HANDLE, dwFlags: DWORD, pszPath: LPSTR,
    ) -> HRESULT;
    // pub fn SHGetFolderPathAWorker();
    pub fn SHGetFolderPathAndSubDirA(
        hwnd: HWND, csidl: c_int, hToken: HANDLE, dwFlags: DWORD, pszSubDir: LPCSTR,
        pszPath: LPSTR,
    ) -> HRESULT;
    pub fn SHGetFolderPathAndSubDirW(
        hwnd: HWND, csidl: c_int, hToken: HANDLE, dwFlags: DWORD, pszSubDir: LPCWSTR,
        pszPath: LPWSTR,
    ) -> HRESULT;
    // pub fn SHGetFolderPathAndSubDirWWorker();
    // pub fn SHGetFolderPathEx();
    pub fn SHGetFolderPathW(
        hwnd: HWND, csidl: c_int, hToken: HANDLE, dwFlags: DWORD, pszPath: LPWSTR,
    ) -> HRESULT;
    // pub fn SHGetFolderPathWWorker();
    // pub fn SHGetIDListFromObject();
    pub fn SHGetIconOverlayIndexA(pszIconPath: LPCSTR, iIconIndex: c_int) -> c_int;
    pub fn SHGetIconOverlayIndexW(pszIconPath: LPCWSTR, iIconIndex: c_int) -> c_int;
    // pub fn SHGetImageList();
    // pub fn SHGetInstanceExplorer();
    // pub fn SHGetInstanceExplorerWorker();
    // pub fn SHGetItemFromDataObject();
    // pub fn SHGetItemFromObject();
    pub fn SHGetKnownFolderIDList(
        rfid: REFKNOWNFOLDERID, dwFlags: DWORD, hToken: HANDLE, ppidl: *mut PIDLIST_ABSOLUTE,
    ) -> HRESULT;
    pub fn SHGetKnownFolderItem(
        rfid: REFKNOWNFOLDERID, flags: KNOWN_FOLDER_FLAG, hToken: HANDLE, riid: REFIID,
        ppv: *mut *mut c_void,
    ) -> HRESULT;
    pub fn SHGetKnownFolderPath(
        rfid: REFKNOWNFOLDERID, dwFlags: DWORD, hToken: HANDLE, pszPath: *mut PWSTR,
    ) -> HRESULT;
    // pub fn SHGetKnownFolderPathWorker();
    // pub fn SHGetLocalizedName();
    // pub fn SHGetMalloc();
    // pub fn SHGetNameFromIDList();
    // pub fn SHGetNewLinkInfoA();
    // pub fn SHGetNewLinkInfoW();
    // pub fn SHGetPathFromIDList();
    pub fn SHGetPathFromIDListA(pidl: PCIDLIST_ABSOLUTE, pszPath: LPSTR) -> BOOL;
    pub fn SHGetPathFromIDListEx(
        pidl: PCIDLIST_ABSOLUTE, pszPath: PWSTR, cchPath: DWORD, uOpts: GPFIDL_FLAGS,
    ) -> BOOL;
    pub fn SHGetPathFromIDListW(pidl: PCIDLIST_ABSOLUTE, pszPath: LPWSTR) -> BOOL;
    // pub fn SHGetPropertyStoreForWindow();
    // pub fn SHGetPropertyStoreFromIDList();
    // pub fn SHGetPropertyStoreFromParsingName();
    // pub fn SHGetRealIDL();
    // pub fn SHGetSetFolderCustomSettings();
    // pub fn SHGetSetSettings();
    // pub fn SHGetSettings();
    pub fn SHGetSpecialFolderLocation(
        hwnd: HWND, csidl: c_int, ppidl: *mut PIDLIST_ABSOLUTE,
    ) -> HRESULT;
    // pub fn SHGetSpecialFolderPath();
    pub fn SHGetSpecialFolderPathA(
        hwnd: HWND, pszPath: LPSTR, csidl: c_int, fCreate: BOOL,
    ) -> BOOL;
    // pub fn SHGetSpecialFolderPathAWorker();
    pub fn SHGetSpecialFolderPathW(
        hwnd: HWND, pszPath: LPWSTR, csidl: c_int, fCreate: BOOL,
    ) -> BOOL;
    // pub fn SHGetSpecialFolderPathWWorker();
    // pub fn SHGetStockIconInfo();
    // pub fn SHGetTemporaryPropertyForItem();
    // pub fn SHGetUnreadMailCountW();
    // pub fn SHHandleUpdateImage();
    // pub fn SHILCreateFromPath();
    // pub fn SHInvokePrinterCommandA();
    // pub fn SHInvokePrinterCommandW();
    // pub fn SHIsFileAvailableOffline();
    // pub fn SHLimitInputEdit();
    // pub fn SHLoadInProc();
    // pub fn SHLoadNonloadedIconOverlayIdentifiers();
    // pub fn SHMapPIDLToSystemImageListIndex();
    // pub fn SHMultiFileProperties();
    // pub fn SHObjectProperties();
    pub fn SHOpenFolderAndSelectItems(
        pidlFolder: PCIDLIST_ABSOLUTE, cidl: UINT, apidl: PCUITEMID_CHILD_ARRAY, dwFlags: DWORD,
    ) -> HRESULT;
    // pub fn SHOpenPropSheetW();
    // pub fn SHOpenWithDialog();
    // pub fn SHParseDisplayName();
    // pub fn SHPathPrepareForWriteA();
    // pub fn SHPathPrepareForWriteW();
    // pub fn SHPropStgCreate();
    // pub fn SHPropStgReadMultiple();
    // pub fn SHPropStgWriteMultiple();
    // pub fn SHQueryRecycleBinA();
    // pub fn SHQueryRecycleBinW();
    // pub fn SHQueryUserNotificationState();
    // pub fn SHRemoveLocalizedName();
    // pub fn SHReplaceFromPropSheetExtArray();
    // pub fn SHResolveLibrary();
    // pub fn SHRestricted();
    // pub fn SHSetDefaultProperties();
    pub fn SHSetFolderPathA(
        csidl: c_int, hToken: HANDLE, dwFlags: DWORD, pszPath: LPCSTR,
    ) -> HRESULT;
    pub fn SHSetFolderPathW(
        csidl: c_int, hToken: HANDLE, dwFlags: DWORD, pszPath: LPCWSTR,
    ) -> HRESULT;
    // pub fn SHSetInstanceExplorer();
    pub fn SHSetKnownFolderPath(
        rfid: REFKNOWNFOLDERID, dwFlags: DWORD, hToken: HANDLE, pszPath: PCWSTR,
    ) -> HRESULT;
    // pub fn SHSetKnownFolderPathWorker();
    // pub fn SHSetLocalizedName();
    // pub fn SHSetTemporaryPropertyForItem();
    // pub fn SHSetUnreadMailCountW();
    // pub fn SHShellFolderView_Message();
    // pub fn SHShowManageLibraryUI();
    // pub fn SHSimpleIDListFromPath();
    // pub fn SHStartNetConnectionDialogW();
    // pub fn SHTestTokenMembership();
    // pub fn SHUpdateImageA();
    // pub fn SHUpdateImageW();
    // pub fn SHValidateUNC();
    // pub fn SetCurrentProcessExplicitAppUserModelID();
    // pub fn ShellAboutA();
    // pub fn ShellAboutW();
    pub fn ShellExecuteA(
        hwnd: HWND, lpOperation: LPCSTR, lpFile: LPCSTR, lpParameters: LPCSTR, lpDirectory: LPCSTR,
        nShowCmd: c_int
    ) -> HINSTANCE;
    // pub fn ShellExecuteEx();
    // pub fn ShellExecuteExA();
    // pub fn ShellExecuteExW();
    pub fn ShellExecuteW(
        hwnd: HWND, lpOperation: LPCWSTR, lpFile: LPCWSTR, lpParameters: LPCWSTR,
        lpDirectory: LPCWSTR, nShowCmd: c_int
    ) -> HINSTANCE;
    // pub fn ShellHookProc();
    // pub fn Shell_GetCachedImageIndex();
    // pub fn Shell_GetCachedImageIndexA();
    // pub fn Shell_GetCachedImageIndexW();
    // pub fn Shell_GetImageLists();
    // pub fn Shell_MergeMenus();
     pub fn Shell_NotifyIconA(dwMessage: DWORD, lpData: PNOTIFYICONDATAA) -> BOOL;
     pub fn Shell_NotifyIconW(dwMessage: DWORD, lpData: PNOTIFYICONDATAW) -> BOOL;
    // pub fn Shell_NotifyIconGetRect();
    // pub fn SignalFileOpen();
    // pub fn StgMakeUniqueName();
    // pub fn WOWShellExecute();
    // pub fn Win32DeleteFile();
    // pub fn WriteCabinetState();
}
#[cfg(any(target_arch = "x86", target_arch = "x86_64", target_arch = "arm"))]
extern {
    // pub static BHID_AssociationArray;
    // pub static BHID_DataObject;
    // pub static BHID_EnumAssocHandlers;
    // pub static BHID_EnumItems;
    // pub static BHID_FilePlaceholder;
    // pub static BHID_Filter;
    // pub static BHID_LinkTargetItem;
    // pub static BHID_PropertyStore;
    // pub static BHID_RandomAccessStream;
    // pub static BHID_SFObject;
    // pub static BHID_SFUIObject;
    // pub static BHID_SFViewObject;
    // pub static BHID_Storage;
    // pub static BHID_StorageEnum;
    // pub static BHID_Stream;
    // pub static BHID_ThumbnailHandler;
    // pub static BHID_Transfer;
    // pub static CATID_BrowsableShellExt;
    // pub static CATID_BrowseInPlace;
    // pub static CATID_CommBand;
    // pub static CATID_DeskBand;
    // pub static CATID_FilePlaceholderMergeHandler;
    // pub static CATID_InfoBand;
    // pub static CATID_LocationFactory;
    // pub static CATID_LocationProvider;
    // pub static CATID_SearchableApplication;
    // pub static CGID_DefView;
    // pub static CGID_Explorer;
    // pub static CGID_ExplorerBarDoc;
    // pub static CGID_MENUDESKBAR;
    // pub static CGID_ShellDocView;
    // pub static CGID_ShellServiceObject;
    // pub static CGID_ShortCut;
    // pub static CLSID_ACLCustomMRU;
    // pub static CLSID_ACLHistory;
    // pub static CLSID_ACLMRU;
    // pub static CLSID_ACLMulti;
    // pub static CLSID_ACListISF;
    // pub static CLSID_ActiveDesktop;
    // pub static CLSID_AutoComplete;
    // pub static CLSID_CAnchorBrowsePropertyPage;
    // pub static CLSID_CDocBrowsePropertyPage;
    // pub static CLSID_CFSIconOverlayManager;
    // pub static CLSID_CImageBrowsePropertyPage;
    // pub static CLSID_CURLSearchHook;
    // pub static CLSID_CUrlHistory;
    // pub static CLSID_ControlPanel;
    // pub static CLSID_DarwinAppPublisher;
    // pub static CLSID_DocHostUIHandler;
    // pub static CLSID_DragDropHelper;
    // pub static CLSID_FileTypes;
    // pub static CLSID_FolderItem;
    // pub static CLSID_FolderItemsMultiLevel;
    // pub static CLSID_FolderShortcut;
    // pub static CLSID_HWShellExecute;
    // pub static CLSID_ISFBand;
    // pub static CLSID_Internet;
    // pub static CLSID_InternetButtons;
    // pub static CLSID_InternetShortcut;
    // pub static CLSID_LinkColumnProvider;
    // pub static CLSID_MSOButtons;
    // pub static CLSID_MenuBand;
    // pub static CLSID_MenuBandSite;
    // pub static CLSID_MenuToolbarBase;
    // pub static CLSID_MyComputer;
    // pub static CLSID_MyDocuments;
    // pub static CLSID_NetworkDomain;
    // pub static CLSID_NetworkServer;
    // pub static CLSID_NetworkShare;
    // pub static CLSID_NewMenu;
    // pub static CLSID_Printers;
    // pub static CLSID_ProgressDialog;
    // pub static CLSID_QueryAssociations;
    // pub static CLSID_QuickLinks;
    // pub static CLSID_RecycleBin;
    // pub static CLSID_ShellFldSetExt;
    // pub static CLSID_ToolbarExtButtons;
    // pub static CPFG_CREDENTIAL_PROVIDER_LABEL;
    // pub static CPFG_CREDENTIAL_PROVIDER_LOGO;
    // pub static CPFG_LOGON_PASSWORD;
    // pub static CPFG_LOGON_USERNAME;
    // pub static CPFG_SMARTCARD_PIN;
    // pub static CPFG_SMARTCARD_USERNAME;
    // pub static EP_AdvQueryPane;
    // pub static EP_Commands;
    // pub static EP_Commands_Organize;
    // pub static EP_Commands_View;
    // pub static EP_DetailsPane;
    // pub static EP_NavPane;
    // pub static EP_PreviewPane;
    // pub static EP_QueryPane;
    // pub static EP_Ribbon;
    // pub static EP_StatusBar;
    // pub static FMTID_Briefcase;
    // pub static FMTID_CustomImageProperties;
    // pub static FMTID_DRM;
    // pub static FMTID_Displaced;
    // pub static FMTID_ImageProperties;
    // pub static FMTID_InternetSite;
    // pub static FMTID_Intshcut;
    // pub static FMTID_LibraryProperties;
    // pub static FMTID_MUSIC;
    // pub static FMTID_Misc;
    // pub static FMTID_Query;
    // pub static FMTID_ShellDetails;
    // pub static FMTID_Storage;
    // pub static FMTID_Volume;
    // pub static FMTID_WebView;
    // pub static FOLDERID_AccountPictures;
    // pub static FOLDERID_AddNewPrograms;
    // pub static FOLDERID_AdminTools;
    // pub static FOLDERID_AppUpdates;
    // pub static FOLDERID_ApplicationShortcuts;
    // pub static FOLDERID_AppsFolder;
    // pub static FOLDERID_CDBurning;
    // pub static FOLDERID_CameraRoll;
    // pub static FOLDERID_ChangeRemovePrograms;
    // pub static FOLDERID_CommonAdminTools;
    // pub static FOLDERID_CommonOEMLinks;
    // pub static FOLDERID_CommonPrograms;
    // pub static FOLDERID_CommonStartMenu;
    // pub static FOLDERID_CommonStartup;
    // pub static FOLDERID_CommonTemplates;
    // pub static FOLDERID_ComputerFolder;
    // pub static FOLDERID_ConflictFolder;
    // pub static FOLDERID_ConnectionsFolder;
    // pub static FOLDERID_Contacts;
    // pub static FOLDERID_ControlPanelFolder;
    // pub static FOLDERID_Cookies;
    // pub static FOLDERID_Desktop;
    // pub static FOLDERID_DeviceMetadataStore;
    // pub static FOLDERID_Documents;
    // pub static FOLDERID_DocumentsLibrary;
    // pub static FOLDERID_Downloads;
    // pub static FOLDERID_Favorites;
    // pub static FOLDERID_Fonts;
    // pub static FOLDERID_GameTasks;
    // pub static FOLDERID_Games;
    // pub static FOLDERID_History;
    // pub static FOLDERID_HomeGroup;
    // pub static FOLDERID_HomeGroupCurrentUser;
    // pub static FOLDERID_ImplicitAppShortcuts;
    // pub static FOLDERID_InternetCache;
    // pub static FOLDERID_InternetFolder;
    // pub static FOLDERID_Libraries;
    // pub static FOLDERID_Links;
    // pub static FOLDERID_LocalAppData;
    // pub static FOLDERID_LocalAppDataLow;
    // pub static FOLDERID_LocalizedResourcesDir;
    // pub static FOLDERID_Music;
    // pub static FOLDERID_MusicLibrary;
    // pub static FOLDERID_NetHood;
    // pub static FOLDERID_NetworkFolder;
    // pub static FOLDERID_OriginalImages;
    // pub static FOLDERID_PhotoAlbums;
    // pub static FOLDERID_Pictures;
    // pub static FOLDERID_PicturesLibrary;
    // pub static FOLDERID_Playlists;
    // pub static FOLDERID_PrintHood;
    // pub static FOLDERID_PrintersFolder;
    // pub static FOLDERID_Profile;
    // pub static FOLDERID_ProgramData;
    // pub static FOLDERID_ProgramFiles;
    // pub static FOLDERID_ProgramFilesCommon;
    // pub static FOLDERID_ProgramFilesCommonX64;
    // pub static FOLDERID_ProgramFilesCommonX86;
    // pub static FOLDERID_ProgramFilesX64;
    // pub static FOLDERID_ProgramFilesX86;
    // pub static FOLDERID_Programs;
    // pub static FOLDERID_Public;
    // pub static FOLDERID_PublicDesktop;
    // pub static FOLDERID_PublicDocuments;
    // pub static FOLDERID_PublicDownloads;
    // pub static FOLDERID_PublicGameTasks;
    // pub static FOLDERID_PublicLibraries;
    // pub static FOLDERID_PublicMusic;
    // pub static FOLDERID_PublicPictures;
    // pub static FOLDERID_PublicRingtones;
    // pub static FOLDERID_PublicUserTiles;
    // pub static FOLDERID_PublicVideos;
    // pub static FOLDERID_QuickLaunch;
    // pub static FOLDERID_Recent;
    // pub static FOLDERID_RecordedTVLibrary;
    // pub static FOLDERID_RecycleBinFolder;
    // pub static FOLDERID_ResourceDir;
    // pub static FOLDERID_Ringtones;
    // pub static FOLDERID_RoamedTileImages;
    // pub static FOLDERID_RoamingAppData;
    // pub static FOLDERID_RoamingTiles;
    // pub static FOLDERID_SEARCH_CSC;
    // pub static FOLDERID_SEARCH_MAPI;
    // pub static FOLDERID_SampleMusic;
    // pub static FOLDERID_SamplePictures;
    // pub static FOLDERID_SamplePlaylists;
    // pub static FOLDERID_SampleVideos;
    // pub static FOLDERID_SavedGames;
    // pub static FOLDERID_SavedSearches;
    // pub static FOLDERID_Screenshots;
    // pub static FOLDERID_SearchHistory;
    // pub static FOLDERID_SearchHome;
    // pub static FOLDERID_SearchTemplates;
    // pub static FOLDERID_SendTo;
    // pub static FOLDERID_SidebarDefaultParts;
    // pub static FOLDERID_SidebarParts;
    // pub static FOLDERID_SkyDrive;
    // pub static FOLDERID_SkyDriveCameraRoll;
    // pub static FOLDERID_SkyDriveDocuments;
    // pub static FOLDERID_SkyDriveMusic;
    // pub static FOLDERID_SkyDrivePictures;
    // pub static FOLDERID_StartMenu;
    // pub static FOLDERID_Startup;
    // pub static FOLDERID_SyncManagerFolder;
    // pub static FOLDERID_SyncResultsFolder;
    // pub static FOLDERID_SyncSetupFolder;
    // pub static FOLDERID_System;
    // pub static FOLDERID_SystemX86;
    // pub static FOLDERID_Templates;
    // pub static FOLDERID_UserPinned;
    // pub static FOLDERID_UserProfiles;
    // pub static FOLDERID_UserProgramFiles;
    // pub static FOLDERID_UserProgramFilesCommon;
    // pub static FOLDERID_UsersFiles;
    // pub static FOLDERID_UsersLibraries;
    // pub static FOLDERID_Videos;
    // pub static FOLDERID_VideosLibrary;
    // pub static FOLDERID_Windows;
    // pub static FOLDERTYPEID_AccountPictures;
    // pub static FOLDERTYPEID_Communications;
    // pub static FOLDERTYPEID_CompressedFolder;
    // pub static FOLDERTYPEID_Contacts;
    // pub static FOLDERTYPEID_ControlPanelCategory;
    // pub static FOLDERTYPEID_ControlPanelClassic;
    // pub static FOLDERTYPEID_Documents;
    // pub static FOLDERTYPEID_Games;
    // pub static FOLDERTYPEID_Generic;
    // pub static FOLDERTYPEID_GenericLibrary;
    // pub static FOLDERTYPEID_GenericSearchResults;
    // pub static FOLDERTYPEID_Invalid;
    // pub static FOLDERTYPEID_Music;
    // pub static FOLDERTYPEID_NetworkExplorer;
    // pub static FOLDERTYPEID_OpenSearch;
    // pub static FOLDERTYPEID_OtherUsers;
    // pub static FOLDERTYPEID_Pictures;
    // pub static FOLDERTYPEID_Printers;
    // pub static FOLDERTYPEID_PublishedItems;
    // pub static FOLDERTYPEID_RecordedTV;
    // pub static FOLDERTYPEID_RecycleBin;
    // pub static FOLDERTYPEID_SavedGames;
    // pub static FOLDERTYPEID_SearchConnector;
    // pub static FOLDERTYPEID_SearchHome;
    // pub static FOLDERTYPEID_Searches;
    // pub static FOLDERTYPEID_SoftwareExplorer;
    // pub static FOLDERTYPEID_StartMenu;
    // pub static FOLDERTYPEID_StorageProviderDocuments;
    // pub static FOLDERTYPEID_StorageProviderGeneric;
    // pub static FOLDERTYPEID_StorageProviderMusic;
    // pub static FOLDERTYPEID_StorageProviderPictures;
    // pub static FOLDERTYPEID_StorageProviderVideos;
    // pub static FOLDERTYPEID_UserFiles;
    // pub static FOLDERTYPEID_UsersLibraries;
    // pub static FOLDERTYPEID_Videos;
    // pub static IID_CDefView;
    // pub static IID_IACList;
    // pub static IID_IACList2;
    // pub static IID_IADesktopP2;
    // pub static IID_IActiveDesktop;
    // pub static IID_IActiveDesktopP;
    // pub static IID_IBanneredBar;
    // pub static IID_IBriefcaseStg;
    // pub static IID_IColumnProvider;
    // pub static IID_ICommDlgBrowser;
    // pub static IID_ICommDlgBrowser2;
    // pub static IID_IContextMenu;
    // pub static IID_IContextMenu2;
    // pub static IID_IContextMenu3;
    // pub static IID_ICopyHookA;
    // pub static IID_ICopyHookW;
    // pub static IID_ICurrentWorkingDirectory;
    // pub static IID_IDefViewFrame;
    // pub static IID_IDefViewID;
    // pub static IID_IDiscardableBrowserProperty;
    // pub static IID_IDocViewSite;
    // pub static IID_IDockingWindowFrame;
    // pub static IID_IDockingWindowSite;
    // pub static IID_IEnumExtraSearch;
    // pub static IID_IEnumIDList;
    // pub static IID_IExtractIconA;
    // pub static IID_IExtractIconW;
    // pub static IID_IFileSystemBindData;
    // pub static IID_IFileViewerA;
    // pub static IID_IFileViewerSite;
    // pub static IID_IFileViewerW;
    // pub static IID_INamedPropertyBag;
    // pub static IID_INewShortcutHookA;
    // pub static IID_INewShortcutHookW;
    // pub static IID_IObjMgr;
    // pub static IID_IPersistFolder;
    // pub static IID_IProgressDialog;
    // pub static IID_IPropSheetPage;
    // pub static IID_IQueryAssociations;
    // pub static IID_IQueryInfo;
    // pub static IID_IRemoteComputer;
    // pub static IID_ISearchContext;
    // pub static IID_IShellBrowser;
    // pub static IID_IShellChangeNotify;
    // pub static IID_IShellDetails;
    // pub static IID_IShellExecuteHookA;
    // pub static IID_IShellExecuteHookW;
    // pub static IID_IShellExtInit;
    // pub static IID_IShellFolder;
    // pub static IID_IShellFolder2;
    // pub static IID_IShellFolderBand;
    // pub static IID_IShellFolderViewCB;
    // pub static IID_IShellIcon;
    // pub static IID_IShellIconOverlay;
    // pub static IID_IShellIconOverlayIdentifier;
    // pub static IID_IShellIconOverlayManager;
    // pub static IID_IShellImageStore;
    // pub static IID_IShellLinkA;
    // pub static IID_IShellLinkW;
    // pub static IID_IShellPropSheetExt;
    // pub static IID_IShellView;
    // pub static IID_IShellView2;
    // pub static IID_ISynchronizedCallBack;
    // pub static IID_IThumbnailCapture;
    // pub static IID_IURLSearchHook;
    // pub static IID_IURLSearchHook2;
    // pub static IID_IUniformResourceLocatorA;
    // pub static IID_IUniformResourceLocatorW;
    // pub static ItemCount_Property_GUID;
    // pub static ItemIndex_Property_GUID;
    // pub static SID_CommandsPropertyBag;
    // pub static SID_CtxQueryAssociations;
    // pub static SID_DefView;
    // pub static SID_MenuShellFolder;
    // pub static SID_SCommDlgBrowser;
    // pub static SID_SGetViewFromViewDual;
    // pub static SID_SInPlaceBrowser;
    // pub static SID_SMenuBandBKContextMenu;
    // pub static SID_SMenuBandBottom;
    // pub static SID_SMenuBandBottomSelected;
    // pub static SID_SMenuBandChild;
    // pub static SID_SMenuBandContextMenuModifier;
    // pub static SID_SMenuBandParent;
    // pub static SID_SMenuBandTop;
    // pub static SID_SMenuPopup;
    // pub static SID_SSearchBoxInfo;
    // pub static SID_STopLevelBrowser;
    // pub static SID_STopWindow;
    // pub static SYNCMGR_OBJECTID_BrowseContent;
    // pub static SYNCMGR_OBJECTID_ConflictStore;
    // pub static SYNCMGR_OBJECTID_EventLinkClick;
    // pub static SYNCMGR_OBJECTID_EventStore;
    // pub static SYNCMGR_OBJECTID_Icon;
    // pub static SYNCMGR_OBJECTID_QueryBeforeActivate;
    // pub static SYNCMGR_OBJECTID_QueryBeforeDeactivate;
    // pub static SYNCMGR_OBJECTID_QueryBeforeDelete;
    // pub static SYNCMGR_OBJECTID_QueryBeforeDisable;
    // pub static SYNCMGR_OBJECTID_QueryBeforeEnable;
    // pub static SYNCMGR_OBJECTID_ShowSchedule;
    // pub static SelectedItemCount_Property_GUID;
    // pub static VID_Content;
    // pub static VID_Details;
    // pub static VID_LargeIcons;
    // pub static VID_List;
    // pub static VID_SmallIcons;
    // pub static VID_ThumbStrip;
    // pub static VID_Thumbnails;
    // pub static VID_Tile;
}
