--
-- TEXT
--
SELECT
    text 'this is a text string' = text 'this is a text string' AS true;

SELECT
    text 'this is a text string' = text 'this is a text strin' AS false;

CREATE TABLE TEXT_TBL (
    f1 text
);

INSERT INTO TEXT_TBL
    VALUES ('doh!');

INSERT INTO TEXT_TBL
    VALUES ('hi de ho neighbor');

SELECT
    '' AS two,
    *
FROM
    TEXT_TBL;

-- As of 8.3 we have removed most implicit casts to text, so that for example
-- this no longer works:
SELECT
    length(42);

-- But as a special exception for usability's sake, we still allow implicit
-- casting to text in concatenations, so long as the other input is text or
-- an unknown literal.  So these work:
SELECT
    'four: '::text || 2 + 2;

SELECT
    'four: ' || 2 + 2;

-- but not this:
SELECT
    3 || 4.0;


/*
 * various string functions
 */
SELECT
    concat('one');

SELECT
    concat(1, 2, 3, 'hello', TRUE, FALSE, to_date('20100309', 'YYYYMMDD'));

SELECT
    concat_ws('#', 'one');

SELECT
    concat_ws('#', 1, 2, 3, 'hello', TRUE, FALSE, to_date('20100309', 'YYYYMMDD'));

SELECT
    concat_ws(',', 10, 20, NULL, 30);

SELECT
    concat_ws('', 10, 20, NULL, 30);

SELECT
    concat_ws(NULL, 10, 20, NULL, 30) IS NULL;

SELECT
    reverse('abcde');

SELECT
    i,
    LEFT ('ahoj',
        i),
    RIGHT ('ahoj',
        i)
FROM
    generate_series(- 5, 5) t (i)
ORDER BY
    i;

SELECT
    quote_literal('');

SELECT
    quote_literal('abc''');

SELECT
    quote_literal(e'\\');

-- check variadic labeled argument
SELECT
    concat(VARIADIC ARRAY[1, 2, 3]);

SELECT
    concat_ws(',', VARIADIC ARRAY[1, 2, 3]);

SELECT
    concat_ws(',', VARIADIC NULL::int[]);

SELECT
    concat(VARIADIC NULL::int[]) IS NULL;

SELECT
    concat(VARIADIC '{}'::int[]) = '';

--should fail
SELECT
    concat_ws(',', VARIADIC 10);


/*
 * format
 */
SELECT
    format(NULL);

SELECT
    format('Hello');

SELECT
    format('Hello %s', 'World');

SELECT
    format('Hello %%');

SELECT
    format('Hello %%%%');

-- should fail
SELECT
    format('Hello %s %s', 'World');

SELECT
    format('Hello %s');

SELECT
    format('Hello %x', 20);

-- check literal and sql identifiers
SELECT
    format('INSERT INTO %I VALUES(%L,%L)', 'mytab', 10, 'Hello');

SELECT
    format('%s%s%s', 'Hello', NULL, 'World');

SELECT
    format('INSERT INTO %I VALUES(%L,%L)', 'mytab', 10, NULL);

SELECT
    format('INSERT INTO %I VALUES(%L,%L)', 'mytab', NULL, 'Hello');

-- should fail, sql identifier cannot be NULL
SELECT
    format('INSERT INTO %I VALUES(%L,%L)', NULL, 10, 'Hello');

-- check positional placeholders
SELECT
    format('%1$s %3$s', 1, 2, 3);

SELECT
    format('%1$s %12$s', 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);

-- should fail
SELECT
    format('%1$s %4$s', 1, 2, 3);

SELECT
    format('%1$s %13$s', 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12);

SELECT
    format('%0$s', 'Hello');

SELECT
    format('%*0$s', 'Hello');

SELECT
    format('%1$', 1);

SELECT
    format('%1$1', 1);

-- check mix of positional and ordered placeholders
SELECT
    format('Hello %s %1$s %s', 'World', 'Hello again');

SELECT
    format('Hello %s %s, %2$s %2$s', 'World', 'Hello again');

-- check variadic labeled arguments
SELECT
    format('%s, %s', VARIADIC ARRAY['Hello', 'World']);

SELECT
    format('%s, %s', VARIADIC ARRAY[1, 2]);

SELECT
    format('%s, %s', VARIADIC ARRAY[TRUE, FALSE]);

SELECT
    format('%s, %s', VARIADIC ARRAY[TRUE, FALSE]::text[]);

-- check variadic with positional placeholders
SELECT
    format('%2$s, %1$s', VARIADIC ARRAY['first', 'second']);

SELECT
    format('%2$s, %1$s', VARIADIC ARRAY[1, 2]);

-- variadic argument can be array type NULL, but should not be referenced
SELECT
    format('Hello', VARIADIC NULL::int[]);

-- variadic argument allows simulating more than FUNC_MAX_ARGS parameters
SELECT
    format(string_agg('%s', ','), VARIADIC array_agg(i))
FROM
    generate_series(1, 200) g (i);

-- check field widths and left, right alignment
SELECT
    format('>>%10s<<', 'Hello');

SELECT
    format('>>%10s<<', NULL);

SELECT
    format('>>%10s<<', '');

SELECT
    format('>>%-10s<<', '');

SELECT
    format('>>%-10s<<', 'Hello');

SELECT
    format('>>%-10s<<', NULL);

SELECT
    format('>>%1$10s<<', 'Hello');

SELECT
    format('>>%1$-10I<<', 'Hello');

SELECT
    format('>>%2$*1$L<<', 10, 'Hello');

SELECT
    format('>>%2$*1$L<<', 10, NULL);

SELECT
    format('>>%2$*1$L<<', - 10, NULL);

SELECT
    format('>>%*s<<', 10, 'Hello');

SELECT
    format('>>%*1$s<<', 10, 'Hello');

SELECT
    format('>>%-s<<', 'Hello');

SELECT
    format('>>%10L<<', NULL);

SELECT
    format('>>%2$*1$L<<', NULL, 'Hello');

SELECT
    format('>>%2$*1$L<<', 0, 'Hello');

