/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.misc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;
import org.eso.util.misc.DefaultDaemonThreadFactory;

public class ThreadWatchdog {
    static final Logger logger = Logger.getLogger(ThreadWatchdog.class);
    private static final String classLogName = "ThreadWatchdog";
    private static final ThreadWatchdog instance = new ThreadWatchdog();
    private static final ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(1, new DefaultDaemonThreadFactory());
    private static final Map<Thread, Set<Interrupt>> interruptSetMap = new HashMap<Thread, Set<Interrupt>>();

    private ThreadWatchdog() {
        String methodLogName = "ThreadWatchdog::ThreadWatchdog()";
        logger.trace("ThreadWatchdog::ThreadWatchdog()");
    }

    private Interrupter getInterrupter(Thread thread) {
        String methodLogName = "ThreadWatchdog::getInterrupter()";
        logger.trace("ThreadWatchdog::getInterrupter()");
        return new Interrupter(thread);
    }

    public static Interrupt register(Thread thread) {
        String methodLogName = "ThreadWatchdog::register(Thread)";
        logger.trace("ThreadWatchdog::register(Thread)");
        return ThreadWatchdog.register(thread, Long.MAX_VALUE, TimeUnit.SECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Interrupt register(Thread thread, long delay, TimeUnit unit) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "ThreadWatchdog::register(Thread, long, TimeUnit)";
        logger.trace("ThreadWatchdog::register(Thread, long, TimeUnit)");
        if (thread == null || unit == null) {
            String message = "ThreadWatchdog::register(Thread, long, TimeUnit) - thread [" + thread + "] and unit [" + (Object)((Object)unit) + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (delay < 1L) {
            String message = "ThreadWatchdog::register(Thread, long, TimeUnit) - delay [" + delay + "] must be at least one.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        Interrupter interrupter = instance.getInterrupter(thread);
        Map<Thread, Set<Interrupt>> map = interruptSetMap;
        synchronized (map) {
            Set<Interrupt> interruptSet = interruptSetMap.get(thread);
            if (interruptSet == null) {
                interruptSet = new HashSet<Interrupt>();
                interruptSetMap.put(thread, interruptSet);
            }
            interruptSet.add(interrupter);
            executor.schedule(interrupter, delay, unit);
        }
        logger.debug("ThreadWatchdog::register(Thread, long, TimeUnit) - scheduled interrupt in [" + delay + "][" + (Object)((Object)unit) + "] for thread [" + thread.getName() + "].");
        return interrupter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unregister(Thread thread) throws NullPointerException {
        String methodLogName = "ThreadWatchdog::unregister()";
        logger.trace("ThreadWatchdog::unregister()");
        if (thread == null) {
            String message = "ThreadWatchdog::unregister() - thread must not be null.";
            logger.fatal("ThreadWatchdog::unregister() - thread must not be null.");
            throw new NullPointerException("ThreadWatchdog::unregister() - thread must not be null.");
        }
        Map<Thread, Set<Interrupt>> map = interruptSetMap;
        synchronized (map) {
            Set<Interrupt> interruptSet = interruptSetMap.get(thread);
            if (interruptSet == null) {
                logger.debug("ThreadWatchdog::unregister() - thread [" + thread.getName() + "] not registered with watchdog.");
                return;
            }
            Iterator<Interrupt> interruptIterator = new HashSet<Interrupt>(interruptSet).iterator();
            while (interruptIterator.hasNext()) {
                interruptIterator.next().cancel();
            }
        }
        logger.debug("ThreadWatchdog::unregister() - all interrupts cancelled; thread [" + thread.getName() + "] unregistered from watchdog.");
    }

    private class Interrupter
    implements Interrupt,
    Runnable {
        private final String classLogName = "Interrupter";
        private final Thread thread;
        private volatile boolean cancelled = false;
        private volatile boolean executed = false;

        Interrupter(Thread thread) throws NullPointerException {
            String methodLogName = "Interrupter::Interrupter()";
            logger.trace("Interrupter::Interrupter()");
            if (thread == null) {
                String message = "Interrupter::Interrupter() - thread must not be null.";
                logger.fatal("Interrupter::Interrupter() - thread must not be null.");
                throw new NullPointerException("Interrupter::Interrupter() - thread must not be null.");
            }
            this.thread = thread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void cancel() {
            String methodLogName = "Interrupter::cancel()";
            logger.trace("Interrupter::cancel()");
            Map map = interruptSetMap;
            synchronized (map) {
                if (this.cancelled) {
                    logger.debug("Interrupter::cancel() - interrupt already cancelled.");
                    return;
                }
                this.unregister();
                this.cancelled = true;
                logger.debug("Interrupter::cancel() - interrupt cancelled for thread [" + this.thread.getName() + "].");
            }
        }

        @Override
        public boolean cancelled() {
            String methodLogName = "Interrupter::cancelled()";
            logger.trace("Interrupter::cancelled()");
            return this.cancelled;
        }

        @Override
        public void execute() {
            String methodLogName = "Interrupter::executed()";
            logger.trace("Interrupter::executed()");
            this.run();
        }

        @Override
        public boolean executed() {
            String methodLogName = "Interrupter::executed()";
            logger.trace("Interrupter::executed()");
            return this.executed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            String methodLogName = "Interrupter::run()";
            logger.trace("Interrupter::run()");
            Map map = interruptSetMap;
            synchronized (map) {
                if (this.cancelled) {
                    logger.debug("Interrupter::run() - this interrupt has been cancelled.");
                    return;
                }
                if (this.executed) {
                    logger.debug("Interrupter::run() - this interrupt has already been executed.");
                    return;
                }
                this.unregister();
                this.executed = true;
                this.thread.interrupt();
                logger.debug("Interrupter::run() - interrupt executed on thread [" + this.thread.getName() + "].");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void unregister() {
            String methodLogName = "Interrupter::unregister()";
            logger.trace("Interrupter::unregister()");
            Map map = interruptSetMap;
            synchronized (map) {
                Set interruptSet = (Set)interruptSetMap.get(this.thread);
                executor.remove(this);
                interruptSet.remove(this);
                logger.debug("Interrupter::unregister() - interrupt unregistered for thread [" + this.thread.getName() + "].");
                if (interruptSet.isEmpty()) {
                    interruptSetMap.remove(this.thread);
                    logger.debug("Interrupter::unregister() - no further interrupts scheduled; unregistering thread [" + this.thread.getName() + "] from watchdog.");
                }
            }
        }
    }

    public static interface Interrupt {
        public void cancel();

        public boolean cancelled();

        public void execute();

        public boolean executed();
    }
}

