/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dbrc;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.eso.util.dbrc.DBConfig;
import org.eso.util.dbrc.DbrcParser;

public class DbrcParserImpl
implements DbrcParser {
    static final Logger logger = Logger.getLogger(DbrcParserImpl.class);
    private Map<String, DBConfig> dbConfigurations;

    public DbrcParserImpl(String dbrcFile) throws IOException {
        this.parse(dbrcFile);
    }

    private void parse(String dbrcFile) throws IOException {
        this.dbConfigurations = new HashMap<String, DBConfig>();
        Pattern p = Pattern.compile("([^\\s]*)\\s+([^\\s]*)\\s+([^\\s]*)\\s+([^\\s]*)\\s*");
        List<String> lines = FileUtils.readLines(new File(dbrcFile));
        for (String line : lines) {
            if (line.startsWith("#") || line.length() == 0) continue;
            Matcher m = p.matcher(line);
            if (m.matches()) {
                this.dbConfigurations.put(m.group(1), new DBConfig(m.group(2), m.group(3), m.group(4)));
                continue;
            }
            logger.debug("Ignoring line in file [" + dbrcFile + "]: " + line);
        }
    }

    @Override
    public DBConfig getDBConfig(String alias) {
        return this.dbConfigurations.get(alias);
    }
}

