/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.DefaultTransferRequestValidator;
import org.eso.util.dal.SybaseConnectionService;
import org.eso.util.dal.TransferRequest;
import org.eso.util.dal.TransferRequestDAO;
import org.eso.util.dal.TransferRequestValidator;

public class TransferRequestDAOSyb
implements TransferRequestDAO {
    static final Logger logger = Logger.getLogger(TransferRequestDAOSyb.class);
    private static final String classLogName = "TransferRequestDAOSyb";
    private static final String REQUEST_ID_FIELD = "request_id";
    private static final String FILE_ID_FIELD = "file_id";
    private static final String FILE_NAME_FIELD = "file_name";
    private static final String SIZE_FIELD = "size";
    private static final String UNCOMPRESSED_SIZE_FIELD = "uncompressed_size";
    private static final String CHECKSUM_FIELD = "checksum";
    private static final String COMPRESSION_METHOD_FIELD = "compression_method";
    private static final String TRANSFER_METHOD_FIELD = "transfer_method";
    private static final String TRANSFER_PRIORITY_FIELD = "transfer_priority";
    private static final String TRANSFER_CATG_FIELD = "transfer_catg";
    private static final String DEST_USER_FIELD = "dest_user";
    private static final String DEST_DIR_FIELD = "dest_dir";
    private static final String TRANSFER_STATUS_FIELD = "transfer_status";
    private static final String CREATION_TIME_FIELD = "submission_time";
    private static final String LAST_UPDATE_TIME_FIELD = "last_update_time";
    private static final String DATE_FORMAT = "MMM dd yyyy HH:mm:ss.SSS";
    private static final Map<TransferRequest.FIELDS, String> TR_TABLE_FIELD_MAP = new HashMap<TransferRequest.FIELDS, String>();
    private static final Map<TransferRequestDAO.SortingOrder, String> SORTING_ORDER_MAP;
    private final String dbUrl;
    private final String dbUsername;
    private final String dbPassword;
    private final String dbTable;
    private final TransferRequestValidator transferRequestValidator;

    public TransferRequestDAOSyb(String dbUrl, String dbUsername, String dbPassword, String dbTable, TransferRequestValidator transferRequestValidator) {
        if (dbUrl == null || dbUsername == null || dbPassword == null || dbTable == null || transferRequestValidator == null) {
            String message = "Missing parameter to instantiate a TransferRequestDAOSyb object";
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        this.dbUrl = dbUrl;
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.dbTable = dbTable;
        this.transferRequestValidator = transferRequestValidator;
    }

    @Override
    public int delete(TransferRequest transferRequest) throws DAOException {
        String methodLogName = "TransferRequestDAOSyb::delete()";
        if (transferRequest == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing transfer request argument");
        }
        if (transferRequest.getRequestId() == null) {
            String message = methodLogName + " - Mandatory field " + REQUEST_ID_FIELD + " is not available";
            logger.error(message);
            throw new DAOException(message);
        }
        String sqlStatement = "delete from " + this.dbTable + " where " + REQUEST_ID_FIELD + "='" + transferRequest.getRequestId() + "'";
        logger.debug(methodLogName + " - Execution of query " + sqlStatement);
        int nbRows = this.executeUpdateQuery(sqlStatement);
        if (nbRows < 0) {
            logger.error(methodLogName + " - " + sqlStatement + " failed");
        }
        return nbRows;
    }

    @Override
    public List<TransferRequest> findByStatus(TransferRequest.Status status) throws DAOException {
        String methodLogName = "TransferRequestDAOSyb::findByStatus()";
        if (status == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing status argument");
        }
        List<TransferRequest> transferRequestList = null;
        String sqlStatement = "select * from " + this.dbTable + " where " + TRANSFER_STATUS_FIELD + "=" + String.valueOf(status.ordinal());
        logger.debug(methodLogName + " - Execution of query " + sqlStatement);
        transferRequestList = this.executeQuery(sqlStatement);
        return transferRequestList;
    }

    @Override
    public Boolean isValid(TransferRequest transferRequest) {
        String methodLogName = "TransferRequestDAOSyb::isValid()";
        if (transferRequest == null) {
            throw new IllegalArgumentException(methodLogName + " - transferRequest must not be null");
        }
        return this.transferRequestValidator.isValid(transferRequest);
    }

    @Override
    public int save(TransferRequest transferRequest) throws DAOException {
        String methodLogName = "TransferRequestDAOSyb::save()";
        if (transferRequest == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing transfer request argument");
        }
        if (transferRequest.getRequestId() == null) {
            String message = methodLogName + " - Mandatory field " + REQUEST_ID_FIELD + " is not available";
            logger.error(message);
            throw new DAOException(message);
        }
        if (transferRequest.getFileId() == null) {
            String message = methodLogName + " - Mandatory field " + FILE_ID_FIELD + " is not available";
            logger.error(message);
            throw new DAOException(message);
        }
        String columnList = REQUEST_ID_FIELD;
        String valueList = "'" + transferRequest.getRequestId() + "'";
        columnList = columnList + ",file_id";
        valueList = valueList + ",'" + transferRequest.getFileId() + "'";
        if (transferRequest.getFileName() != null) {
            columnList = columnList + ",file_name";
            valueList = valueList + ",'" + transferRequest.getFileName() + "'";
        }
        if (transferRequest.getSize() != null) {
            columnList = columnList + ",size";
            valueList = valueList + "," + transferRequest.getSize();
        }
        if (transferRequest.getUncompressedSize() != null) {
            columnList = columnList + ",uncompressed_size";
            valueList = valueList + "," + transferRequest.getUncompressedSize();
        }
        if (transferRequest.getChecksum() != null) {
            columnList = columnList + ",checksum";
            valueList = valueList + ",'" + transferRequest.getChecksum() + "'";
        }
        if (transferRequest.getCompressionMethod() != null) {
            columnList = columnList + ",compression_method";
            valueList = valueList + ",'" + transferRequest.getCompressionMethod() + "'";
        }
        if (transferRequest.getTransferMethod() != null) {
            columnList = columnList + ",transfer_method";
            valueList = valueList + ",'" + transferRequest.getTransferMethod() + "'";
        }
        if (transferRequest.getTransferPriority() != null) {
            columnList = columnList + ",transfer_priority";
            valueList = valueList + "," + transferRequest.getTransferPriority();
        }
        if (transferRequest.getTransferCatg() != null) {
            columnList = columnList + ",transfer_catg";
            valueList = valueList + ",'" + transferRequest.getTransferCatg() + "'";
        }
        if (transferRequest.getUser() != null) {
            columnList = columnList + ",dest_user";
            valueList = valueList + ",'" + transferRequest.getUser() + "'";
        }
        if (transferRequest.getDestDir() != null) {
            columnList = columnList + ",dest_dir";
            valueList = valueList + ",'" + transferRequest.getDestDir() + "'";
        }
        if (transferRequest.getStatus() != null) {
            columnList = columnList + ",transfer_status";
            valueList = valueList + "," + transferRequest.getStatus().ordinal();
        }
        columnList = columnList + ",submission_time";
        if (transferRequest.getCreationTime() != null) {
            SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
            dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            valueList = valueList + ",'" + dateFormat.format(new Date(transferRequest.getCreationTime())) + "'";
        } else {
            valueList = valueList + ",getUTCdate()";
        }
        columnList = columnList + ",last_update_time";
        valueList = valueList + ",getUTCdate()";
        String sqlStatement = "insert into " + this.dbTable + " (" + columnList + ") values(" + valueList + ")";
        logger.debug(methodLogName + " - Execution of query " + sqlStatement);
        int nbRows = this.executeUpdateQuery(sqlStatement);
        if (nbRows < 0) {
            logger.error(methodLogName + " - " + sqlStatement + " failed");
        }
        return nbRows;
    }

    @Override
    public int updateStatus(TransferRequest transferRequest, TransferRequest.Status status) throws DAOException {
        String methodLogName = "TransferRequestDAOSyb::updateStatus()";
        if (transferRequest == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing transfer request argument");
        }
        if (status == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing status argument");
        }
        if (transferRequest.getRequestId() == null) {
            String message = methodLogName + " - Mandatory field " + REQUEST_ID_FIELD + " is not available";
            logger.error(message);
            throw new DAOException(message);
        }
        Integer intStatus = status.ordinal();
        String sqlStatement = "update " + this.dbTable + " set transfer_status = " + intStatus + ",last_update_time=getUTCdate() where request_id='" + transferRequest.getRequestId() + "'";
        logger.debug(sqlStatement);
        int nbRows = this.executeUpdateQuery(sqlStatement);
        if (nbRows < 0) {
            logger.error(methodLogName + " - " + sqlStatement + " failed");
        }
        return nbRows;
    }

    @Override
    public List<TransferRequest> findByDateGreaterThan(Date startDate, String instrumentList, TransferRequest.Status status, TransferRequest.FIELDS orderBy, TransferRequestDAO.SortingOrder sortingOrder) throws DAOException {
        String methodLogName = "TransferRequestDAOSyb::findByDateGreaterThan()";
        if (startDate == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing night argument");
        }
        if (orderBy == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing sort by argument");
        }
        if (sortingOrder == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing sorting order argument");
        }
        String instrumentCondition = new String();
        if (instrumentList != null && instrumentList.length() != 0) {
            instrumentCondition = instrumentCondition + " AND (";
            String[] instrumentArray = instrumentList.split(" ");
            for (int index = 0; index < instrumentArray.length; ++index) {
                instrumentCondition = instrumentCondition + "file_id like '" + instrumentArray[index] + "%'";
                if (index == instrumentArray.length - 1) continue;
                instrumentCondition = instrumentCondition + " OR ";
            }
            instrumentCondition = instrumentCondition + ") ";
        }
        String statusCondition = new String();
        if (status != null && status != TransferRequest.Status.ALL) {
            statusCondition = " AND transfer_status=" + status.ordinal() + " ";
        }
        List<TransferRequest> transferRequestList = null;
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        String sqlStatement = "select * from " + this.dbTable + " where " + CREATION_TIME_FIELD + ">'" + dateFormat.format(startDate) + "'" + instrumentCondition + statusCondition + " order by " + TR_TABLE_FIELD_MAP.get((Object)orderBy) + " " + SORTING_ORDER_MAP.get((Object)sortingOrder);
        logger.debug(methodLogName + " - Execution of query " + sqlStatement);
        transferRequestList = this.executeQuery(sqlStatement);
        return transferRequestList;
    }

    @Override
    public List<TransferRequest> findByDate(Date obsDate, String instrumentList, List<TransferRequest.Status> statusList, String fileType, List<TransferRequest.FIELDS> orderByList, TransferRequestDAO.SortingOrder sortingOrder) throws DAOException {
        String methodLogName = "TransferRequestDAOSyb::findByDate";
        if (obsDate == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing night argument");
        }
        if (statusList == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing status argument");
        }
        if (orderByList == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing order by argument");
        }
        if (sortingOrder == null) {
            throw new IllegalArgumentException(methodLogName + " - Missing sorting order argument");
        }
        String instrumentCondition = new String();
        if (instrumentList != null && instrumentList.length() != 0) {
            instrumentCondition = instrumentCondition + " AND (";
            String[] instrumentArray = instrumentList.split(" ");
            for (int index = 0; index < instrumentArray.length; ++index) {
                instrumentCondition = instrumentCondition + "file_id like '" + instrumentArray[index] + "%'";
                if (index == instrumentArray.length - 1) continue;
                instrumentCondition = instrumentCondition + " OR ";
            }
            instrumentCondition = instrumentCondition + ") ";
        }
        String fileNameExtCondition = new String();
        String fileCatgCondition = new String();
        String TOO_FILE_TYPE = "too";
        if (fileType != null && fileType.length() != 0) {
            if (fileType.compareToIgnoreCase("too") == 0) {
                fileType = "fits";
                fileCatgCondition = " AND transfer_catg='too' ";
            }
            fileNameExtCondition = fileNameExtCondition + " AND  (file_name like '%" + fileType.toLowerCase() + "' OR file_name like '%" + fileType.toLowerCase() + ".Z')";
        }
        String statusCondition = new String();
        if (!statusList.contains((Object)TransferRequest.Status.ALL)) {
            Iterator<TransferRequest.Status> statusIterator = statusList.iterator();
            if (statusIterator.hasNext()) {
                statusCondition = " AND (";
            }
            while (statusIterator.hasNext()) {
                statusCondition = statusCondition + " (transfer_status=" + statusIterator.next().ordinal() + ") ";
                if (statusIterator.hasNext()) {
                    statusCondition = statusCondition + " OR ";
                    continue;
                }
                statusCondition = statusCondition + ") ";
            }
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(DATE_FORMAT);
        dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        GregorianCalendar startDate = new GregorianCalendar();
        startDate.setTime(obsDate);
        ((Calendar)startDate).setTimeZone(TimeZone.getTimeZone("UTC"));
        startDate.set(11, 12);
        startDate.set(12, 0);
        startDate.set(13, 0);
        startDate.set(14, 0);
        GregorianCalendar endDate = new GregorianCalendar();
        endDate.setTime(startDate.getTime());
        ((Calendar)endDate).add(5, 1);
        ((Calendar)endDate).setTimeZone(TimeZone.getTimeZone("UTC"));
        String sqlStatement = "select * from " + this.dbTable + " where " + CREATION_TIME_FIELD + " between '" + dateFormat.format(startDate.getTime()) + "' AND " + "'" + dateFormat.format(endDate.getTime()) + "' " + instrumentCondition + statusCondition + fileCatgCondition + fileNameExtCondition + " order by ";
        Iterator<TransferRequest.FIELDS> fieldsIterator = orderByList.iterator();
        while (fieldsIterator.hasNext()) {
            sqlStatement = sqlStatement + TR_TABLE_FIELD_MAP.get((Object)fieldsIterator.next());
            if (!fieldsIterator.hasNext()) {
                sqlStatement = sqlStatement + " ";
                continue;
            }
            sqlStatement = sqlStatement + ",";
        }
        sqlStatement = sqlStatement + SORTING_ORDER_MAP.get((Object)sortingOrder);
        logger.debug(methodLogName + " - Execution of query " + sqlStatement);
        List<TransferRequest> transferRequestList = null;
        transferRequestList = this.executeQuery(sqlStatement);
        return transferRequestList;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<TransferRequest> executeQuery(String sqlStatement) throws DAOException {
        Connection connection = null;
        List<TransferRequest> transferRequestList = null;
        try {
            connection = SybaseConnectionService.getConnection(this.dbUrl, this.dbUsername, this.dbPassword);
            ResultSet rs = SybaseConnectionService.executeStatement(connection, sqlStatement);
            transferRequestList = this.toTransferRequestList(rs);
        }
        catch (Exception e3) {
            try {
                throw new DAOException(e3.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    SybaseConnectionService.closeConnection(connection);
                    throw throwable;
                }
                catch (ConnectionServiceException e4) {
                    throw new DAOException(e4.getMessage());
                }
            }
        }
        try {
            SybaseConnectionService.closeConnection(connection);
            return transferRequestList;
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int executeUpdateQuery(String sqlStatement) throws DAOException {
        Connection connection = null;
        int nbUpdatedRows = 0;
        try {
            connection = SybaseConnectionService.getConnection(this.dbUrl, this.dbUsername, this.dbPassword);
            nbUpdatedRows = SybaseConnectionService.executeUpdateStatement(connection, sqlStatement);
        }
        catch (Exception e3) {
            try {
                nbUpdatedRows = -1;
                throw new DAOException(e3.getMessage());
            }
            catch (Throwable throwable) {
                try {
                    SybaseConnectionService.closeConnection(connection);
                    throw throwable;
                }
                catch (ConnectionServiceException e4) {
                    throw new DAOException(e4.getMessage());
                }
            }
        }
        try {
            SybaseConnectionService.closeConnection(connection);
            return nbUpdatedRows;
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    private List<TransferRequest> toTransferRequestList(ResultSet rs) throws DAOException {
        GregorianCalendar utcCal = new GregorianCalendar();
        ((Calendar)utcCal).setTimeZone(TimeZone.getTimeZone("UTC"));
        ArrayList<TransferRequest> transferRequestList = new ArrayList<TransferRequest>();
        TransferRequest.Status[] statusArray = (TransferRequest.Status[])TransferRequest.Status.class.getEnumConstants();
        try {
            while (rs.next()) {
                TransferRequest transferRequest = new TransferRequest();
                transferRequest.setRequestId(rs.getString(REQUEST_ID_FIELD));
                transferRequest.setFileId(rs.getString(FILE_ID_FIELD));
                transferRequest.setFileName(rs.getString(FILE_NAME_FIELD));
                transferRequest.setSize(rs.getLong(SIZE_FIELD));
                transferRequest.setUncompressedSize(rs.getLong(UNCOMPRESSED_SIZE_FIELD));
                transferRequest.setChecksum(rs.getString(CHECKSUM_FIELD));
                transferRequest.setCompressionMethod(rs.getString(COMPRESSION_METHOD_FIELD));
                transferRequest.setTransferMethod(rs.getString(TRANSFER_METHOD_FIELD));
                transferRequest.setTransferPriority(rs.getInt(TRANSFER_PRIORITY_FIELD));
                transferRequest.setTransferCatg(rs.getString(TRANSFER_CATG_FIELD));
                transferRequest.setUser(rs.getString(DEST_USER_FIELD));
                transferRequest.setDestDir(rs.getString(DEST_DIR_FIELD));
                if (statusArray[rs.getInt(TRANSFER_STATUS_FIELD)] != null) {
                    transferRequest.setStatus(statusArray[rs.getInt(TRANSFER_STATUS_FIELD)]);
                } else {
                    transferRequest.setStatus(TransferRequest.Status.UNKNOWN);
                }
                TimeZone oldDefaultTz = TimeZone.getDefault();
                TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
                Timestamp curTimeStamp = rs.getTimestamp(CREATION_TIME_FIELD, (Calendar)utcCal);
                transferRequest.setCreationTime(curTimeStamp.getTime());
                curTimeStamp = rs.getTimestamp(LAST_UPDATE_TIME_FIELD, (Calendar)utcCal);
                transferRequest.setLastUpdateTime(curTimeStamp.getTime());
                TimeZone.setDefault(oldDefaultTz);
                transferRequestList.add(transferRequest);
            }
        }
        catch (SQLException e2) {
            throw new DAOException("Error while parsing result set. SQLException : " + e2.getMessage());
        }
        return transferRequestList;
    }

    public static void main(String[] args) {
        Iterator<TransferRequest> trIterator;
        BasicConfigurator.configure();
        DefaultTransferRequestValidator trValidator = new DefaultTransferRequestValidator();
        TransferRequestDAOSyb transferRequestDAO = new TransferRequestDAOSyb("acdbdev.hq.eso.org:6789", "sara", "sara_ps", "sara..transfer_requests", trValidator);
        TransferRequest transferRequest = new TransferRequest();
        transferRequest.setRequestId("RequestId");
        transferRequest.setFileId("FileId");
        transferRequest.setFileName("FileName");
        transferRequest.setSize(new Long(1000L));
        transferRequest.setUncompressedSize(new Long(1000000L));
        transferRequest.setChecksum("Checksum");
        transferRequest.setCompressionMethod("CompressionMethod");
        transferRequest.setTransferMethod("TransferMethod");
        transferRequest.setTransferPriority(new Integer(3));
        transferRequest.setTransferCatg("TransferCatg");
        transferRequest.setUser("DestUser");
        transferRequest.setDestDir("DestDir");
        transferRequest.setStatus(TransferRequest.Status.PROCESSED);
        transferRequest.setCreationTime(new Long(133259115L));
        logger.info("Set of tests on the TransferRequestDAOSyb class");
        logger.info("Case 1 : Set of tests on the save method");
        logger.info("\t Case 1_1 : Nominal case ");
        try {
            int nbInsertedRows = transferRequestDAO.save(transferRequest);
            if (nbInsertedRows == 1) {
                logger.info("\t SUCCESSFUL  transferRequest " + transferRequest.getFileId() + " has been inserted ");
            } else {
                logger.error("\t FAILED Number of inserted transfer requests is " + nbInsertedRows);
            }
        }
        catch (DAOException e2) {
            logger.error("\t FAILED DAOException " + transferRequest.getRequestId() + " has not been saved : " + e2.getMessage());
        }
        try {
            transferRequestDAO.delete(transferRequest);
        }
        catch (DAOException e3) {
            logger.error("\t FAILED DAOException " + transferRequest.getRequestId() + " has not been deleted : " + e3.getMessage());
        }
        logger.info("\t Case 1_2 : Try to insert twice a transfer request ");
        try {
            transferRequestDAO.save(transferRequest);
            transferRequestDAO.save(transferRequest);
            logger.error("\t FAILED No DAOException has been raised");
        }
        catch (DAOException e4) {
            logger.error("\t SUCCESSFUL DAOException has been raised : " + e4.getMessage());
        }
        catch (Exception e5) {
            logger.error("\t FAILED Unknown exception has been raised " + e5.getMessage());
        }
        try {
            transferRequestDAO.delete(transferRequest);
        }
        catch (DAOException e6) {
            logger.error("\t FAILED DAOException " + transferRequest.getFileId() + " has not been deleted : " + e6.getMessage());
        }
        logger.info("\t Case 1_3 : request id is null ");
        String formerRequestId = transferRequest.getRequestId();
        transferRequest.setRequestId(null);
        try {
            transferRequestDAO.save(transferRequest);
            logger.error("\t FAILED No DAOException has been raised");
        }
        catch (DAOException e7) {
            logger.info("\t SUCCESSFUL DAOException has been raised : " + e7.getMessage());
        }
        transferRequest.setRequestId(formerRequestId);
        logger.info("\t Case 1_4 : file id is null ");
        String formerFileId = transferRequest.getFileId();
        transferRequest.setFileId(null);
        try {
            transferRequestDAO.save(transferRequest);
            logger.error("\t FAILED No DAOException has been raised");
        }
        catch (DAOException e8) {
            logger.info("\t SUCCESSFUL DAOException has been raised : " + e8.getMessage());
        }
        transferRequest.setFileId(formerFileId);
        logger.info("\t Case 1_4 :  No transfer request is provided ");
        try {
            transferRequestDAO.save(null);
            logger.error("\t FAILED No DAOException has been raised");
        }
        catch (DAOException e9) {
            logger.error("\t FAILED DAOException has been raised : " + e9.getMessage());
        }
        catch (IllegalArgumentException e10) {
            logger.info("\t SUCCESSFUL IllegalArgumentException has been raised : " + e10.getMessage());
        }
        logger.info("\t Case 1_5 : Transfer request with no creation time stamp ");
        Long oldTimeStamp = transferRequest.getCreationTime();
        try {
            transferRequest.setCreationTime(null);
            int nbInsertedRows = transferRequestDAO.save(transferRequest);
            if (nbInsertedRows == 1) {
                logger.info("\t SUCCESSFUL  transferRequest " + transferRequest.getFileId() + " has been inserted ");
            } else {
                logger.error("\t FAILED Number of inserted transfer requests is " + nbInsertedRows);
            }
        }
        catch (DAOException e11) {
            logger.error("\t FAILED DAOException " + transferRequest.getRequestId() + " has not been saved : " + e11.getMessage());
        }
        try {
            transferRequestDAO.delete(transferRequest);
        }
        catch (DAOException e12) {
            logger.error("\t FAILED DAOException " + transferRequest.getRequestId() + " has not been deleted : " + e12.getMessage());
        }
        transferRequest.setCreationTime(oldTimeStamp);
        logger.info("Case 2 : Set of tests on the delete method");
        logger.info("\t Case 2_1 : Nominal case ");
        try {
            transferRequestDAO.save(transferRequest);
            int nbDeletedRows = transferRequestDAO.delete(transferRequest);
            if (nbDeletedRows == 1) {
                logger.info("\t SUCCESSFUL  transferRequest " + transferRequest.getFileId() + " has been deleted ");
            } else {
                logger.error("\t FAILED Number of deleted transfer requests is " + nbDeletedRows);
            }
        }
        catch (DAOException e13) {
            logger.error("\t FAILED DAOException " + transferRequest.getFileId() + " has not been deleted : " + e13.getMessage());
        }
        logger.info("\t Case 2_2 : try to delete a non existing transferRequest ");
        formerRequestId = transferRequest.getRequestId();
        transferRequest.setRequestId("NonExistingRid");
        try {
            int nbDeletedRows = transferRequestDAO.delete(transferRequest);
            if (nbDeletedRows == 1) {
                logger.error("\t FAILED  transferRequest " + transferRequest.getRequestId() + " has been deleted ");
            } else if (nbDeletedRows == 0) {
                logger.info("\t SUCCESSFUL  Number of deleted transfer requests is 0");
            } else {
                logger.info("\t FAILED  Number of deleted transfer requests is " + nbDeletedRows);
            }
        }
        catch (DAOException e14) {
            logger.error("\t FAILED DAOException " + transferRequest.getRequestId() + " has not been deleted : " + e14.getMessage());
        }
        transferRequest.setRequestId(formerRequestId);
        logger.info("\t Case 2_3 : Request id is null ");
        formerRequestId = transferRequest.getRequestId();
        transferRequest.setRequestId(null);
        try {
            transferRequestDAO.delete(transferRequest);
            logger.error("\t FAILED No exception raised");
        }
        catch (DAOException e15) {
            logger.error("\t SUCCESSFUL DAOException has been raised " + e15.getMessage());
        }
        transferRequest.setRequestId(formerRequestId);
        logger.info("\t Case 2_4 : no transfer request is provided ");
        try {
            transferRequestDAO.delete(null);
            logger.error("\t FAILED No exception raised");
        }
        catch (IllegalArgumentException e16) {
            logger.info("\t SUCCESSFUL  IllegalArgumentException  has been raised : " + e16.getMessage());
        }
        catch (DAOException e17) {
            logger.error("\t FAILED DAOException  has raised : " + e17.getMessage());
        }
        logger.info("Case 3 : Set of tests on the findbystatus method");
        logger.info("\t Case 3_1 : Nominal case ");
        TransferRequest.Status status = transferRequest.getStatus();
        try {
            transferRequestDAO.save(transferRequest);
            List<TransferRequest> trList = transferRequestDAO.findByStatus(status);
            Iterator<TransferRequest> trIterator2 = trList.iterator();
            boolean trRetrieved = false;
            while (trIterator2.hasNext()) {
                TransferRequest curTransferRequest = trIterator2.next();
                String curTrFileId = curTransferRequest.getFileId();
                if (curTrFileId.compareTo(transferRequest.getFileId()) != 0) continue;
                if (curTransferRequest.getStatus() != status) break;
                trRetrieved = true;
                break;
            }
            if (trRetrieved) {
                logger.info("\t SUCCESSFUL  transferRequest " + transferRequest.getFileId() + " in status  " + (Object)((Object)status) + "  has been retrieved ");
            } else {
                logger.error("\t FAILED  transferRequest " + transferRequest.getFileId() + " in status  " + (Object)((Object)status) + "  has not been retrieved ");
            }
        }
        catch (DAOException e18) {
            logger.error("\t FAILED DAOException " + transferRequest.getFileId() + " has not been deleted : " + e18.getMessage());
        }
        logger.info("\t Case 3_2 : Looking for a status different from the status of the test record");
        try {
            TransferRequest.Status retrievedStatus = TransferRequest.Status.values()[transferRequest.getStatus().ordinal() + 1];
            List<TransferRequest> trList = transferRequestDAO.findByStatus(retrievedStatus);
            trIterator = trList.iterator();
            boolean trRetrieved = false;
            while (trIterator.hasNext()) {
                TransferRequest curTransferRequest = trIterator.next();
                String curTrRequestId = curTransferRequest.getRequestId();
                if (curTrRequestId.compareTo(transferRequest.getRequestId()) != 0) continue;
                if (curTransferRequest.getStatus() != status) break;
                trRetrieved = true;
                break;
            }
            if (trRetrieved) {
                logger.error("\t FAILED  transferRequest " + transferRequest.getRequestId() + " in status  " + (Object)((Object)retrievedStatus) + "  has been retrieved ");
            } else {
                logger.info("\t SUCCESSFUL  No transferRequest " + transferRequest.getRequestId() + " in status  " + (Object)((Object)retrievedStatus) + "  has been retrieved ");
            }
        }
        catch (DAOException e19) {
            logger.error("\t FAILED DAOException " + transferRequest.getFileId() + " has not been retrieved : " + e19.getMessage());
        }
        logger.info("\t Case 3_3 : No status is provided");
        try {
            transferRequestDAO.findByStatus(null);
            logger.error("\t FAILED No IllegalArgumentException has been raised");
        }
        catch (IllegalArgumentException e20) {
            logger.info("\t SUCCESSFUL IllegalArgumentException exception has been raised");
        }
        catch (Exception e21) {
            logger.error("\t FAILED Unknown exception has been raised");
        }
        try {
            transferRequestDAO.delete(transferRequest);
        }
        catch (DAOException e22) {
            logger.error("\t FAILED DAOException " + transferRequest.getFileId() + " has not been deleted : " + e22.getMessage());
        }
        logger.info("Case 4 : Set of tests on the updateStatus method");
        logger.info("\t Case 4_1 : Nominal case ");
        try {
            transferRequestDAO.save(transferRequest);
            TransferRequest.Status newStatus = TransferRequest.Status.values()[transferRequest.getStatus().ordinal() + 1];
            int nbUpdated = transferRequestDAO.updateStatus(transferRequest, newStatus);
            if (nbUpdated == 1) {
                logger.info("\tSUCCESSFUL Number of updated transfer request is 1");
            } else {
                logger.error("\tFAILED Number of updated transfer request is " + nbUpdated);
            }
            List<TransferRequest> trList = transferRequestDAO.findByStatus(newStatus);
            Iterator<TransferRequest> trIterator3 = trList.iterator();
            boolean trRetrieved = false;
            while (trIterator3.hasNext()) {
                TransferRequest curTransferRequest = trIterator3.next();
                String curTrRequestId = curTransferRequest.getRequestId();
                if (curTrRequestId.compareTo(transferRequest.getRequestId()) != 0) continue;
                if (curTransferRequest.getStatus() != newStatus) break;
                trRetrieved = true;
                break;
            }
            if (trRetrieved) {
                logger.info("\t SUCCESSFUL  transferRequest " + transferRequest.getRequestId() + " in status  " + (Object)((Object)newStatus) + "  has been retrieved ");
            } else {
                logger.error("\t FAILED  transferRequest " + transferRequest.getRequestId() + " in status  " + (Object)((Object)newStatus) + "  has not been retrieved ");
            }
        }
        catch (DAOException e23) {
            logger.error("\t FAILED DAOException " + transferRequest.getRequestId() + " has not been updated : " + e23.getMessage());
        }
        logger.info("\t Case 4_2 : The transfer request is not available ");
        try {
            transferRequestDAO.delete(transferRequest);
            status = transferRequest.getStatus();
            int nbUpdated = transferRequestDAO.updateStatus(transferRequest, status);
            if (nbUpdated == 0) {
                logger.info("\tSUCCESSFUL No transfer request has been retrieved");
            } else {
                logger.error("\tFAILED Number of updated transfer request is " + nbUpdated);
            }
            List<TransferRequest> trList = transferRequestDAO.findByStatus(status);
            trIterator = trList.iterator();
            boolean trRetrieved = false;
            while (trIterator.hasNext()) {
                TransferRequest curTransferRequest = trIterator.next();
                String curTrRequestId = curTransferRequest.getRequestId();
                if (curTrRequestId.compareTo(transferRequest.getRequestId()) != 0) continue;
                if (curTransferRequest.getStatus() != status) break;
                trRetrieved = true;
                break;
            }
            if (trRetrieved) {
                logger.error("\t FAILED  transferRequest " + transferRequest.getRequestId() + " in status  " + (Object)((Object)status) + "  has been retrieved ");
            } else {
                logger.info("\t SUCCESSFUL  transferRequest " + transferRequest.getRequestId() + " in status  " + (Object)((Object)status) + "  has not been retrieved ");
            }
        }
        catch (DAOException e24) {
            logger.error("\t FAILED DAOException " + transferRequest.getRequestId() + " has not been updated : " + e24.getMessage());
        }
        logger.info("\t Case 4_3 : No transfer request is provided ");
        try {
            TransferRequest.Status newStatus = TransferRequest.Status.INCOMING;
            transferRequestDAO.updateStatus(null, newStatus);
            logger.error("\tFAILED No exception has been raised");
        }
        catch (IllegalArgumentException e25) {
            logger.info("\t SUCCESSFUL IllegalArgumentException has been raised : " + e25.getMessage());
        }
        catch (Exception e26) {
            logger.error("\t FAILED Unknown Exception has been raised : " + e26.getMessage());
        }
        logger.info("\t Case 4_4 : No status is provided ");
        try {
            transferRequestDAO.updateStatus(transferRequest, null);
            logger.error("\tFAILED No exception has been raised");
        }
        catch (IllegalArgumentException e27) {
            logger.info("\t SUCCESSFUL IllegalArgumentException has been raised : " + e27.getMessage());
        }
        catch (Exception e28) {
            logger.error("\t FAILED Unknown Exception has been raised : " + e28.getMessage());
        }
        try {
            transferRequestDAO.delete(transferRequest);
        }
        catch (DAOException e29) {
            e29.printStackTrace();
        }
    }

    @Override
    public void deleteByStatus(TransferRequest.Status status) throws DAOException {
        throw new DAOException("Method not implemented yet");
    }

    static {
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.CHECKSUM, CHECKSUM_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.COMPRESSION_METHOD, COMPRESSION_METHOD_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.SUBMISSION_TIME, CREATION_TIME_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.DEST_DIR, DEST_DIR_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.FILE_ID, FILE_ID_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.FILE_NAME, FILE_NAME_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.REQUEST_ID, REQUEST_ID_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.SIZE, SIZE_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.STATUS, TRANSFER_STATUS_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.TRANSFER_CATG, TRANSFER_CATG_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.TRANSFER_METHOD, TRANSFER_METHOD_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.TRANSFER_PRIORITY, TRANSFER_PRIORITY_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.UNCOMPRESSED_SIZE, UNCOMPRESSED_SIZE_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.USER, DEST_USER_FIELD);
        TR_TABLE_FIELD_MAP.put(TransferRequest.FIELDS.LAST_UPDATE_TIME, LAST_UPDATE_TIME_FIELD);
        SORTING_ORDER_MAP = new HashMap<TransferRequestDAO.SortingOrder, String>();
        SORTING_ORDER_MAP.put(TransferRequestDAO.SortingOrder.ASCENDING, "ASC");
        SORTING_ORDER_MAP.put(TransferRequestDAO.SortingOrder.DESCENDING, "DESC");
    }
}

