/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.StagingTableProcess;
import org.eso.util.dal.StagingTableWriter;
import org.eso.util.dal.SybaseConnectionService;

public class StagingTableWriterSyb
implements StagingTableWriter {
    private static final Logger logger = Logger.getLogger(StagingTableWriterSyb.class);
    private final String dbUrl;
    private final String dbUsername;
    private final String dbPassword;
    private final String dbTable;
    private String stageTableField = "stagefeed_table";
    private String odsTableField = "odsfeed_table";
    private String procIdField = "ods_table";
    private StagingTableProcess stp;

    public StagingTableWriterSyb(String dbUrl, String dbUsername, String dbPassword, String dbTable, StagingTableProcess stp) {
        this.dbUrl = dbUrl;
        this.dbUsername = dbUsername;
        this.dbPassword = dbPassword;
        this.dbTable = dbTable;
        this.stp = stp;
    }

    @Override
    public boolean process() throws DAOException, SQLException {
        boolean res;
        block10: {
            Connection conn;
            String methodLogName = this.getClass().getName() + "::process() - ";
            try {
                logger.debug(methodLogName + "getting connection");
                conn = SybaseConnectionService.getConnection(this.dbUrl, this.dbUsername, this.dbPassword);
            }
            catch (IllegalArgumentException e2) {
                throw new DAOException(e2.getMessage());
            }
            catch (ConnectionServiceException e3) {
                throw new DAOException(e3.getMessage());
            }
            String procId = this.stp.getProcessId();
            try {
                logger.debug(methodLogName + "start transaction");
                conn.setAutoCommit(false);
                String query = "SELECT " + this.stageTableField + " FROM " + this.dbTable + " HOLDLOCK WHERE " + this.procIdField + " = '" + procId + "'";
                ResultSet rs = SybaseConnectionService.executeStatement(conn, query);
                if (rs.next()) {
                    String activeTable = rs.getString(this.stageTableField);
                    this.stp.setActiveTable(activeTable);
                    logger.debug(methodLogName + "start procsessing");
                    res = this.stp.process();
                    logger.debug(methodLogName + "commit transaction");
                    conn.commit();
                    break block10;
                }
                logger.debug(methodLogName + "rollback transaction");
                conn.rollback();
                throw new DAOException("No table information found for process " + procId);
            }
            catch (ConnectionServiceException e4) {
                logger.debug(methodLogName + "rollback transaction");
                conn.rollback();
                throw new DAOException(e4.getMessage());
            }
            catch (SQLException e5) {
                logger.debug(methodLogName + "rollback transaction");
                conn.rollback();
                throw new DAOException(e5.getMessage());
            }
            finally {
                conn.close();
            }
        }
        return res;
    }

    public String getStageTableField() {
        return this.stageTableField;
    }

    public void setStageTableField(String stageTableField) {
        this.stageTableField = stageTableField;
    }

    public String getOdsTableField() {
        return this.odsTableField;
    }

    public void setOdsTableField(String odsTableField) {
        this.odsTableField = odsTableField;
    }

    public String getProcIdField() {
        return this.procIdField;
    }

    public void setProcIdField(String procIdField) {
        this.procIdField = procIdField;
    }

    public static void main(String[] args) {
        StagingTableProcess btp = null;
        StagingTableWriterSyb btw = new StagingTableWriterSyb("url", "username", "password", "table", btp);
        try {
            btw.process();
        }
        catch (DAOException e2) {
            e2.printStackTrace();
        }
        catch (SQLException e3) {
            e3.printStackTrace();
        }
    }
}

