/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.NgasDisk;
import org.eso.util.dal.NgasDiskDAO;
import org.eso.util.dal.NgasFile;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class NgasDiskDAOXML
implements NgasDiskDAO {
    static final Logger logger = Logger.getLogger(NgasDiskDAOXML.class);
    private Document d_document;
    private String d_filename;
    private List<NgasDisk> d_disks = new ArrayList<NgasDisk>();

    public NgasDiskDAOXML(String filename) throws DAOException {
        this.parseDocument(filename);
        this.d_filename = filename;
    }

    public void refreshView() throws DAOException {
        this.parseDocument(this.d_filename);
    }

    @Override
    public List<NgasDisk> findAll() throws DAOException {
        return this.d_disks;
    }

    @Override
    public List<NgasDisk> findByDiskId(String id) throws DAOException {
        ArrayList<NgasDisk> temp = new ArrayList<NgasDisk>();
        for (NgasDisk d2 : this.d_disks) {
            if (!d2.getDiskId().equals(id)) continue;
            temp.add(d2);
        }
        return temp;
    }

    @Override
    public List<NgasDisk> findByLogicalName(String name) throws DAOException {
        ArrayList<NgasDisk> temp = new ArrayList<NgasDisk>();
        for (NgasDisk d2 : this.d_disks) {
            if (!d2.getLogicalName().equals(name)) continue;
            temp.add(d2);
        }
        return temp;
    }

    @Override
    public List<NgasFile> findFilesByDiskId(String id) throws DAOException {
        throw new DAOException("Method not implemented in this DAO");
    }

    @Override
    public NgasDisk findLastEntry() throws DAOException {
        throw new DAOException("Method not implemented in this DAO");
    }

    @Override
    public void save(NgasDisk entry) throws DAOException {
        if (this.findByDiskId(entry.getDiskId()).size() != 0) {
            throw new DAOException("disk_id " + entry.getDiskId() + " is already in the file");
        }
        if (this.d_disks.size() != 0) {
            throw new DAOException("file already contains an entry, there can be at most one");
        }
        this.d_disks.add(entry);
        this.saveToFile();
    }

    @Override
    public void saveIfNotFound(NgasDisk entry) throws DAOException {
        this.save(entry);
    }

    @Override
    public void update(NgasDisk entry) throws DAOException {
        List<NgasDisk> temp = this.findByDiskId(entry.getDiskId());
        if (temp.size() != 1) {
            throw new DAOException("disk_id " + entry.getDiskId() + " is not in the file");
        }
        this.d_disks.set(this.d_disks.indexOf(temp.get(0)), entry);
        this.saveToFile();
    }

    @Override
    public void delete(NgasDisk entry) throws DAOException {
        if (this.findByDiskId(entry.getDiskId()).size() != 1) {
            throw new DAOException("disk_id " + entry.getDiskId() + " is not in the file");
        }
        this.d_disks.remove(entry);
        this.saveToFile();
    }

    private void parseDocument(String filename) throws DAOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.d_document = db.parse(filename);
            Element docEle = this.d_document.getDocumentElement();
            NodeList nl = docEle.getElementsByTagName("Disk");
            this.d_disks.clear();
            if (nl != null && nl.getLength() > 0) {
                for (int i = 0; i < nl.getLength(); ++i) {
                    Element el = (Element)nl.item(i);
                    NgasDisk disk = this.getNgasDisk(el);
                    this.d_disks.add(disk);
                }
            }
        }
        catch (Exception e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    private NgasDisk getNgasDisk(Element el) throws DAOException {
        NgasDisk disk = new NgasDisk();
        disk.setDiskId(this.getTextValue(el, "disk_id"));
        if (disk.getDiskId() == null) {
            throw new DAOException("missing disk_id");
        }
        disk.setArchive(this.getTextValue(el, "archive"));
        try {
            disk.setInstallationDate(Date.valueOf(this.getTextValue(el, "installation_date")));
        }
        catch (Exception e2) {
            // empty catch block
        }
        disk.setType(this.getTextValue(el, "type"));
        disk.setManufacturer(this.getTextValue(el, "manufacturer"));
        disk.setLogicalName(this.getTextValue(el, "logical_name"));
        disk.setHostId(this.getTextValue(el, "host_id"));
        disk.setSlotId(this.getTextValue(el, "slot_id"));
        try {
            disk.setMounted(Short.parseShort(this.getTextValue(el, "mounted")));
        }
        catch (Exception e3) {
            // empty catch block
        }
        disk.setMountPoint(this.getTextValue(el, "mount_point"));
        try {
            disk.setNumberOfFiles(Integer.parseInt(this.getTextValue(el, "number_of_files")));
        }
        catch (Exception e4) {
            // empty catch block
        }
        try {
            disk.setAvailableMb(Integer.parseInt(this.getTextValue(el, "available_mb")));
        }
        catch (Exception e5) {
            // empty catch block
        }
        try {
            disk.setBytesStored(BigDecimal.valueOf(Float.valueOf(this.getTextValue(el, "bytes_stored")).floatValue()));
        }
        catch (Exception e6) {
            // empty catch block
        }
        try {
            disk.setCompleted(Short.parseShort(this.getTextValue(el, "completed")));
        }
        catch (Exception e7) {
            // empty catch block
        }
        try {
            disk.setCompletionDate(Date.valueOf(this.getTextValue(el, "completion_date")));
        }
        catch (Exception e8) {
            // empty catch block
        }
        disk.setChecksum(this.getTextValue(el, "checksum"));
        try {
            disk.setTotalDiskWriteTime(Float.parseFloat(this.getTextValue(el, "total_disk_write_time")));
        }
        catch (Exception e9) {
            // empty catch block
        }
        try {
            disk.setLastCheck(Date.valueOf(this.getTextValue(el, "last_check")));
        }
        catch (Exception exception) {
            // empty catch block
        }
        disk.setLastHostId(this.getTextValue(el, "last_host_id"));
        NgasDisk.validate(disk);
        return disk;
    }

    private String getTextValue(Element ele, String tagName) {
        String textVal = null;
        try {
            NodeList nl = ele.getElementsByTagName(tagName);
            if (nl != null && nl.getLength() > 0) {
                Element el = (Element)nl.item(0);
                textVal = el.getFirstChild().getNodeValue();
            }
        }
        catch (Exception e2) {
            // empty catch block
        }
        return textVal;
    }

    private void saveToFile() {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder db = dbf.newDocumentBuilder();
            this.d_document = db.newDocument();
            Element rootEle = this.d_document.createElement("Disks");
            this.d_document.appendChild(rootEle);
            for (NgasDisk disk : this.d_disks) {
                Element diskEle = this.createDiskElement(disk);
                rootEle.appendChild(diskEle);
            }
            DOMImplementationRegistry registry = DOMImplementationRegistry.newInstance();
            DOMImplementationLS domImplLS = (DOMImplementationLS)((Object)registry.getDOMImplementation("LS"));
            LSSerializer ser = domImplLS.createLSSerializer();
            DOMConfiguration config = ser.getDomConfig();
            config.setParameter("format-pretty-print", true);
            LSOutput out = domImplLS.createLSOutput();
            FileWriter fileOut = new FileWriter(this.d_filename);
            out.setCharacterStream(fileOut);
            ser.write(this.d_document, out);
            fileOut.close();
        }
        catch (Exception e2) {
            logger.error("Error writing archive to disk: " + e2.getMessage());
        }
    }

    private Element createDiskElement(NgasDisk disk) {
        Text text;
        Element el;
        Element diskEle = this.d_document.createElement("Disk");
        if (disk.getDiskId() != null) {
            el = this.d_document.createElement("disk_id");
            text = this.d_document.createTextNode(disk.getDiskId());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getArchive() != null) {
            el = this.d_document.createElement("archive");
            text = this.d_document.createTextNode(disk.getArchive());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getInstallationDate() != null) {
            el = this.d_document.createElement("installation_date");
            text = this.d_document.createTextNode(disk.getInstallationDate().toString());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getType() != null) {
            el = this.d_document.createElement("type");
            text = this.d_document.createTextNode(disk.getType());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getManufacturer() != null) {
            el = this.d_document.createElement("manufacturer");
            text = this.d_document.createTextNode(disk.getManufacturer());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getLogicalName() != null) {
            el = this.d_document.createElement("logical_name");
            text = this.d_document.createTextNode(disk.getLogicalName());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getHostId() != null) {
            el = this.d_document.createElement("host_id");
            text = this.d_document.createTextNode(disk.getHostId());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getSlotId() != null) {
            el = this.d_document.createElement("slot_id");
            text = this.d_document.createTextNode(disk.getSlotId());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getMounted() != null) {
            el = this.d_document.createElement("mounted");
            text = this.d_document.createTextNode(Short.toString(disk.getMounted()));
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getMountPoint() != null) {
            el = this.d_document.createElement("mount_point");
            text = this.d_document.createTextNode(disk.getMountPoint());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getNumberOfFiles() != null) {
            el = this.d_document.createElement("number_of_files");
            text = this.d_document.createTextNode(Integer.toString(disk.getNumberOfFiles()));
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getAvailableMb() != null) {
            el = this.d_document.createElement("available_mb");
            text = this.d_document.createTextNode(Integer.toString(disk.getAvailableMb()));
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getBytesStored() != null) {
            el = this.d_document.createElement("bytes_stored");
            text = this.d_document.createTextNode(disk.getBytesStored().toString());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getCompleted() != null) {
            el = this.d_document.createElement("completed");
            text = this.d_document.createTextNode(Short.toString(disk.getCompleted()));
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getCompletionDate() != null) {
            el = this.d_document.createElement("completion_date");
            text = this.d_document.createTextNode(disk.getCompletionDate().toString());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getChecksum() != null) {
            el = this.d_document.createElement("checksum");
            text = this.d_document.createTextNode(disk.getChecksum());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getTotalDiskWriteTime() != null) {
            el = this.d_document.createElement("total_disk_write_time");
            text = this.d_document.createTextNode(Float.toString(disk.getTotalDiskWriteTime().floatValue()));
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getLastCheck() != null) {
            el = this.d_document.createElement("last_check");
            text = this.d_document.createTextNode(disk.getLastCheck().toString());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        if (disk.getLastHostId() != null) {
            el = this.d_document.createElement("last_host_id");
            text = this.d_document.createTextNode(disk.getLastHostId());
            el.appendChild(text);
            diskEle.appendChild(el);
        }
        return diskEle;
    }

    public static void initFile(String filename) throws IOException {
        BufferedWriter out = new BufferedWriter(new FileWriter(filename));
        out.write("<?xml version=\"1.0\"?>\n<Disks>\n</Disks>");
        out.close();
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        try {
            NgasDiskDAOXML dao = new NgasDiskDAOXML("/disk.info");
            for (NgasDisk d2 : dao.findAll()) {
                try {
                    NgasDisk.validate(d2);
                    System.out.println(d2.toString());
                    d2.setNumberOfFiles(10);
                    dao.update(d2);
                }
                catch (DAOException e2) {
                    System.out.println(e2.getMessage());
                }
            }
            NgasDisk d3 = new NgasDisk();
            d3.setDiskId("2HA1WSKA");
            dao.update(d3);
        }
        catch (Exception e3) {
            System.out.println(e3.getMessage());
        }
    }
}

