/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.dal;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Logger;
import org.eso.util.dal.ConnectionServiceException;
import org.eso.util.dal.DAOException;
import org.eso.util.dal.NgasDisk;
import org.eso.util.dal.NgasDiskDAO;
import org.eso.util.dal.NgasFile;
import org.eso.util.dal.NgasFileDAOSyb;
import org.eso.util.dal.SybaseConnectionService;

public class NgasDiskDAOSyb
implements NgasDiskDAO {
    static final Logger logger = Logger.getLogger(NgasDiskDAOSyb.class);
    private String d_dbUrl = null;
    private String d_dbUsername = null;
    private String d_dbPassword = null;
    private String d_dbTable = null;
    private String d_dbFilesTable = null;
    private Connection d_connection = null;

    public NgasDiskDAOSyb(String dbUrl, String dbUsername, String dbPassword, String dbTable, String dbFilesTable) {
        this.d_dbUrl = dbUrl;
        this.d_dbUsername = dbUsername;
        this.d_dbPassword = dbPassword;
        this.d_dbTable = dbTable;
        this.d_dbFilesTable = dbFilesTable;
    }

    public NgasDiskDAOSyb(Connection connection, String dbTable, String dbFilesTable) {
        this.d_connection = connection;
        this.d_dbTable = dbTable;
        this.d_dbFilesTable = dbFilesTable;
    }

    @Override
    public List<NgasDisk> findAll() throws DAOException {
        String query = "select * from " + this.d_dbTable;
        return this.executeQuery(query);
    }

    @Override
    public List<NgasDisk> findByDiskId(String id) throws DAOException {
        String query = "select * from " + this.d_dbTable + " where disk_id='" + id + "'";
        return this.executeQuery(query);
    }

    @Override
    public List<NgasDisk> findByLogicalName(String name) throws DAOException {
        String query = "select * from " + this.d_dbTable + " where logical_name='" + name + "'";
        return this.executeQuery(query);
    }

    @Override
    public List<NgasFile> findFilesByDiskId(String Id) throws DAOException {
        String query = "select * from " + this.d_dbFilesTable + " where disk_id='" + Id + "'";
        try {
            List<NgasFile> res = null;
            if (this.d_connection == null) {
                Connection conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
                res = NgasFileDAOSyb.toNgasFileList(SybaseConnectionService.executeStatement(conn, query));
                SybaseConnectionService.closeConnection(conn);
            } else {
                res = NgasFileDAOSyb.toNgasFileList(SybaseConnectionService.executeStatement(this.d_connection, query));
            }
            return res;
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    @Override
    public NgasDisk findLastEntry() throws DAOException {
        String query = "select * from " + this.d_dbTable + " having installation_date=max(installation_date)";
        List<NgasDisk> disks = this.executeQuery(query);
        return disks.get(disks.size() - 1);
    }

    @Override
    public void save(NgasDisk entry) throws DAOException {
        NgasDisk.validate(entry);
        String query = "insert into " + this.d_dbTable + " " + NgasDiskDAOSyb.formatForInsert(entry);
        this.executeQuery(query);
    }

    @Override
    public void saveIfNotFound(NgasDisk entry) throws DAOException {
        NgasDisk.validate(entry);
        if (this.findByDiskId(entry.getDiskId()).size() != 0) {
            throw new DAOException("Record for disk_id=" + entry.getDiskId() + " is already in the database");
        }
        this.save(entry);
    }

    @Override
    public void update(NgasDisk entry) throws DAOException {
        NgasDisk.validate(entry);
        String query = "update " + this.d_dbTable + " " + NgasDiskDAOSyb.formatForUpdate(entry) + " where disk_id='" + entry.getDiskId() + "'";
        this.executeQuery(query);
    }

    @Override
    public void delete(NgasDisk entry) throws DAOException {
        NgasDisk.validate(entry);
        String query = "delete from " + this.d_dbTable + " where disk_id='" + entry.getDiskId() + "'";
        this.executeQuery(query);
    }

    private List<NgasDisk> executeQuery(String query) throws DAOException {
        try {
            List<NgasDisk> res = null;
            if (this.d_connection == null) {
                Connection conn = SybaseConnectionService.getConnection(this.d_dbUrl, this.d_dbUsername, this.d_dbPassword);
                res = NgasDiskDAOSyb.toNgasDiskList(SybaseConnectionService.executeStatement(conn, query));
                SybaseConnectionService.closeConnection(conn);
            } else {
                res = NgasDiskDAOSyb.toNgasDiskList(SybaseConnectionService.executeStatement(this.d_connection, query));
            }
            return res;
        }
        catch (ConnectionServiceException e2) {
            throw new DAOException(e2.getMessage());
        }
    }

    public static List<NgasDisk> toNgasDiskList(ResultSet rs) throws DAOException {
        ArrayList<NgasDisk> res = new ArrayList<NgasDisk>();
        try {
            while (rs.next()) {
                NgasDisk disk = new NgasDisk();
                disk.setDiskId(rs.getString("disk_id"));
                disk.setArchive(rs.getString("archive"));
                disk.setInstallationDate(rs.getDate("installation_date"));
                disk.setType(rs.getString("type"));
                disk.setManufacturer(rs.getString("manufacturer"));
                disk.setLogicalName(rs.getString("logical_name"));
                disk.setHostId(rs.getString("host_id"));
                disk.setSlotId(rs.getString("slot_id"));
                disk.setMounted(rs.getShort("mounted"));
                disk.setMountPoint(rs.getString("mount_point"));
                disk.setNumberOfFiles(rs.getInt("number_of_files"));
                disk.setAvailableMb(rs.getInt("available_mb"));
                disk.setBytesStored(rs.getBigDecimal("bytes_stored"));
                disk.setCompleted(rs.getShort("completed"));
                disk.setCompletionDate(rs.getDate("completion_date"));
                disk.setChecksum(rs.getString("checksum"));
                disk.setTotalDiskWriteTime(rs.getFloat("total_disk_write_time"));
                disk.setLastCheck(rs.getDate("last_check"));
                disk.setLastHostId(rs.getString("last_host_id"));
                res.add(disk);
            }
        }
        catch (SQLException e2) {
            throw new DAOException(e2.getMessage());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return res;
    }

    public static String formatForUpdate(NgasDisk disk) {
        String res = "";
        if (disk.getDiskId() != null) {
            res = res + " set disk_id='" + disk.getDiskId() + "'";
        }
        if (disk.getArchive() != null) {
            res = res + ", archive='" + disk.getArchive() + "'";
        }
        if (disk.getInstallationDate() != null) {
            res = res + ", installation_date='" + disk.getInstallationDate() + "'";
        }
        if (disk.getType() != null) {
            res = res + ", type='" + disk.getType() + "'";
        }
        if (disk.getManufacturer() != null) {
            res = res + ", manufacturer='" + disk.getManufacturer() + "'";
        }
        if (disk.getLogicalName() != null) {
            res = res + ", logical_name='" + disk.getLogicalName() + "'";
        }
        res = disk.getHostId() != null ? res + ", host_id='" + disk.getHostId() + "'" : res + ", host_id=null";
        if (disk.getSlotId() != null) {
            res = res + ", slot_id='" + disk.getSlotId() + "'";
        }
        if (disk.getMounted() != null) {
            res = res + ", mounted=" + disk.getMounted();
        }
        if (disk.getMountPoint() != null) {
            res = res + ", mount_point='" + disk.getMountPoint() + "'";
        }
        if (disk.getNumberOfFiles() != null) {
            res = res + ", number_of_files=" + disk.getNumberOfFiles();
        }
        if (disk.getAvailableMb() != null) {
            res = res + ", available_mb=" + disk.getAvailableMb();
        }
        if (disk.getBytesStored() != null) {
            res = res + ", bytes_stored=" + disk.getBytesStored();
        }
        if (disk.getCompleted() != null) {
            res = res + ", completed=" + disk.getCompleted();
        }
        if (disk.getCompletionDate() != null) {
            res = res + ", completion_date='" + disk.getCompletionDate() + "'";
        }
        if (disk.getChecksum() != null) {
            res = res + ", checksum='" + disk.getChecksum() + "'";
        }
        if (disk.getTotalDiskWriteTime() != null) {
            res = res + ", total_disk_write_time=" + disk.getTotalDiskWriteTime();
        }
        if (disk.getLastCheck() != null) {
            res = res + ", last_check='" + disk.getLastCheck() + "'";
        }
        if (disk.getLastHostId() != null) {
            res = res + ", last_host_id='" + disk.getLastHostId() + "'";
        }
        return res;
    }

    public static String formatForInsert(NgasDisk disk) {
        String first = "(";
        String second = "(";
        if (disk.getDiskId() != null) {
            first = first + "disk_id";
            second = second + "'" + disk.getDiskId() + "'";
        }
        if (disk.getArchive() != null) {
            first = first + ", archive";
            second = second + ", '" + disk.getArchive() + "'";
        }
        if (disk.getInstallationDate() != null) {
            first = first + ", installation_date";
            second = second + ", '" + disk.getInstallationDate() + "'";
        }
        if (disk.getType() != null) {
            first = first + ", type";
            second = second + ", '" + disk.getType() + "'";
        }
        if (disk.getManufacturer() != null) {
            first = first + ", manufacturer";
            second = second + ", '" + disk.getManufacturer() + "'";
        }
        if (disk.getLogicalName() != null) {
            first = first + ", logical_name";
            second = second + ", '" + disk.getLogicalName() + "'";
        }
        if (disk.getHostId() != null) {
            first = first + ", host_id";
            second = second + ", '" + disk.getHostId() + "'";
        }
        if (disk.getSlotId() != null) {
            first = first + ", slot_id";
            second = second + ", '" + disk.getSlotId() + "'";
        }
        if (disk.getMounted() != null) {
            first = first + ", mounted";
            second = second + ", " + disk.getMounted();
        }
        if (disk.getMountPoint() != null) {
            first = first + ", mount_point";
            second = second + ", '" + disk.getMountPoint() + "'";
        }
        if (disk.getNumberOfFiles() != null) {
            first = first + ", number_of_files";
            second = second + ", " + disk.getNumberOfFiles();
        }
        if (disk.getAvailableMb() != null) {
            first = first + ", available_mb";
            second = second + ", " + disk.getAvailableMb();
        }
        if (disk.getBytesStored() != null) {
            first = first + ", bytes_stored";
            second = second + ", " + disk.getBytesStored();
        }
        if (disk.getCompleted() != null) {
            first = first + ", completed";
            second = second + ", " + disk.getCompleted();
        }
        if (disk.getCompletionDate() != null) {
            first = first + ", completion_date";
            second = second + ", '" + disk.getCompletionDate() + "'";
        }
        if (disk.getChecksum() != null) {
            first = first + ", checksum";
            second = second + ", '" + disk.getChecksum() + "'";
        }
        if (disk.getTotalDiskWriteTime() != null) {
            first = first + ", total_disk_write_time";
            second = second + ", " + disk.getTotalDiskWriteTime();
        }
        if (disk.getLastCheck() != null) {
            first = first + ", last_check";
            second = second + ", '" + disk.getLastCheck() + "'";
        }
        if (disk.getLastHostId() != null) {
            first = first + ", last_host_id";
            second = second + ", '" + disk.getLastHostId() + "'";
        }
        first = first + ")";
        second = second + ")";
        return first + " values " + second;
    }

    public static void main(String[] args) {
        BasicConfigurator.configure();
        NgasDiskDAOSyb dao = new NgasDiskDAOSyb("acdbdev.hq.eso.org:6789", "ngas", "ngas_pw", "ngastst1..ngas_disks", null);
        try {
            for (NgasDisk d2 : dao.findByDiskId("tmp-NGAS_ngasdev3-Volume3-Rep-6")) {
                System.out.println(d2.toString());
            }
            NgasDisk disk = new NgasDisk();
            disk.setDiskId("test-disk-01");
            disk.setArchive("TEST");
            disk.setInstallationDate(Date.valueOf("2000-01-01"));
            disk.setType("");
            disk.setLogicalName("USB-000001");
            disk.setNumberOfFiles(10);
            disk.setAvailableMb(80000);
            disk.setBytesStored(BigDecimal.valueOf(2000000000L));
            disk.setCompleted(Integer.valueOf(0).shortValue());
            dao.update(disk);
            for (NgasDisk d3 : dao.findByLogicalName("USB-000001")) {
                System.out.println(d3.toString());
            }
        }
        catch (DAOException e2) {
            System.out.println(e2.getMessage());
        }
    }
}

