/*
 * Decompiled with CFR 0.152.
 */
package org.eso.util.configuration;

import java.io.File;
import org.apache.log4j.Logger;

public final class ConfigurationOption {
    static final Logger logger = Logger.getLogger(ConfigurationOption.class);
    private static final String classLogName = "ConfigurationOption";
    final String optionName;
    public static final int NO_TYPE = 0;
    public static final int STRING = 1;
    public static final int BOOLEAN = 2;
    public static final int INTEGER = 3;
    final int optionType;
    public static final int NO_SOURCE = 0;
    public static final int DEFAULT_VALUE = 1;
    public static final int APPLICATION_PROPERTY = 2;
    public static final int SYSTEM_PROPERTY = 4;
    public static final int COMMAND_LINE = 8;
    public static final int INTERNAL_CONFIGURATION = 16;
    public static final int ALL_SOURCES = 31;
    final int validValueSources;
    private int actualValueSource = 0;
    final String commandLineName;
    final char commandLineChar;
    final String propertyName;
    private File propertyFile = null;
    final Object defaultValue;
    private Object actualValue = null;
    final String helpText;

    ConfigurationOption(String optionName, int optionType, int validValueSources, int actualValueSource, String commandLineName, char commandLineChar, String propertyName, File propertyFile, Object defaultValue, Object actualValue, String helpText) throws IllegalArgumentException, NullPointerException {
        String methodLogName = "ConfigurationOption::ConfigurationOption()";
        logger.trace("ConfigurationOption::ConfigurationOption()");
        if (optionName == null || commandLineName == null || propertyName == null || helpText == null) {
            String message = "ConfigurationOption::ConfigurationOption() - optionName [" + optionName + "], commandLineName [" + commandLineName + "], propertyName [" + propertyName + "], actualValue [" + actualValue + "] and helpText [" + helpText + "] must not be null.";
            logger.fatal(message);
            throw new NullPointerException(message);
        }
        if (optionName.equals("")) {
            String message = "ConfigurationOption::ConfigurationOption() - optionName must not be empty.";
            logger.fatal("ConfigurationOption::ConfigurationOption() - optionName must not be empty.");
            throw new IllegalArgumentException("ConfigurationOption::ConfigurationOption() - optionName must not be empty.");
        }
        if (optionType == 0 || !ConfigurationOption.isDefinedOptionType(optionType)) {
            String message = "ConfigurationOption::ConfigurationOption() - optionType [" + ConfigurationOption.getTypeString(optionType) + "] is invalid.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (validValueSources == 0 || !ConfigurationOption.allValueSourcesDefined(validValueSources)) {
            String message = "ConfigurationOption::ConfigurationOption() - validValueSources [" + ConfigurationOption.getValueSourceString(validValueSources) + "] is invalid.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (ConfigurationOption.isValidValueSource(8, validValueSources) && commandLineName.equals("") && commandLineChar == '\u0000') {
            String message = "ConfigurationOption::ConfigurationOption() - validValueSources [" + ConfigurationOption.getValueSourceString(validValueSources) + "] includes " + ConfigurationOption.getValueSourceString(8) + ", but neither commandLineName [" + commandLineName + "] nor commandLineChar [" + commandLineChar + "] is valid.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (ConfigurationOption.isValidValueSource(2, validValueSources) && ConfigurationOption.isValidValueSource(4, validValueSources) && propertyName.equals("")) {
            String message = "ConfigurationOption::ConfigurationOption() - validValueSources [" + ConfigurationOption.getValueSourceString(validValueSources) + "] includes " + ConfigurationOption.getValueSourceString(2) + " or " + ConfigurationOption.getValueSourceString(4) + ", but propertyName [" + propertyName + "] is empty.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (ConfigurationOption.isValidValueSource(1, validValueSources) && defaultValue == null) {
            String message = "ConfigurationOption::ConfigurationOption() - validValueSources [" + ConfigurationOption.getValueSourceString(validValueSources) + "] includes " + ConfigurationOption.getValueSourceString(1) + ", but defaultValue [" + defaultValue + "] is null.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (actualValueSource == 1 && defaultValue != null && !defaultValue.equals(actualValue)) {
            String message = "ConfigurationOption::ConfigurationOption() - actualValueSource is " + ConfigurationOption.getValueSourceString(1) + ", but actualValue [" + actualValue + "] and defaultValue [" + defaultValue + "] are not equal.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        this.optionName = optionName;
        this.optionType = optionType;
        this.validValueSources = validValueSources;
        this.commandLineName = commandLineName;
        this.commandLineChar = commandLineChar;
        this.propertyName = propertyName;
        this.defaultValue = defaultValue;
        this.helpText = helpText;
        this.setActualValue(actualValue, actualValueSource, propertyFile);
    }

    int getActualValueSource() {
        String methodLogName = "ConfigurationOption::getActualValueSource()";
        logger.trace("ConfigurationOption::getActualValueSource()");
        return this.actualValueSource;
    }

    Object getActualValue() {
        String methodLogName = "ConfigurationOption::getActualValue()";
        logger.trace("ConfigurationOption::getActualValue()");
        return this.actualValue;
    }

    File getPropertyFile() {
        String methodLogName = "ConfigurationOption::getPropertyFile()";
        logger.trace("ConfigurationOption::getPropertyFile()");
        return this.propertyFile;
    }

    void setActualValue(Object optionValue, int valueSource, File propertyFile) throws IllegalArgumentException {
        String methodLogName = "ConfigurationOption::setActualValue()";
        logger.trace("ConfigurationOption::setActualValue()");
        if (!ConfigurationOption.isSingleDefinedValueSource(valueSource)) {
            String message = "ConfigurationOption::setActualValue() - valueSource [" + ConfigurationOption.getValueSourceString(valueSource) + "] must specify a single, defined source.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (!ConfigurationOption.isValidValueSource(valueSource, this.validValueSources)) {
            String message = "ConfigurationOption::setActualValue() - the specified valueSource [" + ConfigurationOption.getValueSourceString(valueSource) + "] is not a valid value source [" + ConfigurationOption.getValueSourceString(this.validValueSources) + "] for option [" + this.optionName + "].";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (!ConfigurationOption.canOverrideValueSource(valueSource, this.actualValueSource)) {
            String message = "ConfigurationOption::setActualValue() - option [" + this.optionName + "] has already" + " been set with a value from a higher priority source [" + ConfigurationOption.getValueSourceString(this.actualValueSource) + "] than the specified valueSource [" + ConfigurationOption.getValueSourceString(valueSource) + "].";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (!(valueSource == 0 ^ optionValue != null)) {
            String message = "ConfigurationOption::setActualValue() - valueSource [" + ConfigurationOption.getValueSourceString(valueSource) + "] requires optionValue to be" + (valueSource == 0 ? "null." : "non-null.");
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (!(valueSource == 2 ^ propertyFile == null)) {
            String message = "ConfigurationOption::setActualValue() - valueSource [" + ConfigurationOption.getValueSourceString(valueSource) + "] requires propertyFile to be" + (valueSource == 2 ? "non-null." : "null.");
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (valueSource != 0) {
            boolean correctValueDataType = false;
            switch (this.optionType) {
                case 1: {
                    correctValueDataType = optionValue instanceof String;
                    break;
                }
                case 2: {
                    correctValueDataType = optionValue instanceof Boolean;
                    break;
                }
                case 3: {
                    correctValueDataType = optionValue instanceof Integer;
                    break;
                }
                default: {
                    String message = "ConfigurationOption::setActualValue() - invalid optionType [" + ConfigurationOption.getTypeString(this.optionType) + "] encountered whilst processing configuration option [" + this.optionName + "].";
                    logger.fatal(message);
                    throw new AssertionError((Object)message);
                }
            }
            if (!correctValueDataType) {
                String message = "ConfigurationOption::setActualValue() - optionValue [" + optionValue.getClass().getName() + "][" + ConfigurationOption.getTypeString(optionValue) + "] does not match the value data type [" + ConfigurationOption.getTypeString(this.optionType) + "] of option [" + this.optionName + "].";
                logger.fatal(message);
                throw new IllegalArgumentException(message);
            }
        }
        this.actualValue = optionValue;
        this.actualValueSource = valueSource;
        this.propertyFile = propertyFile;
        logger.debug("ConfigurationOption::setActualValue() - set value [" + optionValue + "][" + ConfigurationOption.getValueSourceString(valueSource) + "]" + (valueSource == 2 ? "[property file: " + propertyFile + "]" : "") + " for option [" + this.optionName + "].");
    }

    public static boolean isDefinedOptionType(int optionType) {
        String methodLogName = "ConfigurationOption::isDefinedOptionType()";
        logger.trace("ConfigurationOption::isDefinedOptionType()");
        return optionType == 0 || optionType == 1 || optionType == 2 || optionType == 3;
    }

    public static String getTypeString(int optionType) {
        String methodLogName = "ConfigurationOption::getTypeString(int)";
        logger.trace("ConfigurationOption::getTypeString(int)");
        String result = null;
        switch (optionType) {
            case 0: {
                result = "NO_TYPE";
                break;
            }
            case 1: {
                result = "STRING";
                break;
            }
            case 2: {
                result = "BOOLEAN";
                break;
            }
            case 3: {
                result = "INTEGER";
                break;
            }
            default: {
                result = "UNKNOWN(" + optionType + ")";
            }
        }
        return result;
    }

    public static String getTypeString(Object candidate) {
        String methodLogName = "ConfigurationOption::getTypeString(Object)";
        logger.trace("ConfigurationOption::getTypeString(Object)");
        Class<?> type = candidate == null ? null : candidate.getClass();
        String result = null;
        result = type == null ? "NO_TYPE" : (type.equals(String.class) ? "STRING" : (type.equals(Boolean.class) ? "BOOLEAN" : (type.equals(Integer.class) ? "INTEGER" : "UNKNOWN(" + type.getName() + ")")));
        return result;
    }

    public static boolean isSingleDefinedValueSource(int sourceBitmask) {
        String methodLogName = "ConfigurationOption::isSingleDefinedValueSource()";
        logger.trace("ConfigurationOption::isSingleDefinedValueSource()");
        return sourceBitmask == 0 || sourceBitmask == 1 || sourceBitmask == 2 || sourceBitmask == 4 || sourceBitmask == 8 || sourceBitmask == 16;
    }

    public static boolean allValueSourcesDefined(int sourceBitmask) {
        String methodLogName = "ConfigurationOption::allValueSourcesDefined()";
        logger.trace("ConfigurationOption::allValueSourcesDefined()");
        return (sourceBitmask & 0xFFFFFFE0) == 0;
    }

    public static String getValueSourceString(int sourceBitmask) {
        String methodLogName = "ConfigurationOption::getValueSourceString()";
        logger.trace("ConfigurationOption::getValueSourceString()");
        String result = "";
        if (sourceBitmask == 0) {
            result = "NO_SOURCE";
        } else {
            boolean useSeparator = false;
            if ((sourceBitmask & 1) == 1) {
                result = "DEFAULT_VALUE";
                useSeparator = true;
            }
            if ((sourceBitmask & 2) == 2) {
                result = result + (useSeparator ? "|" : "") + "APPLICATION_PROPERTY";
                useSeparator = true;
            }
            if ((sourceBitmask & 4) == 4) {
                result = result + (useSeparator ? "|" : "") + "SYSTEM_PROPERTY";
                useSeparator = true;
            }
            if ((sourceBitmask & 8) == 8) {
                result = result + (useSeparator ? "|" : "") + "COMMAND_LINE";
                useSeparator = true;
            }
            if ((sourceBitmask & 0x10) == 16) {
                result = result + (useSeparator ? "|" : "") + "INTERNAL_CONFIGURATION";
                useSeparator = true;
            }
            if (!ConfigurationOption.allValueSourcesDefined(sourceBitmask)) {
                result = result + (useSeparator ? "|" : "") + "UNKNOWN(" + (sourceBitmask & 0xFFFFFFE0) + ")";
            } else if (sourceBitmask == 31) {
                result = result + " -> ALL_SOURCES";
            }
        }
        return result;
    }

    public static boolean isValidValueSource(int valueSource, int validValueSources) {
        String methodLogName = "ConfigurationOption::isValidValueSource()";
        logger.trace("ConfigurationOption::isValidValueSource()");
        if (!ConfigurationOption.allValueSourcesDefined(valueSource | validValueSources)) {
            String message = "ConfigurationOption::isValidValueSource() - valueSource [" + ConfigurationOption.getValueSourceString(valueSource) + "] and validValueSources [" + ConfigurationOption.getValueSourceString(validValueSources) + "] must specify defined value sources.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (!ConfigurationOption.isSingleDefinedValueSource(valueSource)) {
            String message = "ConfigurationOption::isValidValueSource() - valueSource [" + ConfigurationOption.getValueSourceString(valueSource) + "] may only specify one source.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        return valueSource == 0 || (valueSource & validValueSources) != 0;
    }

    public static boolean canOverrideValueSource(int newValueSource, int oldValueSource) {
        String methodLogName = "ConfigurationOption::canOverrideValueSource()";
        logger.trace("ConfigurationOption::canOverrideValueSource()");
        if (!ConfigurationOption.allValueSourcesDefined(newValueSource | oldValueSource)) {
            String message = "ConfigurationOption::canOverrideValueSource() - newValueSource [" + ConfigurationOption.getValueSourceString(newValueSource) + "] and oldValueSource [" + ConfigurationOption.getValueSourceString(oldValueSource) + "] must specify defined value sources.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        if (!ConfigurationOption.isSingleDefinedValueSource(newValueSource) || !ConfigurationOption.isSingleDefinedValueSource(oldValueSource)) {
            String message = "ConfigurationOption::canOverrideValueSource() - newValueSource [" + ConfigurationOption.getValueSourceString(newValueSource) + "] and oldValueSource [" + ConfigurationOption.getValueSourceString(oldValueSource) + "] may only specify one source each.";
            logger.fatal(message);
            throw new IllegalArgumentException(message);
        }
        return newValueSource >= oldValueSource;
    }
}

