/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.parser;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.log4j.Logger;
import org.eso.oca.fits.TypedHeaderCard;
import org.eso.oca.fits.UndefinedFITSValue;
import org.eso.oca.parser.InterpretationException;
import org.eso.oca.parser.OCAState;
import org.eso.oca.parser.OcaParser;
import org.eso.oca.parser.OcaParserVisitor;
import org.eso.oca.parser.OcaVisitorException;
import org.eso.oca.parser.SimpleNode;

public class ASTPossiblyEquals
extends SimpleNode {
    static Logger logger = Logger.getLogger(ASTPossiblyEquals.class);

    public ASTPossiblyEquals(int id) {
        super(id);
    }

    public ASTPossiblyEquals(OcaParser p, int id) {
        super(p, id);
    }

    @Override
    public Object jjtAccept(OcaParserVisitor visitor, Object data) throws OcaVisitorException {
        return visitor.visit(this, data);
    }

    @Override
    public int precedence() {
        return 30;
    }

    Object possiblyEquals(Object leftOperand, Object rightOperand) throws InterpretationException {
        String message = this.getNodeLocationString() + "Operator '?=' may not be used for \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " ?= " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.error(message);
        throw new InterpretationException(message);
    }

    Boolean possiblyEquals(UndefinedFITSValue leftOperand, Object rightOperand) {
        String message = this.getNodeLocationString() + "Operator '?=' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " ?= " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.debug(message);
        return new Boolean(true);
    }

    Boolean possiblyEquals(Object leftOperand, UndefinedFITSValue rightOperand) {
        String message = this.getNodeLocationString() + "Operator '?=' used with undefined operand: \"" + TypedHeaderCard.findFITSTypeString(leftOperand) + " ?= " + TypedHeaderCard.findFITSTypeString(rightOperand) + "\".";
        logger.debug(message);
        return new Boolean(true);
    }

    Boolean possiblyEquals(BigDecimal leftOperand, BigDecimal rightOperand) {
        return new Boolean(leftOperand.compareTo(rightOperand) == 0);
    }

    Boolean possiblyEquals(BigDecimal leftOperand, BigInteger rightOperand) {
        logger.warn(this.getNodeLocationString() + "Performing '" + TypedHeaderCard.findFITSTypeString(leftOperand) + " ?= " + TypedHeaderCard.findFITSTypeString(rightOperand) + "'.");
        BigDecimal promotedRightOperand = new BigDecimal(rightOperand);
        return new Boolean(leftOperand.compareTo(promotedRightOperand) == 0);
    }

    Boolean possiblyEquals(BigInteger leftOperand, BigDecimal rightOperand) {
        logger.warn(this.getNodeLocationString() + "Performing '" + TypedHeaderCard.findFITSTypeString(leftOperand) + " ?= " + TypedHeaderCard.findFITSTypeString(rightOperand) + "'.");
        BigDecimal promotedLeftOperand = new BigDecimal(leftOperand);
        return new Boolean(promotedLeftOperand.compareTo(rightOperand) == 0);
    }

    Boolean possiblyEquals(BigInteger leftOperand, BigInteger rightOperand) {
        return new Boolean(leftOperand.equals(rightOperand));
    }

    Boolean possiblyEquals(String leftOperand, String rightOperand) {
        return new Boolean(leftOperand.equals(rightOperand));
    }

    Boolean possiblyEquals(Boolean leftOperand, Boolean rightOperand) {
        return new Boolean(leftOperand.equals(rightOperand));
    }

    @Override
    public void interpret(OCAState state) throws InterpretationException {
        logger.trace("interpret() called.");
        ++state.opCounter;
        this.jjtGetChild(0).interpret(state);
        this.jjtGetChild(1).interpret(state);
        state.stack[--state.top] = this.dispatch(this.getClass(), "possiblyEquals", new Object[]{state.stack[state.top], state.stack[state.top + 1]});
    }
}

