/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.dal;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.eso.oca.dal.ColumnMetaData;
import org.eso.oca.dal.TableMetaData;

public class DBMetaData {
    private static Logger logger = Logger.getLogger(DBMetaData.class);
    static final String TABLE_NAME = "TABLE_NAME";
    static final String COLUMN_NAME = "COLUMN_NAME";
    static final String DATA_TYPE = "DATA_TYPE";
    static final String TYPE_NAME = "TYPE_NAME";

    public static TableMetaData getTableMetaData(Connection conn, String tableName) throws SQLException {
        String thisMethod = "DBMetaData::getTableMetaData(" + tableName + ")";
        logger.trace(thisMethod);
        if (tableName == null) {
            throw new IllegalArgumentException(thisMethod + " - tableName must not be null");
        }
        if (conn == null) {
            throw new IllegalArgumentException(thisMethod + " - connection must not be null");
        }
        DatabaseMetaData dbmd = conn.getMetaData();
        ResultSet rs = dbmd.getColumns(null, null, tableName, null);
        TableMetaData result = new TableMetaData();
        Vector<ColumnMetaData> columns = new Vector<ColumnMetaData>();
        while (rs.next()) {
            ColumnMetaData column = new ColumnMetaData();
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                if (rs.getMetaData().getColumnName(i).equals(TABLE_NAME)) {
                    result.name = rs.getString(i);
                    continue;
                }
                if (rs.getMetaData().getColumnName(i).equals(COLUMN_NAME)) {
                    column.columnName = rs.getString(i);
                    continue;
                }
                if (rs.getMetaData().getColumnName(i).equals(DATA_TYPE)) {
                    column.type = rs.getInt(i);
                    continue;
                }
                if (!rs.getMetaData().getColumnName(i).equals(TYPE_NAME)) continue;
                column.typeName = rs.getString(i);
            }
            logger.debug("[ColumnName=" + column.columnName + "] [ColumnType=" + column.typeName + "]");
            columns.add(column);
        }
        if (columns.size() == 0) {
            result = null;
        } else {
            result.columns = columns.toArray(new ColumnMetaData[columns.size()]);
        }
        logger.debug(thisMethod + " - " + result);
        return result;
    }

    public static ColumnMetaData getColumnMetaData(TableMetaData tableMetaData, String columnName) {
        String thisMethod = "DBMetaData::getColumnMetaData(" + columnName + ")";
        logger.trace(thisMethod);
        ColumnMetaData result = null;
        if (tableMetaData != null) {
            ColumnMetaData[] columns = tableMetaData.columns;
            for (int i = 0; i < columns.length; ++i) {
                if (!columns[i].columnName.equals(columnName)) continue;
                result = columns[i];
                break;
            }
        }
        logger.debug(thisMethod + " - " + result);
        return result;
    }

    public static String getNullValueForColumn(TableMetaData tableMetaData, String columnName) {
        String thisMethod = "DBMetaData::getNullValueForColumn(" + columnName + ")";
        logger.trace(thisMethod);
        String result = "null";
        ColumnMetaData column = DBMetaData.getColumnMetaData(tableMetaData, columnName);
        if (column != null) {
            String typeName = column.typeName;
            result = "convert(" + typeName + ", null)";
        }
        logger.debug(thisMethod + " - " + result);
        return result;
    }
}

