/*
 * Decompiled with CFR 0.152.
 */
package org.eso.oca.backend;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eso.oca.backend.ABVisitor;
import org.eso.oca.backend.ABVisitorException;
import org.eso.oca.backend.AssociationBlock;
import org.eso.oca.fits.OCAFile;
import org.eso.util.filesystem.FileSystemOperations;
import org.eso.util.misc.Conversions;

public class RBFileWriter
implements ABVisitor {
    private String rbDir;
    static final String EOL = System.getProperty("line.separator");
    static final String UNDEFINED = "UNDEFINED";
    private static final String RB_LEVEL_CHARS = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final int MAX_RB_LEVEL = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".length() - 1;
    static Logger logger = Logger.getLogger(RBFileWriter.class);

    public RBFileWriter(String dir) {
        if (dir == null) {
            throw new IllegalArgumentException("null AB dir");
        }
        this.rbDir = dir;
    }

    @Override
    public void visit(AssociationBlock ab) throws ABVisitorException {
        try {
            String instrume;
            String rbBaseName = this.evaluateFilename(ab);
            for (OCAFile p : ab.getProductFiles()) {
                try {
                    String newPipefile = p.getPipefile().replaceFirst(p.getDpId() + "(_tpl-[A-Z][0-9][0-9]){0,1}", rbBaseName);
                    p.getCards().put("PIPEFILE", newPipefile);
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    System.exit(1);
                }
            }
            String rbFilename = this.rbDir + File.separator + rbBaseName + ".rb";
            File rbFile = new File(rbFilename);
            String tmpRbFilename = rbFilename + ".tmp";
            File tmpRbFile = new File(tmpRbFilename);
            FileWriter out = new FileWriter(tmpRbFile);
            String prodRootName = "r." + rbBaseName;
            Date rbDate = new Date();
            SimpleDateFormat isoFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                rbDate = Conversions.convertMjdObsToJavaDate(ab.getExemplar().getMjdObs().doubleValue());
            }
            catch (Exception e3) {
                logger.error("Using default date");
            }
            String rbDateStr = isoFormat.format(rbDate);
            String rbProductName = ab.getProductDir() + File.separator + rbDateStr + File.separator + prodRootName;
            try {
                instrume = ab.getInstrument().toLowerCase();
            }
            catch (Exception e3) {
                instrume = UNDEFINED;
            }
            StringBuffer rbRawBuffer = new StringBuffer();
            OCAFile[] rawFiles = ab.getInputFiles();
            for (int i = 0; i < rawFiles.length; ++i) {
                String doCatg;
                String rawFilename;
                try {
                    rawFilename = rawFiles[i].getFilename();
                }
                catch (Exception e11) {
                    rawFilename = UNDEFINED;
                }
                try {
                    doCatg = rawFiles[i].getDoCatg();
                }
                catch (Exception e12) {
                    doCatg = UNDEFINED;
                }
                rbRawBuffer.append(rawFilename + " " + doCatg + EOL);
            }
            StringBuffer rbCalibBuffer = new StringBuffer();
            OCAFile[] calibFiles = ab.getAssociatedFiles();
            for (int i = 0; i < calibFiles.length; ++i) {
                String doCatg;
                String calibFilename;
                block23: {
                    try {
                        if (calibFiles[i].isVirtual()) {
                            Date calibDate = new Date();
                            try {
                                calibDate = Conversions.convertMjdObsToJavaDate(calibFiles[i].getMjdObs().doubleValue());
                            }
                            catch (Exception e4) {
                                logger.error("Using default date");
                            }
                            String calibDateStr = isoFormat.format(calibDate);
                            calibFilename = ab.getProductDir() + File.separator + calibDateStr + File.separator + calibFiles[i].getPipefile();
                            break block23;
                        }
                        calibFilename = calibFiles[i].getFilename();
                    }
                    catch (Exception e11) {
                        calibFilename = UNDEFINED;
                    }
                }
                try {
                    doCatg = calibFiles[i].getDoCatg();
                }
                catch (Exception e12) {
                    doCatg = UNDEFINED;
                }
                rbCalibBuffer.append(calibFilename + " " + doCatg + EOL);
            }
            String[] params = ab.getRecipeParams();
            out.write("recipe: " + ab.getRecipe() + EOL + EOL);
            out.write("instrument: " + instrume + EOL + EOL);
            out.write("priority: " + ab.getPriority().toString() + EOL + EOL);
            out.write(rbProductName + EOL + EOL);
            out.write("{" + EOL);
            out.write(rbRawBuffer.toString());
            out.write("}" + EOL + EOL);
            out.write("{" + EOL);
            out.write(rbCalibBuffer.toString());
            out.write("}" + EOL + EOL);
            for (int i = 0; i < params.length; ++i) {
                out.write(params[i] + EOL);
            }
            out.close();
            tmpRbFile.renameTo(rbFile);
            logger.debug("RBFileWriter::visit() - moved [" + tmpRbFile.getAbsolutePath() + "] to [" + rbFile.getAbsolutePath() + "].");
            logger.info("RBFileWriter::visit() - wrote RB [" + rbFilename + "].");
        }
        catch (IOException e5) {
            throw new ABVisitorException(e5);
        }
    }

    public String evaluateFilename(AssociationBlock ab) throws ABVisitorException {
        String rbBaseName = ab.getABName();
        int currentIndex = rbBaseName.lastIndexOf(45);
        int rbLevel = 0;
        if (currentIndex >= 0) {
            char rbLevelChar = rbBaseName.charAt(currentIndex + 1);
            rbLevel = RB_LEVEL_CHARS.indexOf(rbLevelChar);
            if (rbLevel < 0) {
                rbLevel = 0;
            } else {
                if (++rbLevel > MAX_RB_LEVEL) {
                    String logMessage = "Processing RB basename [" + rbBaseName + "] will exceed the maximum RB level [" + RB_LEVEL_CHARS.charAt(MAX_RB_LEVEL) + "].";
                    logger.error(logMessage);
                    throw new ABVisitorException(logMessage);
                }
                rbBaseName = rbBaseName.substring(0, currentIndex);
            }
        }
        rbBaseName = rbBaseName + '-' + RB_LEVEL_CHARS.charAt(rbLevel);
        int rbNumber = 0;
        DecimalFormat rbNumberFormat = new DecimalFormat("00");
        while (rbBaseName.startsWith("r.")) {
            rbBaseName = rbBaseName.substring(2);
        }
        HashSet<String> existingFilenames = new HashSet<String>();
        if (!FileSystemOperations.listFilenamesInDirectory(new File(this.rbDir), null, existingFilenames)) {
            String logMessage = "Unable to list contents of RB directory [" + this.rbDir + "].";
            logger.error(logMessage);
            throw new ABVisitorException(logMessage);
        }
        HashSet<String> existingBasenames = new HashSet<String>();
        Iterator<String> existingFilenameIterator = existingFilenames.iterator();
        String currentString = null;
        while (existingFilenameIterator.hasNext()) {
            currentString = existingFilenameIterator.next();
            currentIndex = currentString.lastIndexOf(46);
            if (currentIndex < 0) {
                existingBasenames.add(currentString);
                continue;
            }
            existingBasenames.add(currentString.substring(0, currentIndex));
        }
        do {
            currentString = rbBaseName + rbNumberFormat.format(++rbNumber);
            if (rbNumber <= 99) continue;
            String logMessage = "RB basename [" + currentString + "] will exceed the maximum RB number [99].";
            logger.error(logMessage);
            throw new ABVisitorException(logMessage);
        } while (existingBasenames.contains(currentString));
        rbBaseName = currentString;
        return rbBaseName;
    }
}

