/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.filesystem;

import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eso.gasgano.datamodel.filesystem.FitsFile;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.keyword.KeywordSet;
import org.eso.gasgano.tools.Report;

public class FitsFileReport
extends Report {
    private String header;
    private String footer;
    private PrintWriter pw = null;
    private Vector inputFiles = null;
    private Vector keywordVector = null;
    private Vector colNames = null;
    private Hashtable keywords = null;
    private int[] columnWidths = null;

    public FitsFileReport(Vector fv, Vector kwv, Vector cn) {
        this.inputFiles = fv;
        this.keywordVector = kwv;
        this.colNames = cn;
        this.keywords = new Hashtable();
        if (!this.keywordVector.elementAt(0).equals("FILENAME")) {
            this.keywordVector.insertElementAt("FILENAME", 0);
            this.colNames.insertElementAt("FILENAME", 0);
        }
        Enumeration e2 = this.keywordVector.elements();
        while (e2.hasMoreElements()) {
            Keyword k = new Keyword((String)e2.nextElement(), "");
            this.keywords.put(k.getName(), k);
        }
        SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy hh:mm:ss");
        this.header = new String("\nReport Title: Fits File Report\n\nDate Generated: " + formatter.format(new Date()) + "\n");
        this.footer = new String("End of Report");
        this.columnWidths = new int[this.keywordVector.size()];
        for (int i = 0; i < this.keywordVector.size(); ++i) {
            this.columnWidths[i] = 0;
        }
    }

    @Override
    public int[] getColumnWidths() {
        return this.columnWidths;
    }

    public void setHeader(String s) {
        this.header = s;
    }

    public void setFooter(String s) {
        this.footer = s;
    }

    public String getReportHeader() {
        return this.header;
    }

    public String getReportFooter() {
        return this.footer;
    }

    @Override
    public void setPrintWriter(PrintWriter p) {
        this.pw = p;
    }

    @Override
    public boolean generateReport() {
        String fileName = null;
        if (this.pw == null) {
            return false;
        }
        boolean rc = true;
        Enumeration e2 = this.inputFiles.elements();
        String[][] values = new String[this.inputFiles.size()][this.keywordVector.size()];
        int fileNum = 0;
        while (e2.hasMoreElements()) {
            FitsFile ff = null;
            Object tmpObject = e2.nextElement();
            KeywordSet ksoc = (KeywordSet)tmpObject;
            boolean releaseMemory = true;
            if (tmpObject instanceof FitsFile) {
                ff = (FitsFile)tmpObject;
                fileName = ff.getFileName();
                if (ff.headerInMemory()) {
                    releaseMemory = false;
                } else {
                    ff.readFitsHeader();
                    ff.addMetaKeywords();
                }
            }
            int col = 0;
            Enumeration kwe = this.keywordVector.elements();
            while (kwe.hasMoreElements()) {
                String tmpKeyword = (String)kwe.nextElement();
                if (tmpKeyword.equals("FILENAME")) {
                    values[fileNum][col] = fileName;
                    this.storeWidth(fileName, col);
                } else {
                    Keyword k = ksoc.getKeyword(tmpKeyword);
                    if (k == null) {
                        values[fileNum][col] = new String("");
                    } else {
                        this.storeWidth(k.getValue(), col);
                        values[fileNum][col] = k.getValue();
                    }
                }
                ++col;
            }
            if (tmpObject instanceof FitsFile && releaseMemory) {
                ff.freeHeaderMemory();
            }
            ++fileNum;
        }
        this.pw.println(this.header + "\n\n");
        e2 = this.colNames.elements();
        int colNum = 0;
        while (e2.hasMoreElements()) {
            String val = (String)e2.nextElement();
            this.storeWidth(val, colNum);
            this.pw.print(val);
            for (int yetToPad = 1 + this.columnWidths[colNum] - val.length(); yetToPad > 0; --yetToPad) {
                this.pw.print(' ');
            }
            ++colNum;
        }
        this.pw.println("\n");
        for (int fn = 0; fn < this.inputFiles.size(); ++fn) {
            for (int cn = 0; cn < this.keywordVector.size(); ++cn) {
                String val = values[fn][cn];
                this.pw.print(val);
                for (int yetToPad = 1 + this.columnWidths[cn] - val.length(); yetToPad > 0; --yetToPad) {
                    this.pw.print(' ');
                }
            }
            this.pw.println("");
        }
        this.pw.println(this.footer);
        if (this.keywordVector.elementAt(0).equals("FILENAME")) {
            this.keywordVector.removeElementAt(0);
            this.colNames.removeElementAt(0);
        }
        return rc;
    }

    public void cleanup() {
    }

    public void storeWidth(String s, int c2) {
        if (this.columnWidths != null && this.columnWidths[c2] < s.length()) {
            this.columnWidths[c2] = s.length();
        }
    }
}

