/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel;

import org.eso.gasgano.datamodel.OBComponentFilter;
import org.eso.gasgano.datamodel.filesystem.DFSFile;
import org.eso.gasgano.datamodel.filesystem.FitsFile;
import org.eso.gasgano.datamodel.gui.OBComponent;
import org.eso.gasgano.keyword.ExpressionEvaluationException;
import org.eso.gasgano.keyword.KeywordExpression;
import org.eso.gasgano.properties.PropertyDB;

public class ExprFilter
implements OBComponentFilter {
    private KeywordExpression expr = null;

    public ExprFilter(KeywordExpression exp) {
        this.expr = exp;
    }

    @Override
    public boolean accept(OBComponent f) {
        boolean rc = false;
        DFSFile dfsFile = f.getSourceFile();
        if (dfsFile instanceof FitsFile) {
            FitsFile fitsFile = (FitsFile)dfsFile;
            boolean freeMemory = true;
            if (fitsFile.headerInMemory()) {
                freeMemory = false;
            } else {
                fitsFile.readFitsHeader();
                fitsFile.addMetaKeywords();
            }
            try {
                rc = this.expr.evaluate(fitsFile);
            }
            catch (ExpressionEvaluationException e2) {
                if (PropertyDB.getInstance().isDebug(7)) {
                    System.out.println(e2.toString() + " with: " + f.toString());
                }
                rc = false;
            }
            if (freeMemory) {
                fitsFile.freeHeaderMemory();
            }
        }
        return rc;
    }

    @Override
    public String getDescription() {
        return this.expr.toString();
    }
}

