/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.util;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eso.dfs.util.SharedListListener;

public class SharedList {
    private ArrayList list;
    private boolean sortList = false;
    private int maxCapacity = 20;
    private List selectionHistory = new ArrayList();
    private List listeners = new ArrayList();

    public SharedList(int initialCapacity) {
        this.list = new ArrayList(initialCapacity);
    }

    public void setSortList(boolean s) {
        this.sortList = s;
        this.sort();
        this.notifyListChanged();
    }

    public boolean isSortList() {
        return this.sortList;
    }

    public int getMaxCapacity() {
        return this.maxCapacity;
    }

    public void setMaxCapacity(int max) {
        if (max >= 0) {
            this.maxCapacity = max;
            this.trimToCapacity();
            this.sort();
        }
    }

    protected void updateList(Object newSelection) {
        boolean newItem;
        if (newSelection != null && newSelection.toString().length() > 0 && (newItem = this.recordSelection(newSelection))) {
            this.trimToCapacity();
            this.sort();
        }
    }

    protected boolean recordSelection(Object newSelection) {
        boolean newItem;
        int idx = this.selectionHistory.indexOf(newSelection);
        boolean bl = newItem = idx < 0;
        if (idx > 0) {
            this.selectionHistory.remove(idx);
            this.selectionHistory.add(0, newSelection);
        } else if (idx < 0) {
            this.selectionHistory.add(0, newSelection);
        }
        if (newItem) {
            this.list.add(newSelection);
        }
        return newItem;
    }

    protected void trimToCapacity() {
        while (this.selectionHistory.size() > this.maxCapacity) {
            Object removedItem = this.selectionHistory.remove(this.selectionHistory.size() - 1);
            if (removedItem == null) continue;
            this.list.remove(removedItem);
        }
    }

    protected void sort() {
        if (this.sortList) {
            Collections.sort(this.list, Collator.getInstance());
        }
    }

    public SharedList() {
        this.list = new ArrayList();
    }

    public SharedList(Collection c2) {
        this.list = new ArrayList(c2);
    }

    public void addListListener(SharedListListener l) {
        if (!this.listeners.contains(l)) {
            this.listeners.add(l);
        }
    }

    public void removeListListener(SharedListListener l) {
        this.listeners.remove(l);
    }

    protected void notifyListChanged() {
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ((SharedListListener)i.next()).listChanged(this);
        }
    }

    public void add(Object o) {
        this.updateList(o);
        this.notifyListChanged();
    }

    public void remove(Object o) {
        this.list.remove(o);
        this.selectionHistory.remove(o);
        this.notifyListChanged();
    }

    public void remove(int i) {
        Object removedItem = this.list.get(i);
        this.list.remove(i);
        this.selectionHistory.remove(removedItem);
        this.notifyListChanged();
    }

    public int size() {
        return this.list.size();
    }

    public Object get(int i) {
        return this.list.get(i);
    }

    public Iterator iterator() {
        return this.list.iterator();
    }
}

