/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.services.gui;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eso.dfs.services.ServiceException;
import org.eso.dfs.services.gui.FileImageDisplayHandler;

public class FileImageDisplayService {
    private List handlerChain = new ArrayList();
    private static FileImageDisplayService instance;

    private FileImageDisplayService() {
    }

    public static synchronized FileImageDisplayService getInstance() {
        if (instance == null) {
            instance = new FileImageDisplayService();
        }
        return instance;
    }

    public void displayFile(String[] fileIds, boolean showImage) throws ServiceException {
        boolean handled = false;
        Iterator i = this.handlerChain.iterator();
        while (!handled && i.hasNext()) {
            FileImageDisplayHandler h = (FileImageDisplayHandler)i.next();
            handled = h.displayFileImages(fileIds, showImage);
        }
        if (!handled) {
            throw new ServiceException("No handler found for requested images.");
        }
    }

    public void displayFile(Component comp, String[] fileIds, boolean showImage) {
        try {
            this.displayFile(fileIds, showImage);
        }
        catch (ServiceException e2) {
            System.out.println(e2.getMessage());
        }
    }

    public void addFileImageDisplayHandler(FileImageDisplayHandler h) {
        this.removeFileImageDisplayHandler(h);
        this.handlerChain.add(h);
    }

    public void removeFileImageDisplayHandler(FileImageDisplayHandler h) {
        this.handlerChain.remove(h);
    }
}

