/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.io;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.zip.GZIPInputStream;
import org.eso.dfs.io.InputStreamPrinter;

public class MemMappedFileInputStream
extends InputStream {
    private MappedByteBuffer buffer;
    private FileChannel fc;

    public MemMappedFileInputStream(File f) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        this.fc = fis.getChannel();
        int sz = (int)this.fc.size();
        MappedByteBuffer b2 = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
        this.buffer = this.fc.map(FileChannel.MapMode.READ_ONLY, 0L, sz);
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        int i;
        if (this.buffer.hasRemaining()) {
            for (i = 0; i != arg2; ++i) {
                arg0[i + arg1] = this.buffer.get();
                if (this.buffer.hasRemaining()) continue;
                break;
            }
        } else {
            i = -1;
        }
        return i;
    }

    @Override
    public void close() throws IOException {
        this.fc.close();
    }

    @Override
    public void mark(int arg0) {
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer.hasRemaining()) {
            return this.buffer.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public void reset() throws IOException {
        this.buffer.reset();
    }

    @Override
    public long skip(long arg0) throws IOException {
        this.buffer.position(this.buffer.position() + (int)arg0);
        return this.buffer.position();
    }

    @Override
    public int available() throws IOException {
        System.out.println("AVAILABLE");
        return this.buffer.remaining();
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        return this.read(arg0, 0, arg0.length);
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.out.println("Please list files on command line.");
        } else {
            for (int i = 0; i < args.length; ++i) {
                File f = new File(args[i]);
                try {
                    int c2;
                    InputStream r = new InputStreamPrinter(new MemMappedFileInputStream(f));
                    if (args[i].endsWith(".gz")) {
                        r = new GZIPInputStream(r);
                    }
                    while ((c2 = ((InputStream)r).read()) != -1) {
                        System.out.print((char)c2);
                    }
                    continue;
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                    System.out.println("Error reading file: " + e2.toString());
                }
            }
        }
    }
}

