/*
 * Decompiled with CFR 0.152.
 */
package org.eso.dfs.datatransfer;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.eso.dfs.datatransfer.FileListTransferable;

public abstract class FileListTransferHandler
extends TransferHandler {
    private boolean exportEnabled = true;
    private boolean importEnabled = true;

    public FileListTransferHandler() {
    }

    public FileListTransferHandler(boolean importOK, boolean exportOK) {
        this.setImportEnabled(importOK);
        this.setExportEnabled(exportOK);
    }

    protected abstract List exportFileList(JComponent var1);

    protected abstract void importFileList(JComponent var1, List var2);

    @Override
    protected Transferable createTransferable(JComponent c2) {
        FileListTransferable rc = null;
        if (this.isExportEnabled()) {
            List exported = this.exportFileList(c2);
            rc = exported == null ? null : new FileListTransferable(this.exportFileList(c2));
        }
        return rc;
    }

    @Override
    public int getSourceActions(JComponent c2) {
        return 1;
    }

    @Override
    public boolean importData(JComponent c2, Transferable t) {
        if (this.canImport(c2, t.getTransferDataFlavors())) {
            try {
                List files = (List)t.getTransferData(DataFlavor.javaFileListFlavor);
                this.importFileList(c2, files);
                return true;
            }
            catch (UnsupportedFlavorException ufe) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected void exportDone(JComponent c2, Transferable data, int action) {
    }

    @Override
    public boolean canImport(JComponent c2, DataFlavor[] flavors) {
        if (!this.isImportEnabled()) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!DataFlavor.javaFileListFlavor.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }

    public boolean isExportEnabled() {
        return this.exportEnabled;
    }

    public boolean isImportEnabled() {
        return this.importEnabled;
    }

    public void setExportEnabled(boolean exportEnabled) {
        this.exportEnabled = exportEnabled;
    }

    public void setImportEnabled(boolean importEnabled) {
        this.importEnabled = importEnabled;
    }
}

