/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl.gui;

import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.eso.cpl.gui.Renderers;

public abstract class DataColumn {
    private String name_;
    private boolean isEditable_;
    private TableCellEditor editor_;
    private TableCellRenderer renderer_;
    private int preferredWidth_ = 75;

    public DataColumn(String name, boolean isEditable, Class clazz, int prefWidth) {
        this(name, isEditable, clazz);
        this.preferredWidth_ = prefWidth;
    }

    public DataColumn(String name, boolean isEditable, Class clazz) {
        this.name_ = name;
        this.isEditable_ = isEditable;
        clazz = clazz == null ? Object.class : clazz;
        this.renderer_ = Renderers.getDefaultRenderer(clazz);
        this.editor_ = Renderers.getDefaultEditor(clazz);
    }

    public DataColumn(String name, boolean isEditable) {
        this(name, isEditable, null);
    }

    public DataColumn(String name, boolean isEditable, int prefWidth) {
        this(name, isEditable, null);
        this.preferredWidth_ = prefWidth;
    }

    public abstract Object getValue(int var1);

    public boolean isEditable(int irow) {
        return this.isEditable_;
    }

    public void setValue(int irow, Object value) {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return this.name_;
    }

    public TableCellRenderer getCellRenderer(int irow) {
        return this.renderer_;
    }

    public String getRendererTip(int irow) {
        return null;
    }

    public TableCellEditor getCellEditor(int irow) {
        return this.editor_;
    }

    public int getPreferredWidth() {
        return this.preferredWidth_;
    }

    public void setPreferredWidth(int preferredWidth) {
        this.preferredWidth_ = preferredWidth;
    }
}

