/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import nom.tam.fits.CloseIS;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.RandomAccess;

public class FitsUtil {
    private static boolean wroteCheckingError = false;

    public static void reposition(Object o, long offset) throws FitsException {
        if (o == null) {
            throw new FitsException("Attempt to reposition null stream");
        }
        if (!(o instanceof RandomAccess) || offset < 0L) {
            throw new FitsException("Invalid attempt to reposition stream " + o + " of type " + o.getClass().getName() + " to " + offset);
        }
        try {
            ((RandomAccess)o).seek(offset);
        }
        catch (IOException e2) {
            throw new FitsException("Unable to repostion stream " + o + " of type " + o.getClass().getName() + " to " + offset + "   Exception:" + e2);
        }
    }

    public static long findOffset(Object o) {
        if (o instanceof RandomAccess) {
            return ((RandomAccess)o).getFilePointer();
        }
        return -1L;
    }

    public static int padding(int size) {
        return FitsUtil.padding((long)size);
    }

    public static int padding(long size) {
        int mod = (int)(size % 2880L);
        if (mod > 0) {
            mod = 2880 - mod;
        }
        return mod;
    }

    public static int addPadding(int size) {
        return size + FitsUtil.padding(size);
    }

    public static long addPadding(long size) {
        return size + (long)FitsUtil.padding(size);
    }

    static InputStream decompress(InputStream compressed) throws FitsException {
        PushbackInputStream pb = new PushbackInputStream(compressed, 2);
        int mag1 = -1;
        int mag2 = -1;
        try {
            mag1 = pb.read();
            mag2 = pb.read();
            if (mag1 == 31 && mag2 == 139) {
                pb.unread(mag2);
                pb.unread(mag1);
                return new GZIPInputStream(pb);
            }
            if (mag1 == 31 && mag2 == 157) {
                pb.unread(mag2);
                pb.unread(mag1);
                return FitsUtil.compressInputStream(pb);
            }
            if (mag1 == 66 && mag2 == 90) {
                if (System.getenv("BZIP_DECOMPRESSOR") != null) {
                    pb.unread(mag2);
                    pb.unread(mag1);
                    return FitsUtil.bunzipper(pb);
                }
                String cname = "org.apache.tools.bzip2.CBZip2InputStream";
                try {
                    Constructor<?> con = Class.forName(cname).getConstructor(InputStream.class);
                    return (InputStream)con.newInstance(pb);
                }
                catch (Exception e2) {
                    System.err.println("Unable to find constructor for BZIP2 decompression.  Is the Apache BZIP jar in the classpath?");
                    throw new FitsException("No CBZip2InputStream class found for bzip2 compressed file");
                }
            }
            pb.unread(mag2);
            pb.unread(mag1);
            return pb;
        }
        catch (IOException e3) {
            throw new FitsException("Unable to analyze input stream");
        }
    }

    static InputStream compressInputStream(final InputStream compressed) throws FitsException {
        try {
            Process proc = new ProcessBuilder("uncompress", "-c").start();
            final OutputStream input = proc.getOutputStream();
            Thread copier = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = compressed.read(buffer, 0, buffer.length)) > 0) {
                            input.write(buffer, 0, len);
                        }
                        compressed.close();
                        input.close();
                    }
                    catch (IOException e2) {
                        return;
                    }
                }
            });
            copier.start();
            return proc.getInputStream();
        }
        catch (Exception e2) {
            throw new FitsException("Unable to read .Z compressed stream.\nIs `uncompress' in the path?\n:" + e2);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isCompressed(File test) {
        InputStream fis;
        block16: {
            fis = null;
            if (!test.exists()) break block16;
            fis = new FileInputStream(test);
            int mag1 = fis.read();
            int mag2 = fis.read();
            fis.close();
            if (mag1 == 31 && (mag2 == 139 || mag2 == 157) || mag1 == 66 && mag2 == 90) {
                if (fis == null) return true;
                try {
                    fis.close();
                    return true;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return true;
            }
            if (fis == null) return false;
            try {
                fis.close();
                return false;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
            catch (IOException e2) {
                if (fis == null) return false;
                try {
                    fis.close();
                    return false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return false;
                catch (Throwable throwable) {
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
        if (fis == null) return false;
        try {
            fis.close();
            return false;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isCompressed(String filename) {
        if (filename == null) {
            return false;
        }
        Object fis = null;
        File test = new File(filename);
        if (test.exists()) {
            return FitsUtil.isCompressed(test);
        }
        int len = filename.length();
        return len > 2 && (filename.substring(len - 3).equalsIgnoreCase(".gz") || filename.substring(len - 2).equals(".Z"));
    }

    public static int maxLength(String[] o) throws FitsException {
        int max = 0;
        int i = 0;
        while (i < o.length) {
            if (o[i] != null && o[i].length() > max) {
                max = o[i].length();
            }
            ++i;
        }
        return max;
    }

    public static byte[] stringsToByteArray(String[] o, int maxLen) {
        byte[] res = new byte[o.length * maxLen];
        int i = 0;
        while (i < o.length) {
            byte[] bstr = null;
            bstr = o[i] == null ? new byte[]{} : AsciiFuncs.getBytes(o[i]);
            int cnt = bstr.length;
            if (cnt > maxLen) {
                cnt = maxLen;
            }
            System.arraycopy(bstr, 0, res, i * maxLen, cnt);
            int j = cnt;
            while (j < maxLen) {
                res[i * maxLen + j] = 32;
                ++j;
            }
            ++i;
        }
        return res;
    }

    public static String[] byteArrayToStrings(byte[] o, int maxLen) {
        boolean checking = FitsFactory.getCheckAsciiStrings();
        String[] res = new String[o.length / maxLen];
        int i = 0;
        while (i < res.length) {
            int start = i * maxLen;
            int end = start + maxLen;
            while (start < end) {
                if (o[start] != 32) break;
                ++start;
            }
            while (end > start) {
                if (o[end - 1] != 32) break;
                --end;
            }
            boolean errFound = false;
            int j = start;
            while (j < end) {
                if (o[j] == 0) {
                    end = j;
                    break;
                }
                if (checking && (o[j] < 32 || o[j] > 126)) {
                    errFound = true;
                    o[j] = 32;
                }
                ++j;
            }
            res[i] = AsciiFuncs.asciiString(o, start, end - start);
            if (errFound && !wroteCheckingError) {
                System.err.println("Warning: Invalid ASCII character[s] detected in string:" + res[i]);
                System.err.println("   Converted to space[s].  Any subsequent invalid characters will be converted silently");
                wroteCheckingError = true;
            }
            ++i;
        }
        return res;
    }

    static byte[] booleanToByte(boolean[] bool) {
        byte[] byt = new byte[bool.length];
        int i = 0;
        while (i < bool.length) {
            byt[i] = bool[i] ? 84 : 70;
            ++i;
        }
        return byt;
    }

    static boolean[] byteToBoolean(byte[] byt) {
        boolean[] bool = new boolean[byt.length];
        int i = 0;
        while (i < byt.length) {
            bool[i] = byt[i] == 84;
            ++i;
        }
        return bool;
    }

    public static InputStream getURLStream(URL url, int level) throws IOException {
        if (level > 5) {
            throw new IOException("Two many levels of redirection in URL");
        }
        URLConnection conn = url.openConnection();
        Map<String, List<String>> hdrs = conn.getHeaderFields();
        String[] keys = hdrs.keySet().toArray(new String[0]);
        int i = 0;
        while (i < keys.length) {
            String val;
            String key = keys[i];
            if (key != null && key.toLowerCase().equals("location") && (val = hdrs.get(key).get(0)) != null && (val = val.trim()).length() > 0) {
                return FitsUtil.getURLStream(new URL(val), level + 1);
            }
            ++i;
        }
        return conn.getInputStream();
    }

    public static void pad(ArrayDataOutput stream, long size) throws FitsException {
        FitsUtil.pad(stream, size, (byte)0);
    }

    public static void pad(ArrayDataOutput stream, long size, byte fill) throws FitsException {
        int len = FitsUtil.padding(size);
        if (len > 0) {
            byte[] buf = new byte[len];
            int i = 0;
            while (i < len) {
                buf[i] = fill;
                ++i;
            }
            try {
                stream.write(buf);
                stream.flush();
            }
            catch (Exception e2) {
                throw new FitsException("Unable to write padding", e2);
            }
        }
    }

    static InputStream bunzipper(final InputStream pb) throws FitsException {
        Thread t;
        OutputStream out;
        Process p;
        String cmd = System.getenv("BZIP_DECOMPRESSOR");
        if (cmd.indexOf(" -") < 0) {
            cmd = String.valueOf(cmd) + " -";
        }
        String[] flds = cmd.split(" +");
        try {
            p = new ProcessBuilder(flds).start();
            out = p.getOutputStream();
            t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        int len;
                        byte[] buf = new byte[16384];
                        long total = 0L;
                        while ((len = pb.read(buf)) > 0) {
                            try {
                                out.write(buf, 0, len);
                            }
                            catch (Exception e2) {
                                break;
                            }
                            total += (long)len;
                        }
                        pb.close();
                        out.close();
                    }
                    catch (IOException e3) {
                        throw new Error("Error reading BZIP compression using: " + System.getenv("BZIP_DECOMPRESSOR"), e3);
                    }
                }
            });
        }
        catch (Exception e2) {
            throw new FitsException("Error initiating BZIP decompression: " + e2);
        }
        t.start();
        return new CloseIS(p.getInputStream(), pb, out);
    }
}

