/*
 * Decompiled with CFR 0.152.
 */
package jal.Object;

import jal.Object.BinaryPredicate;
import jal.Object.Modification;
import jal.Object.Range;

public final class Sorting {
    private static final int partitionCutoff = 13;
    private static final int qsort_stacksize = 56;
    private static final int stableSortCutoff = 9;

    public static void sort(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n >= 13) {
            Sorting.qsortLoop(objectArray, n, n2, binaryPredicate);
        }
        Sorting.insertion_sort(objectArray, n, n2, binaryPredicate);
    }

    public static void insertion_sort(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int n3 = n;
        while (++n3 < n2) {
            Object object = objectArray[n3];
            int n4 = n3;
            Object object2 = objectArray[n4 - 1];
            while (binaryPredicate.apply(object, object2)) {
                objectArray[n4] = object2;
                if (n == n4 - 1) {
                    --n4;
                    break;
                }
                object2 = objectArray[--n4 - 1];
            }
            objectArray[n4] = object;
        }
    }

    private static int quickPartition(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        Object object = objectArray[n];
        Object object2 = objectArray[n2 - 1];
        Object object3 = objectArray[n + (n2 - n) / 2];
        if (binaryPredicate.apply(object3, object)) {
            if (binaryPredicate.apply(object, object2)) {
                object3 = object;
            } else if (binaryPredicate.apply(object3, object2)) {
                object3 = object2;
            }
        } else if (binaryPredicate.apply(object2, object)) {
            object3 = object;
        } else if (binaryPredicate.apply(object2, object3)) {
            object3 = object2;
        }
        --n;
        while (true) {
            if (binaryPredicate.apply(objectArray[++n], object3)) {
                continue;
            }
            while (binaryPredicate.apply(object3, objectArray[--n2])) {
            }
            if (n >= n2) {
                return n;
            }
            Object object4 = objectArray[n];
            objectArray[n] = objectArray[n2];
            objectArray[n2] = object4;
        }
    }

    private static void qsortLoop(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        int[] nArray = new int[56];
        int n3 = 0;
        while (true) {
            int n4;
            if (n2 - (n4 = Sorting.quickPartition(objectArray, n, n2, binaryPredicate)) < 13) {
                if (n4 - n < 13) {
                    if (n3 == 0) {
                        return;
                    }
                    n2 = nArray[--n3];
                    n = nArray[--n3];
                    continue;
                }
                n2 = n4;
                continue;
            }
            if (n4 - n < 13) {
                n = n4;
                continue;
            }
            if (n2 - n4 > n4 - n) {
                nArray[n3++] = n4;
                nArray[n3++] = n2;
                n2 = n4;
                continue;
            }
            nArray[n3++] = n;
            nArray[n3++] = n4;
            n = n4;
        }
    }

    public static void stable_sort(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 9) {
            Sorting.insertion_sort(objectArray, n, n2, binaryPredicate);
        } else {
            int n3 = n + (n2 - n) / 2;
            Sorting.stable_sort(objectArray, n, n3, binaryPredicate);
            Sorting.stable_sort(objectArray, n3, n2, binaryPredicate);
            Sorting.inplace_merge(objectArray, n, n3, n2, binaryPredicate);
        }
    }

    public static void partial_sort(Object[] objectArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Sorting.make_heap(objectArray, n, n2, binaryPredicate);
        int n4 = n2;
        while (n4 < n3) {
            if (binaryPredicate.apply(objectArray[n4], objectArray[n])) {
                Object object = objectArray[n4];
                objectArray[n4] = objectArray[n];
                objectArray[n] = object;
                Sorting.adjust_heap(objectArray, n, n, n2, binaryPredicate);
            }
            ++n4;
        }
        Sorting.sort_heap(objectArray, n, n2, binaryPredicate);
    }

    public static int partial_sort_copy(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        if (n3 == n4) {
            return n4;
        }
        int n5 = Math.min(n2 - n, n4 - n3);
        Modification.copy(objectArray, objectArray2, n, n + n5, n3);
        n4 = n3 + n5;
        Sorting.make_heap(objectArray2, n3, n4, binaryPredicate);
        n += n5;
        while (n < n2) {
            if (binaryPredicate.apply(objectArray[n], objectArray2[n3])) {
                objectArray2[n3] = objectArray[n];
                Sorting.adjust_heap(objectArray2, n3, n3, n4, binaryPredicate);
            }
            ++n;
        }
        Sorting.sort_heap(objectArray2, n3, n4, binaryPredicate);
        return n4;
    }

    public static void nth_element(Object[] objectArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        while (n3 - n > 3) {
            int n4 = Sorting.quickPartition(objectArray, n, n3, binaryPredicate);
            if (n4 <= n2) {
                n = n4;
                continue;
            }
            n3 = n4;
        }
        Sorting.insertion_sort(objectArray, n, n3, binaryPredicate);
    }

    public static int lower_bound(Object[] objectArray, int n, int n2, Object object, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(objectArray[n5], object)) {
                n = n5 + 1;
                n3 -= n4 + 1;
                continue;
            }
            n3 = n4;
        }
        return n;
    }

    public static int upper_bound(Object[] objectArray, int n, int n2, Object object, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(object, objectArray[n5])) {
                n3 = n4;
                continue;
            }
            n = n5 + 1;
            n3 -= n4 + 1;
        }
        return n;
    }

    public static Range equal_range(Object[] objectArray, int n, int n2, Object object, BinaryPredicate binaryPredicate) {
        int n3 = n2 - n;
        while (n3 > 0) {
            int n4 = n3 / 2;
            int n5 = n + n4;
            if (binaryPredicate.apply(objectArray[n5], object)) {
                n = n5 + 1;
                n3 = n3 - n4 + 1;
                continue;
            }
            if (binaryPredicate.apply(object, objectArray[n5])) {
                n3 = n4;
                continue;
            }
            int n6 = Sorting.lower_bound(objectArray, n, n5, object, binaryPredicate);
            int n7 = Sorting.upper_bound(objectArray, n5 + 1, n + n3, object, binaryPredicate);
            return new Range(objectArray, n6, n7);
        }
        return new Range(objectArray, n, n);
    }

    public static boolean binary_search(Object[] objectArray, int n, int n2, Object object, BinaryPredicate binaryPredicate) {
        int n3 = Sorting.lower_bound(objectArray, n, n2, object, binaryPredicate);
        return n3 < n2 && !binaryPredicate.apply(object, objectArray[n3]);
    }

    public static int merge(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            objectArray3[n5++] = binaryPredicate.apply(objectArray2[n3], objectArray[n]) ? objectArray2[n3++] : objectArray[n++];
        }
        Modification.copy(objectArray, objectArray3, n, n2, n5);
        Modification.copy(objectArray2, objectArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void inplace_merge(Object[] objectArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        int n4;
        int n5;
        if (n >= n2 || n2 >= n3) {
            return;
        }
        if (n3 - n == 2) {
            if (binaryPredicate.apply(objectArray[n2], objectArray[n])) {
                Object object = objectArray[n];
                objectArray[n] = objectArray[n2];
                objectArray[n2] = object;
            }
            return;
        }
        if (n2 - n > n3 - n2) {
            n5 = n + (n2 - n) / 2;
            n4 = Sorting.lower_bound(objectArray, n2, n3, objectArray[n5], binaryPredicate);
        } else {
            n4 = n2 + (n3 - n2) / 2;
            n5 = Sorting.upper_bound(objectArray, n, n2, objectArray[n4], binaryPredicate);
        }
        Modification.rotate(objectArray, n5, n2, n4);
        n2 = n5 + (n4 - n2);
        Sorting.inplace_merge(objectArray, n, n5, n2, binaryPredicate);
        Sorting.inplace_merge(objectArray, n2, n4, n3, binaryPredicate);
    }

    public static boolean includes(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(objectArray2[n3], objectArray[n])) {
                return false;
            }
            if (binaryPredicate.apply(objectArray[n], objectArray2[n3])) {
                ++n;
                continue;
            }
            ++n;
            ++n3;
        }
        return n3 == n4;
    }

    public static int set_union(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(objectArray[n], objectArray2[n3])) {
                objectArray3[n5++] = objectArray[n++];
                continue;
            }
            if (binaryPredicate.apply(objectArray2[n3], objectArray[n])) {
                objectArray3[n5++] = objectArray2[n3++];
                continue;
            }
            objectArray3[n5++] = objectArray[n++];
            ++n3;
        }
        Modification.copy(objectArray, objectArray3, n, n2, n5);
        Modification.copy(objectArray2, objectArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static int set_intersection(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(objectArray[n], objectArray2[n3])) {
                ++n;
                continue;
            }
            if (binaryPredicate.apply(objectArray2[n3], objectArray[n])) {
                ++n3;
                continue;
            }
            objectArray3[n5++] = objectArray[n++];
            ++n3;
        }
        return n5;
    }

    public static int set_difference(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(objectArray[n], objectArray2[n3])) {
                objectArray3[n5++] = objectArray[n++];
                continue;
            }
            if (binaryPredicate.apply(objectArray2[n3], objectArray[n])) {
                ++n3;
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(objectArray, objectArray3, n, n2, n5);
        return n5 + (n2 - n);
    }

    public static int set_symmetric_difference(Object[] objectArray, Object[] objectArray2, Object[] objectArray3, int n, int n2, int n3, int n4, int n5, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(objectArray[n], objectArray2[n3])) {
                objectArray3[n5++] = objectArray[n++];
                continue;
            }
            if (binaryPredicate.apply(objectArray2[n3], objectArray[n])) {
                objectArray3[n5++] = objectArray2[n3++];
                continue;
            }
            ++n;
            ++n3;
        }
        Modification.copy(objectArray, objectArray3, n, n2, n5);
        Modification.copy(objectArray2, objectArray3, n3, n4, n5);
        return n5 + (n2 - n) + (n4 - n3);
    }

    public static void push_heap(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        Object object = objectArray[--n2];
        int n3 = n + (n2 - n - 1) / 2;
        while (n2 > n && binaryPredicate.apply(objectArray[n3], object)) {
            objectArray[n2] = objectArray[n3];
            n2 = n3;
            n3 = n + (n2 - n - 1) / 2;
        }
        objectArray[n2] = object;
    }

    private static void adjust_heap(Object[] objectArray, int n, int n2, int n3, BinaryPredicate binaryPredicate) {
        Object object = objectArray[n2];
        int n4 = n3 - n;
        int n5 = n2 - n;
        int n6 = 2 * n5 + 2;
        while (n6 < n4) {
            if (binaryPredicate.apply(objectArray[n + n6], objectArray[n + (n6 - 1)])) {
                --n6;
            }
            objectArray[n + n5] = objectArray[n + n6];
            n5 = n6++;
            n6 *= 2;
        }
        if (n6-- == n4) {
            objectArray[n + n5] = objectArray[n + n6];
            n5 = n6;
        }
        int n7 = (n5 - 1) / 2;
        int n8 = n2 - n;
        while (n5 != n8 && binaryPredicate.apply(objectArray[n + n7], object)) {
            objectArray[n + n5] = objectArray[n + n7];
            n5 = n7;
            n7 = (n5 - 1) / 2;
        }
        objectArray[n + n5] = object;
    }

    public static void pop_heap(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        Object object = objectArray[--n2];
        objectArray[n2] = objectArray[n];
        objectArray[n] = object;
        Sorting.adjust_heap(objectArray, n, n, n2, binaryPredicate);
    }

    public static void make_heap(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return;
        }
        int n3 = (n2 - n - 2) / 2;
        do {
            Sorting.adjust_heap(objectArray, n, n + n3, n2, binaryPredicate);
        } while (n3-- != 0);
    }

    public static void sort_heap(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        while (n2 - n > 1) {
            Object object = objectArray[--n2];
            objectArray[n2] = objectArray[n];
            objectArray[n] = object;
            Sorting.adjust_heap(objectArray, n, n, n2, binaryPredicate);
        }
    }

    public static int max_element(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(objectArray[n3], objectArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    public static int min_element(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n >= n2) {
            return n2;
        }
        int n3 = n;
        while (++n < n2) {
            if (!binaryPredicate.apply(objectArray[n], objectArray[n3])) continue;
            n3 = n;
        }
        return n3;
    }

    public static boolean lexicographical_compare(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, int n4, BinaryPredicate binaryPredicate) {
        while (n < n2 && n3 < n4) {
            if (binaryPredicate.apply(objectArray[n], objectArray2[n3])) {
                return true;
            }
            if (!binaryPredicate.apply(objectArray2[n3++], objectArray[n++])) continue;
            return false;
        }
        return n == n2 && n3 != n4;
    }

    public static boolean next_permutation(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(objectArray[--n3], objectArray[n4])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(objectArray[n3], objectArray[--n5])) {
            }
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n5];
            objectArray[n5] = object;
            Modification.reverse(objectArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(objectArray, n, n2);
        return false;
    }

    public static boolean prev_permutation(Object[] objectArray, int n, int n2, BinaryPredicate binaryPredicate) {
        if (n2 - n < 2) {
            return false;
        }
        int n3 = n2 - 1;
        do {
            int n4;
            if (!binaryPredicate.apply(objectArray[n4], objectArray[--n3])) continue;
            int n5 = n2;
            while (!binaryPredicate.apply(objectArray[--n5], objectArray[n3])) {
            }
            Object object = objectArray[n3];
            objectArray[n3] = objectArray[n5];
            objectArray[n5] = object;
            Modification.reverse(objectArray, n4, n2);
            return true;
        } while (n3 != n);
        Modification.reverse(objectArray, n, n2);
        return false;
    }

    private Sorting() {
    }
}

