/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent.misc;

import edu.oswego.cs.dl.util.concurrent.Callable;
import edu.oswego.cs.dl.util.concurrent.FutureResult;
import edu.oswego.cs.dl.util.concurrent.ThreadFactory;
import edu.oswego.cs.dl.util.concurrent.ThreadFactoryUser;
import edu.oswego.cs.dl.util.concurrent.TimedCallable;
import edu.oswego.cs.dl.util.concurrent.TimeoutException;
import java.lang.reflect.InvocationTargetException;
import javax.swing.SwingUtilities;

public abstract class SwingWorker
extends ThreadFactoryUser
implements Runnable {
    private static final ThreadFactory FACTORY = new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setPriority(2);
            return thread;
        }
    };
    private final FutureResult result = new FutureResult();
    private final long timeout;
    private Thread thread;

    public SwingWorker() {
        this(FACTORY, 0L);
    }

    public SwingWorker(long l) {
        this(FACTORY, l);
    }

    protected SwingWorker(ThreadFactory threadFactory, long l) {
        this.setThreadFactory(threadFactory);
        if (l < 0L) {
            throw new IllegalArgumentException("timeout=" + l);
        }
        this.timeout = l;
    }

    protected abstract Object construct() throws Exception;

    protected void finished() {
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void run() {
        Callable callable = new Callable(){

            public Object call() throws Exception {
                return SwingWorker.this.construct();
            }
        };
        Runnable runnable = new Runnable(){

            public void run() {
                SwingWorker.this.finished();
            }
        };
        long l = this.getTimeout();
        if (l != 0L) {
            TimedCallable timedCallable = new TimedCallable(callable, l);
            timedCallable.setThreadFactory(this.getThreadFactory());
            callable = timedCallable;
        }
        this.result.setter(callable).run();
        SwingUtilities.invokeLater(runnable);
    }

    public synchronized void start() {
        if (this.thread == null) {
            this.thread = this.getThreadFactory().newThread(this);
        }
        this.thread.start();
    }

    public synchronized void interrupt() {
        if (this.thread != null) {
            try {
                this.thread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.result.setException(new InterruptedException());
    }

    public Object get() throws InterruptedException, InvocationTargetException {
        return this.result.get();
    }

    public Object timedGet(long l) throws TimeoutException, InterruptedException, InvocationTargetException {
        return this.result.timedGet(l);
    }

    public InvocationTargetException getException() {
        return this.result.getException();
    }

    public boolean isReady() {
        return this.result.isReady();
    }
}

