/*
 * Decompiled with CFR 0.152.
 */
package edu.oswego.cs.dl.util.concurrent;

import java.util.Comparator;

public class Heap {
    protected Object[] nodes_;
    protected int count_ = 0;
    protected final Comparator cmp_;

    public Heap(int n, Comparator comparator) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.nodes_ = new Object[n];
        this.cmp_ = comparator;
    }

    public Heap(int n) {
        this(n, null);
    }

    protected int compare(Object object, Object object2) {
        if (this.cmp_ == null) {
            return ((Comparable)object).compareTo(object2);
        }
        return this.cmp_.compare(object, object2);
    }

    protected final int parent(int n) {
        return (n - 1) / 2;
    }

    protected final int left(int n) {
        return 2 * n + 1;
    }

    protected final int right(int n) {
        return 2 * (n + 1);
    }

    public synchronized void insert(Object object) {
        int n;
        if (this.count_ >= this.nodes_.length) {
            n = 3 * this.nodes_.length / 2 + 1;
            Object[] objectArray = new Object[n];
            System.arraycopy(this.nodes_, 0, objectArray, 0, this.nodes_.length);
            this.nodes_ = objectArray;
        }
        n = this.count_++;
        while (n > 0) {
            int n2 = this.parent(n);
            if (this.compare(object, this.nodes_[n2]) >= 0) break;
            this.nodes_[n] = this.nodes_[n2];
            n = n2;
        }
        this.nodes_[n] = object;
    }

    public synchronized Object extract() {
        int n;
        if (this.count_ < 1) {
            return null;
        }
        int n2 = 0;
        Object object = this.nodes_[n2];
        --this.count_;
        Object object2 = this.nodes_[this.count_];
        while ((n = this.left(n2)) < this.count_) {
            int n3;
            int n4 = this.right(n2);
            int n5 = n3 = n4 >= this.count_ || this.compare(this.nodes_[n], this.nodes_[n4]) < 0 ? n : n4;
            if (this.compare(object2, this.nodes_[n3]) <= 0) break;
            this.nodes_[n2] = this.nodes_[n3];
            n2 = n3;
        }
        this.nodes_[n2] = object2;
        return object;
    }

    public synchronized Object peek() {
        if (this.count_ > 0) {
            return this.nodes_[0];
        }
        return null;
    }

    public synchronized int size() {
        return this.count_;
    }

    public synchronized void clear() {
        this.count_ = 0;
    }
}

