/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.stat.quantile;

import cern.colt.function.DoubleProcedure;
import cern.jet.stat.quantile.BufferSet;
import cern.jet.stat.quantile.DoubleBuffer;

class DoubleBufferSet
extends BufferSet {
    protected DoubleBuffer[] buffers;
    private boolean nextTriggerCalculationState;

    public DoubleBufferSet(int n, int n2) {
        this.buffers = new DoubleBuffer[n];
        this.clear(n2);
    }

    public DoubleBuffer _getFirstEmptyBuffer() {
        DoubleBuffer doubleBuffer = null;
        int n = this.buffers.length;
        while (--n >= 0) {
            if (!this.buffers[n].isEmpty()) continue;
            if (this.buffers[n].isAllocated()) {
                return this.buffers[n];
            }
            doubleBuffer = this.buffers[n];
        }
        return doubleBuffer;
    }

    public DoubleBuffer[] _getFullOrPartialBuffers() {
        int n = 0;
        int n2 = this.buffers.length;
        while (--n2 >= 0) {
            if (this.buffers[n2].isEmpty()) continue;
            ++n;
        }
        DoubleBuffer[] doubleBufferArray = new DoubleBuffer[n];
        int n3 = 0;
        int n4 = this.buffers.length;
        while (--n4 >= 0) {
            if (this.buffers[n4].isEmpty()) continue;
            doubleBufferArray[n3++] = this.buffers[n4];
        }
        return doubleBufferArray;
    }

    public DoubleBuffer[] _getFullOrPartialBuffersWithLevel(int n) {
        int n2 = 0;
        int n3 = this.buffers.length;
        while (--n3 >= 0) {
            if (this.buffers[n3].isEmpty() || this.buffers[n3].level() != n) continue;
            ++n2;
        }
        DoubleBuffer[] doubleBufferArray = new DoubleBuffer[n2];
        int n4 = 0;
        int n5 = this.buffers.length;
        while (--n5 >= 0) {
            if (this.buffers[n5].isEmpty() || this.buffers[n5].level() != n) continue;
            doubleBufferArray[n4++] = this.buffers[n5];
        }
        return doubleBufferArray;
    }

    public int _getMinLevelOfFullOrPartialBuffers() {
        int n = this.b();
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        while (n3 < n) {
            DoubleBuffer doubleBuffer = this.buffers[n3];
            if (!doubleBuffer.isEmpty() && doubleBuffer.level() < n2) {
                n2 = doubleBuffer.level();
            }
            ++n3;
        }
        return n2;
    }

    public int _getNumberOfEmptyBuffers() {
        int n = 0;
        int n2 = this.buffers.length;
        while (--n2 >= 0) {
            if (!this.buffers[n2].isEmpty()) continue;
            ++n;
        }
        return n;
    }

    public DoubleBuffer _getPartialBuffer() {
        int n = this.buffers.length;
        while (--n >= 0) {
            if (!this.buffers[n].isPartial()) continue;
            return this.buffers[n];
        }
        return null;
    }

    public int b() {
        return this.buffers.length;
    }

    public void clear() {
        this.clear(this.k());
    }

    protected void clear(int n) {
        int n2 = this.b();
        while (--n2 >= 0) {
            this.buffers[n2] = new DoubleBuffer(n);
        }
        this.nextTriggerCalculationState = true;
    }

    public Object clone() {
        DoubleBufferSet doubleBufferSet = (DoubleBufferSet)super.clone();
        doubleBufferSet.buffers = (DoubleBuffer[])doubleBufferSet.buffers.clone();
        int n = this.buffers.length;
        while (--n >= 0) {
            doubleBufferSet.buffers[n] = (DoubleBuffer)doubleBufferSet.buffers[n].clone();
        }
        return doubleBufferSet;
    }

    public DoubleBuffer collapse(DoubleBuffer[] doubleBufferArray) {
        int n = 0;
        int n2 = 0;
        while (n2 < doubleBufferArray.length) {
            n += doubleBufferArray[n2].weight();
            ++n2;
        }
        int n3 = this.k();
        long[] lArray = new long[n3];
        int n4 = 0;
        while (n4 < n3) {
            lArray[n4] = this.nextTriggerPosition(n4, n);
            ++n4;
        }
        double[] dArray = this.getValuesAtPositions(doubleBufferArray, lArray);
        int n5 = 1;
        while (n5 < doubleBufferArray.length) {
            doubleBufferArray[n5].clear();
            ++n5;
        }
        DoubleBuffer doubleBuffer = doubleBufferArray[0];
        doubleBuffer.values.elements(dArray);
        doubleBuffer.weight(n);
        return doubleBuffer;
    }

    public boolean contains(double d2) {
        int n = this.buffers.length;
        while (--n >= 0) {
            if (this.buffers[n].isEmpty() || !this.buffers[n].contains(d2)) continue;
            return true;
        }
        return false;
    }

    public boolean forEach(DoubleProcedure doubleProcedure) {
        int n = this.buffers.length;
        while (--n >= 0) {
            int n2 = this.buffers[n].weight();
            while (--n2 >= 0) {
                if (this.buffers[n].values.forEach(doubleProcedure)) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    protected double[] getValuesAtPositions(DoubleBuffer[] var1_1, long[] var2_2) {
        var3_3 = var1_1.length;
        while (--var3_3 >= 0) {
            var1_1[var3_3].sort();
        }
        var4_4 = new int[var1_1.length];
        var5_5 = new double[var1_1.length][];
        var6_6 = 0;
        var7_7 = var1_1.length;
        while (--var7_7 >= 0) {
            var4_4[var7_7] = var1_1[var7_7].size();
            var5_5[var7_7] = var1_1[var7_7].values.elements();
            var6_6 += var4_4[var7_7];
        }
        var8_8 = var1_1.length;
        var9_9 = var2_2.length;
        var10_10 = 0;
        var11_11 = new int[var1_1.length];
        var12_12 = 0L;
        var14_13 = var2_2[var10_10];
        var16_14 = new double[var9_9];
        if (var6_6 != 0) ** GOTO lbl45
        var17_15 = 0;
        while (var17_15 < var2_2.length) {
            var16_14[var17_15] = NaN;
            ++var17_15;
        }
        return var16_14;
lbl-1000:
        // 1 sources

        {
            var17_16 = Infinity;
            var19_17 = -1;
            var20_18 = var8_8;
            while (--var20_18 >= 0) {
                if (var11_11[var20_18] >= var4_4[var20_18] || !((var21_20 = var5_5[var20_18][var11_11[var20_18]]) <= var17_16)) continue;
                var17_16 = var21_20;
                var19_17 = var20_18;
            }
            var21_19 = var1_1[var19_17];
            var12_12 += (long)var21_19.weight();
            while (var12_12 > var14_13 && var10_10 < var9_9) {
                var16_14[var10_10++] = var17_16;
                if (var10_10 >= var9_9) continue;
                var14_13 = var2_2[var10_10];
            }
            v0 = var19_17;
            var11_11[v0] = var11_11[v0] + 1;
lbl45:
            // 2 sources

            ** while (var10_10 < var9_9)
        }
lbl46:
        // 1 sources

        return var16_14;
    }

    public int k() {
        return this.buffers[0].k;
    }

    public long memory() {
        long l = 0L;
        int n = this.buffers.length;
        while (--n >= 0) {
            l += (long)this.buffers[n].memory();
        }
        return l;
    }

    protected long nextTriggerPosition(int n, long l) {
        long l2 = l % 2L != 0L ? (long)n * l + (l + 1L) / 2L : (this.nextTriggerCalculationState ? (long)n * l + l / 2L : (long)n * l + (l + 2L) / 2L);
        return l2;
    }

    public double phi(double d2) {
        double d3 = 0.0;
        int n = this.buffers.length;
        while (--n >= 0) {
            if (this.buffers[n].isEmpty()) continue;
            d3 += (double)this.buffers[n].weight * this.buffers[n].rank(d2);
        }
        return d3 / (double)this.totalSize();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.b()) {
            if (!this.buffers[n].isEmpty()) {
                stringBuffer.append("buffer#" + n + " = ");
                stringBuffer.append(this.buffers[n].toString() + "\n");
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    public long totalSize() {
        DoubleBuffer[] doubleBufferArray = this._getFullOrPartialBuffers();
        long l = 0L;
        int n = doubleBufferArray.length;
        while (--n >= 0) {
            l += (long)(doubleBufferArray[n].size() * doubleBufferArray[n].weight());
        }
        return l;
    }
}

