/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.random.AbstractContinousDistribution;
import cern.jet.random.AbstractDistribution;
import cern.jet.stat.Probability;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class Normal
extends AbstractContinousDistribution {
    protected double mean;
    protected double variance;
    protected double standardDeviation;
    protected double cache;
    protected boolean cacheFilled;
    protected double SQRT_INV;
    protected static Normal shared = new Normal(0.0, 1.0, AbstractDistribution.makeDefaultGenerator());

    public Normal(double d2, double d3, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(d2, d3);
    }

    public double cdf(double d2) {
        return Probability.normal(this.mean, this.variance, d2);
    }

    public double nextDouble() {
        return this.nextDouble(this.mean, this.standardDeviation);
    }

    public double nextDouble(double d2, double d3) {
        double d4;
        double d5;
        double d6;
        if (this.cacheFilled) {
            this.cacheFilled = false;
            return this.cache;
        }
        while ((d6 = (d5 = 2.0 * this.randomGenerator.raw() - 1.0) * d5 + (d4 = 2.0 * this.randomGenerator.raw() - 1.0) * d4) >= 1.0) {
        }
        double d7 = Math.sqrt(-2.0 * Math.log(d6) / d6);
        this.cache = d2 + d3 * d5 * d7;
        this.cacheFilled = true;
        return d2 + d3 * d4 * d7;
    }

    public double pdf(double d2) {
        double d3 = d2 - this.mean;
        return this.SQRT_INV * Math.exp(-(d3 * d3) / (2.0 * this.variance));
    }

    protected void setRandomGenerator(RandomElement randomElement) {
        super.setRandomGenerator(randomElement);
        this.cacheFilled = false;
    }

    public void setState(double d2, double d3) {
        if (d2 != this.mean || d3 != this.standardDeviation) {
            this.mean = d2;
            this.standardDeviation = d3;
            this.variance = d3 * d3;
            this.cacheFilled = false;
            this.SQRT_INV = 1.0 / Math.sqrt(Math.PI * 2 * this.variance);
        }
    }

    public static double staticNextDouble(double d2, double d3) {
        Normal normal = shared;
        synchronized (normal) {
            double d4 = shared.nextDouble(d2, d3);
            return d4;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.mean + "," + this.standardDeviation + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        Normal normal = shared;
        synchronized (normal) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

