/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.support.xml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLXML;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.jdbc.support.xml.SqlXmlHandler;
import org.springframework.jdbc.support.xml.SqlXmlValue;
import org.springframework.jdbc.support.xml.XmlBinaryStreamProvider;
import org.springframework.jdbc.support.xml.XmlCharacterStreamProvider;
import org.springframework.jdbc.support.xml.XmlResultProvider;
import org.w3c.dom.Document;

public class Jdbc4SqlXmlHandler
implements SqlXmlHandler {
    public String getXmlAsString(ResultSet rs, String columnName) throws SQLException {
        return rs.getSQLXML(columnName).getString();
    }

    public String getXmlAsString(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getSQLXML(columnIndex).getString();
    }

    public InputStream getXmlAsBinaryStream(ResultSet rs, String columnName) throws SQLException {
        return rs.getSQLXML(columnName).getBinaryStream();
    }

    public InputStream getXmlAsBinaryStream(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getSQLXML(columnIndex).getBinaryStream();
    }

    public Reader getXmlAsCharacterStream(ResultSet rs, String columnName) throws SQLException {
        return rs.getSQLXML(columnName).getCharacterStream();
    }

    public Reader getXmlAsCharacterStream(ResultSet rs, int columnIndex) throws SQLException {
        return rs.getSQLXML(columnIndex).getCharacterStream();
    }

    public Source getXmlAsSource(ResultSet rs, String columnName, Class sourceClass) throws SQLException {
        return rs.getSQLXML(columnName).getSource(sourceClass != null ? sourceClass : DOMSource.class);
    }

    public Source getXmlAsSource(ResultSet rs, int columnIndex, Class sourceClass) throws SQLException {
        return rs.getSQLXML(columnIndex).getSource(sourceClass != null ? sourceClass : DOMSource.class);
    }

    public SqlXmlValue newSqlXmlValue(final String value) {
        return new AbstractJdbc4SqlXmlValue(){

            protected void provideXml(SQLXML xmlObject) throws SQLException, IOException {
                xmlObject.setString(value);
            }
        };
    }

    public SqlXmlValue newSqlXmlValue(final XmlBinaryStreamProvider provider) {
        return new AbstractJdbc4SqlXmlValue(){

            protected void provideXml(SQLXML xmlObject) throws SQLException, IOException {
                provider.provideXml(xmlObject.setBinaryStream());
            }
        };
    }

    public SqlXmlValue newSqlXmlValue(final XmlCharacterStreamProvider provider) {
        return new AbstractJdbc4SqlXmlValue(){

            protected void provideXml(SQLXML xmlObject) throws SQLException, IOException {
                provider.provideXml(xmlObject.setCharacterStream());
            }
        };
    }

    public SqlXmlValue newSqlXmlValue(final Class resultClass, final XmlResultProvider provider) {
        return new AbstractJdbc4SqlXmlValue(){

            protected void provideXml(SQLXML xmlObject) throws SQLException, IOException {
                provider.provideXml((Result)xmlObject.setResult(resultClass));
            }
        };
    }

    public SqlXmlValue newSqlXmlValue(final Document document) {
        return new AbstractJdbc4SqlXmlValue(){

            protected void provideXml(SQLXML xmlObject) throws SQLException, IOException {
                xmlObject.setResult(DOMResult.class).setNode(document);
            }
        };
    }

    private static abstract class AbstractJdbc4SqlXmlValue
    implements SqlXmlValue {
        private SQLXML xmlObject;

        private AbstractJdbc4SqlXmlValue() {
        }

        public void setValue(PreparedStatement ps, int paramIndex) throws SQLException {
            this.xmlObject = ps.getConnection().createSQLXML();
            try {
                this.provideXml(this.xmlObject);
            }
            catch (IOException ex) {
                throw new DataAccessResourceFailureException("Failure encountered while providing XML", ex);
            }
            ps.setSQLXML(paramIndex, this.xmlObject);
        }

        public void cleanup() {
            try {
                this.xmlObject.free();
            }
            catch (SQLException ex) {
                throw new DataAccessResourceFailureException("Could not free SQLXML object", ex);
            }
        }

        protected abstract void provideXml(SQLXML var1) throws SQLException, IOException;
    }
}

