/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.keyword;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import org.eso.dfs.io.UpgradingObjectInputStream;
import org.eso.gasgano.keyword.KeywordExpression;
import org.eso.gasgano.properties.PropertyDB;

public class ExpressionTable
extends AbstractTableModel
implements Serializable {
    static final long serialVersionUID = -3380960670794527145L;
    private Vector expressions = new Vector();
    private static String[] columnNames = new String[]{"Expression"};
    private String tablePath = null;

    public ExpressionTable(String filePath) {
        this.tablePath = filePath;
    }

    @Override
    public String getColumnName(int c2) {
        return columnNames[c2];
    }

    public String getTablePath() {
        return this.tablePath;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.expressions.size();
    }

    @Override
    public Object getValueAt(int r, int c2) {
        KeywordExpression expr = (KeywordExpression)this.expressions.elementAt(r);
        String rc = null;
        if (expr != null) {
            rc = expr.toString();
        }
        return rc;
    }

    public int getColumnWidth(int column) {
        return 30;
    }

    @Override
    public boolean isCellEditable(int r, int c2) {
        return false;
    }

    public Enumeration elements() {
        return this.expressions.elements();
    }

    public final synchronized boolean removeElement(Object o) {
        int idx = this.expressions.indexOf(o);
        if (idx >= 0) {
            this.expressions.removeElementAt(idx);
            this.fireTableRowsDeleted(idx, idx);
        }
        return idx >= 0;
    }

    public KeywordExpression elementAt(int index) {
        KeywordExpression rc = null;
        try {
            rc = (KeywordExpression)this.expressions.elementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            System.out.println(e2.toString());
        }
        return rc;
    }

    public final synchronized void removeElementAt(int index) {
        try {
            this.expressions.removeElementAt(index);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            System.out.println(e2.toString());
        }
        this.fireTableRowsDeleted(index, index);
    }

    public final synchronized boolean replaceElement(Object oldObj, Object newObj) {
        boolean rc;
        int idx = this.expressions.indexOf(oldObj);
        if (idx >= 0) {
            this.expressions.set(idx, newObj);
            rc = true;
            this.fireTableRowsUpdated(idx, idx);
        } else {
            rc = false;
        }
        return rc;
    }

    public final synchronized void addElement(Object obj) {
        this.expressions.addElement(obj);
        this.fireTableRowsInserted(this.expressions.size() - 1, this.expressions.size() - 1);
    }

    public final synchronized void setElementAt(Object obj, int index) {
        try {
            this.expressions.setElementAt(obj, index);
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            System.out.println(e2.toString());
        }
        this.fireTableRowsUpdated(index, index);
    }

    public static ExpressionTable readFile(String path) {
        ExpressionTable rc = new ExpressionTable(path);
        try {
            UpgradingObjectInputStream in = new UpgradingObjectInputStream(new FileInputStream(path), "org.eso.gasgano.", "org.eso.gasgano.keyword.");
            rc.expressions = (Vector)in.readObject();
        }
        catch (ClassNotFoundException e2) {
            if (PropertyDB.getInstance().isDebug(7)) {
                System.out.println("Error reading file: " + path + " " + e2.toString());
            }
            rc = null;
        }
        catch (IOException e3) {
            if (PropertyDB.getInstance().isDebug(7)) {
                System.out.println("Error reading file: " + path + " " + e3.toString());
            }
            rc = null;
        }
        return rc;
    }

    public void writeFile() throws IOException {
        ObjectOutputStream out = new ObjectOutputStream(new FileOutputStream(this.getTablePath()));
        out.writeObject(this.expressions);
        out.close();
    }
}

