/*
 * Decompiled with CFR 0.152.
 */
package org.eso.gasgano.datamodel.database;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import org.eso.gasgano.datamodel.DataModelChangeNotifier;
import org.eso.gasgano.datamodel.DataModelEvent;
import org.eso.gasgano.datamodel.FileDescription;
import org.eso.gasgano.datamodel.OBComponentFilter;
import org.eso.gasgano.datamodel.ProgramDescription;
import org.eso.gasgano.datamodel.database.DBContainer;
import org.eso.gasgano.datamodel.database.DBTranslation;
import org.eso.gasgano.datamodel.gui.DBOBComponent;
import org.eso.gasgano.keyword.Keyword;
import org.eso.gasgano.properties.GasProp;
import org.eso.gasgano.properties.PropertyDB;
import org.eso.gasgano.tools.PasswordSource;
import org.eso.gasgano.tools.SortedHashtable;

public class DBDataModel
extends DataModelChangeNotifier {
    private DBContainer programs = null;
    private DBContainer telescopes = null;
    private ProgramDescription progDescFactory = null;
    private OBComponentFilter fileFilter = null;
    private boolean visualDebug = false;
    private DBTranslation translationTable = null;
    private int filesCount = 0;
    private int initialChunkSize = 500;
    private String errorMessage = null;
    private PasswordSource passwordSource = null;
    private boolean dataModelUpdating = false;
    private int knownMaxRow;
    private boolean dataEndReached;
    private String serverURL = null;
    private String userName = null;
    private String passWord = null;
    private String permanentPassWord = null;
    private Properties connectionProperties = null;
    private Connection permanentConnection = null;
    private DBContainer dummyBox = new DBContainer('a', "Loading");
    private boolean extendedDatabase = false;
    private SortedHashtable instToTable = null;
    private SortedHashtable tableToMap = null;

    public DBDataModel() {
        this.programs = new DBContainer();
        this.telescopes = new DBContainer();
        this.translationTable = new DBTranslation();
        this.connectionProperties = new Properties();
    }

    private static boolean isDebug(int lvl) {
        return PropertyDB.getInstance().isDebug(lvl);
    }

    public boolean init() {
        this.programs.clear();
        this.telescopes.clear();
        this.instToTable = new SortedHashtable();
        this.tableToMap = new SortedHashtable();
        this.serverURL = PropertyDB.getInstance().getProperty("DBOBS_SERVER_URL");
        this.userName = PropertyDB.getInstance().getProperty("DBOBS_USERID");
        if (this.permanentPassWord == null) {
            this.passWord = this.passwordSource.popupPasswordPrompt(this.userName, "Enter Observations Database password", "DBOBS_REQUIRED");
        }
        this.connectionProperties.put("user", this.userName);
        this.connectionProperties.put("password", this.passWord);
        if (this.passWord.equals("")) {
            return false;
        }
        try {
            Class.forName("com.sybase.jdbc.SybDriver");
        }
        catch (ClassNotFoundException cnfe) {
            System.err.println("Could not load Sybase JDBC\n" + cnfe);
            return false;
        }
        if (DBDataModel.isDebug(8)) {
            System.out.println("Establishing connection......");
        }
        try {
            this.permanentConnection = DriverManager.getConnection(this.serverURL, this.connectionProperties);
        }
        catch (SQLException sqle) {
            System.err.println("Connection Failed" + sqle);
            return false;
        }
        if (DBDataModel.isDebug(8)) {
            System.out.println("Connection established");
        }
        this.determineExtensions();
        this.dataModelUpdating = true;
        if (!this.createProgramsForDefault()) {
            System.err.println(this.getErrorMessage());
            this.dataModelUpdating = false;
            return false;
        }
        if (DBDataModel.isDebug(8)) {
            System.err.println("DBDataModel.init completed");
        }
        this.dataModelUpdating = false;
        this.permanentPassWord = this.passWord;
        return true;
    }

    public void cleanup() {
        if (this.programs != null) {
            this.programs.clear();
        }
        if (this.telescopes != null) {
            this.telescopes.clear();
        }
        if (this.instToTable != null) {
            this.instToTable.clear();
        }
        if (this.tableToMap != null) {
            this.tableToMap.clear();
        }
        this.permanentPassWord = null;
        if (this.permanentConnection != null) {
            try {
                this.permanentConnection.close();
            }
            catch (SQLException sqle) {
                System.err.println("Could not close connection: " + sqle);
            }
        }
    }

    public boolean isUpdating() {
        return this.dataModelUpdating;
    }

    public int getFilesCount() {
        return this.filesCount;
    }

    public OBComponentFilter getFileFilter() {
        return this.fileFilter;
    }

    public void setPasswordSource(PasswordSource ps) {
        this.passwordSource = ps;
    }

    public void setDefaultFileDescription(FileDescription fd) {
        DBOBComponent.setDefaultFileDescription(fd);
    }

    public FileDescription getDefaultFileDescription() {
        return DBOBComponent.getDefaultFileDescription();
    }

    public DBContainer findProgram(String id) {
        return (DBContainer)this.programs.get(id);
    }

    public DBContainer findProgram(DBContainer progSet, String id) {
        return (DBContainer)progSet.get(id);
    }

    public int getProgramCount() {
        return this.programs.size();
    }

    public DBContainer getProgramAt(int i) {
        return (DBContainer)this.programs.elementAt(i);
    }

    public int getIndexOfProgram(DBContainer prog) {
        return this.programs.indexOf(prog);
    }

    public DBContainer getProgramSet() {
        return this.programs;
    }

    public DBContainer addProgram(String id) {
        return this.addProgram(this.programs, id);
    }

    private DBContainer addProgram(DBContainer progSet, String id) {
        DBContainer rc = this.findProgram(progSet, id);
        if (rc == null) {
            rc = new DBContainer('p', id);
            progSet.put(id, rc);
            rc.setFather(progSet);
            if (DBDataModel.isDebug(1)) {
                System.out.println("Added Prog: " + id + " to " + (progSet == this.programs ? "programs" : progSet.toString()));
            }
        }
        return rc;
    }

    public boolean createProgramsForDefault() {
        String instSelection;
        boolean rc = true;
        boolean allPeriods = false;
        boolean allInstruments = false;
        Statement stmt = null;
        char[] programPrefix = new char[]{' ', '1', '2'};
        int loopEnd = 3;
        String periodQuery = null;
        String instQuery = "";
        StringBuffer queryThree = new StringBuffer("select distinct prog_id, tel_id from observations..data_products ");
        String startPeriod = PropertyDB.getInstance().getProperty("DBOBS_PERIOD");
        if (startPeriod.equals("All")) {
            allPeriods = true;
            loopEnd = 1;
        }
        if ((instSelection = PropertyDB.getInstance().getProperty("DBOBS_INSTRUMENT")).equals("All")) {
            allInstruments = true;
        }
        if (!allInstruments) {
            instQuery = allPeriods ? "where ins_id = '" + instSelection + "'" : "and  ins_id = '" + instSelection + "'";
        }
        for (int z = 0; z < loopEnd; ++z) {
            if (z == 0) {
                periodQuery = "where prog_id like '" + startPeriod + "%'";
                if (allPeriods) {
                    periodQuery = "";
                }
            } else {
                periodQuery = "where prog_id like '" + programPrefix[z] + startPeriod + "%'";
            }
            try {
                stmt = this.permanentConnection.createStatement();
                ResultSet rs = null;
                if (DBDataModel.isDebug(8)) {
                    System.out.println(queryThree.toString() + periodQuery + instQuery);
                }
                boolean results = stmt.execute(queryThree.toString() + periodQuery + instQuery);
                do {
                    if (!results) continue;
                    rs = stmt.getResultSet();
                    int rowNum = 1;
                    while (rs.next()) {
                        String progIdString = rs.getString(1);
                        String telString = rs.getString(2);
                        if (progIdString != null) {
                            DBContainer prog = this.addProgram(progIdString);
                            if (DBDataModel.isDebug(8)) {
                                System.out.println(progIdString);
                            }
                            if (telString != null) {
                                DBContainer telescope = this.addTelescope(telString);
                                this.addProgram(telescope, progIdString);
                            }
                        }
                        ++rowNum;
                    }
                } while (results = stmt.getMoreResults());
                stmt.close();
                continue;
            }
            catch (SQLException sqe) {
                this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
                rc = false;
                this.connectionLost(sqe);
            }
        }
        return rc;
    }

    public void addSingleProgram(String program) {
        boolean debug = false;
        Statement stmt = null;
        DataModelEvent modelChangedEvent = null;
        StringBuffer queryOne = new StringBuffer("select distinct prog_id, tel_id from observations..data_products where prog_id = '");
        if (DBDataModel.isDebug(8)) {
            debug = true;
        }
        try {
            stmt = this.permanentConnection.createStatement();
            ResultSet rs = null;
            if (debug) {
                // empty if block
            }
            boolean results = stmt.execute(queryOne.toString() + program + "'");
            do {
                if (!results) continue;
                rs = stmt.getResultSet();
                int rowNum = 1;
                while (rs.next()) {
                    String progIdString = rs.getString(1);
                    String telString = rs.getString(2);
                    if (progIdString != null) {
                        DBContainer prog = this.addProgram(progIdString);
                        if (debug) {
                            System.out.println(progIdString);
                        }
                        if (telString != null) {
                            DBContainer telescope = this.addTelescope(telString);
                            this.addProgram(telescope, progIdString);
                        }
                        modelChangedEvent = new DataModelEvent(4, prog);
                        this.fireDataModelChangeEvent(modelChangedEvent);
                    }
                    ++rowNum;
                }
            } while (results = stmt.getMoreResults());
            stmt.close();
        }
        catch (SQLException sqe) {
            this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
            this.connectionLost(sqe);
        }
    }

    public DBContainer findObservation(DBContainer progSet, String id) {
        return (DBContainer)progSet.get(id);
    }

    private DBContainer addObservation(DBContainer progSet, String id, String name) {
        DBContainer rc = this.findObservation(progSet, id);
        if (rc == null) {
            rc = new DBContainer('o', id);
            rc.setDescription(id + " " + name);
            progSet.put(id, rc);
            rc.setFather(progSet);
            if (DBDataModel.isDebug(1)) {
                System.out.println("Added Observation: " + id + " to " + (progSet == this.programs ? "programs" : progSet.toString()));
            }
        }
        return rc;
    }

    public boolean createObservations(DBContainer prog) {
        boolean rc = true;
        boolean results = false;
        boolean results2 = false;
        String tmpQuery = null;
        ResultSet rs = null;
        String queryTwo = new String("select distinct ob_id, obs_name from observations..data_products where prog_id = '");
        Statement stmt = null;
        Object stmt2 = null;
        try {
            stmt = this.permanentConnection.createStatement();
            tmpQuery = queryTwo + prog + "' ";
            if (DBDataModel.isDebug(8)) {
                System.err.println("creating observations for prog " + prog);
                System.err.flush();
            }
            results = stmt.execute(tmpQuery);
            if (DBDataModel.isDebug(8)) {
                System.err.println(tmpQuery + (results ? " ok" : " empty"));
                System.err.flush();
            }
            do {
                if (results) {
                    rs = stmt.getResultSet();
                    int rowNum = 1;
                    while (rs.next()) {
                        String obIdString = rs.getString(1);
                        String obName = rs.getString(2);
                        if (obIdString != null) {
                            if (DBDataModel.isDebug(8)) {
                                System.err.println("         " + obIdString + "  " + obName);
                            }
                            DBContainer obs = this.addObservation(prog, obIdString, obName);
                        }
                        ++rowNum;
                    }
                } else {
                    System.out.println("........No observations");
                }
            } while (results = stmt.getMoreResults());
            stmt.close();
        }
        catch (SQLException sqe) {
            this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
            rc = false;
            this.connectionLost(sqe);
        }
        return rc;
    }

    public boolean fillObservation(DBContainer prog, DBContainer ob) {
        boolean rc = false;
        String queryTwo = null;
        Object observation = null;
        Statement stmt = null;
        boolean treeTelescope = true;
        queryTwo = "select * from observations..data_products where prog_id = '" + prog.getId() + "' and ob_id = " + ob.getId();
        if (prog == null) {
            System.out.println("Troubles finding DBContainer for " + prog);
        }
        if (DBDataModel.isDebug(8)) {
            System.err.println("Finding  frames for Program " + prog + " observation " + ob);
        }
        if (prog.getFather() == this.programs) {
            treeTelescope = false;
        }
        try {
            stmt = this.permanentConnection.createStatement();
            ResultSet rs = null;
            if (DBDataModel.isDebug(8)) {
                System.err.println(queryTwo);
            }
            boolean results = stmt.execute(queryTwo);
            do {
                if (!results) continue;
                rs = stmt.getResultSet();
                int rowNum = 1;
                while (rs.next()) {
                    DBOBComponent tmpComp = new DBOBComponent();
                    this.loadPrimaryKeywords(tmpComp, rs);
                    if (this.extendedDatabase) {
                        this.addExtendedKeywords(tmpComp);
                    }
                    tmpComp.init();
                    tmpComp.freeHeaderMemory();
                    ob.put(tmpComp.getId(), tmpComp);
                    if (treeTelescope) {
                        tmpComp.setObservation(ob, 2);
                    } else {
                        tmpComp.setObservation(ob, 0);
                    }
                    if (DBDataModel.isDebug(8)) {
                        System.err.println(tmpComp);
                    }
                    ++rowNum;
                }
                results = stmt.getMoreResults();
            } while (results);
            stmt.close();
        }
        catch (SQLException sqe) {
            this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
            rc = false;
            this.connectionLost(sqe);
        }
        return rc;
    }

    public void removeObservations(DBContainer prog) {
        DBContainer tmpCont = null;
        Enumeration e2 = prog.elements();
        while (e2.hasMoreElements()) {
            tmpCont = (DBContainer)e2.nextElement();
            prog.remove(tmpCont.getId());
        }
    }

    public DBContainer getTelescopesSet() {
        return this.telescopes;
    }

    public DBContainer getTelescope(String tel) {
        return (DBContainer)this.telescopes.get(tel);
    }

    public int getTelescopeCount() {
        return this.telescopes.size();
    }

    public DBContainer getTelescopeAt(int i) {
        return (DBContainer)this.telescopes.elementAt(i);
    }

    public int getIndexOfTelescope(DBContainer prog) {
        return this.telescopes.indexOf(prog);
    }

    public DBContainer findTelescope(String telName) {
        return (DBContainer)this.telescopes.get(telName);
    }

    public DBContainer addTelescope(String telName) {
        DBContainer rc = this.findTelescope(telName);
        if (rc == null) {
            rc = new DBContainer('t', telName);
            this.telescopes.put(telName, rc);
        }
        if (DBDataModel.isDebug(1)) {
            System.out.println("Added Telescope: " + telName);
        }
        return rc;
    }

    public void expandContainer(DBContainer tmpCont) {
        if (tmpCont.isProgram()) {
            tmpCont.clear();
            this.createObservations(tmpCont);
        }
        if (tmpCont.isObservation()) {
            if (tmpCont == this.dummyBox) {
                return;
            }
            this.fillObservation(tmpCont.getFather(), tmpCont);
        }
        if (tmpCont.isTelescope()) {
            // empty if block
        }
    }

    public void collapseContainer(DBContainer tmpCont) {
        if (tmpCont.isProgram()) {
            tmpCont.clear();
            this.removeObservations(tmpCont);
            this.addObservation(tmpCont, this.dummyBox.getId(), "pippo");
        }
        if (tmpCont.isObservation()) {
            tmpCont.clear();
            this.removeFrames(tmpCont.toString());
            this.addObservation(tmpCont, this.dummyBox.getId(), "pippo");
        }
    }

    public void removeFrames(String observation) {
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private void connectionLost(SQLException sqle) {
        System.err.println(this.getErrorMessage());
        boolean lost = true;
        while (lost) {
            try {
                this.permanentConnection = DriverManager.getConnection(this.serverURL, this.connectionProperties);
                lost = false;
            }
            catch (Exception se) {
                System.err.println("Connection Failed " + se);
            }
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private void determineExtensions() {
        int i;
        Statement stmt = null;
        boolean debug = false;
        String oneQuery = "select name from observations..sysobjects where name = 'obs_tables' and type = 'U'";
        String twoQuery = "select * from observations..obs_tables where instrume = '";
        String threeQuery = "' and name != 'data_products'";
        String fourQuery = "select name, keyword from observations..obs_columns where tname = '";
        if (DBDataModel.isDebug(8)) {
            debug = true;
        }
        try {
            stmt = this.permanentConnection.createStatement();
            ResultSet rs = null;
            if (DBDataModel.isDebug(8)) {
                System.out.println(oneQuery);
            }
            boolean results = stmt.execute(oneQuery);
            do {
                if (!results) continue;
                rs = stmt.getResultSet();
                int rowNum = 1;
                while (rs.next()) {
                    String tmpString = rs.getString(1);
                    this.extendedDatabase = true;
                    ++rowNum;
                }
            } while (results = stmt.getMoreResults());
            stmt.close();
        }
        catch (SQLException sqe) {
            this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
            this.connectionLost(sqe);
        }
        if (!this.extendedDatabase) {
            return;
        }
        if (debug) {
            System.out.println("This is an extended database");
        }
        for (i = 0; i < GasProp.getProperties().dbInstruments.size(); ++i) {
            String instrume = (String)GasProp.getProperties().dbInstruments.elementAt(i);
            String query = twoQuery + instrume + threeQuery;
            if (debug) {
                System.out.print(instrume + ": ");
            }
            Vector<SortedHashtable> tmpVector = new Vector<SortedHashtable>();
            try {
                stmt = this.permanentConnection.createStatement();
                ResultSet rs = null;
                if (debug) {
                    System.out.println(query);
                }
                boolean results = stmt.execute(query);
                do {
                    if (!results) continue;
                    rs = stmt.getResultSet();
                    int rowNum = 1;
                    while (rs.next()) {
                        String tmpString = rs.getString(1);
                        if (debug) {
                            System.out.print(tmpString + " ");
                        }
                        tmpVector.addElement(new SortedHashtable(tmpString));
                        ++rowNum;
                    }
                } while (results = stmt.getMoreResults());
                stmt.close();
            }
            catch (SQLException sqe) {
                this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
                this.connectionLost(sqe);
            }
            this.instToTable.put(instrume, tmpVector);
            if (!debug) continue;
            System.out.println("");
        }
        for (i = 0; i < GasProp.getProperties().dbInstruments.size(); ++i) {
            String instrume = (String)GasProp.getProperties().dbInstruments.elementAt(i);
            Vector tmpVector = (Vector)this.instToTable.get(instrume);
            for (int j = 0; j < tmpVector.size(); ++j) {
                SortedHashtable tmpMap = (SortedHashtable)tmpVector.elementAt(j);
                String query = fourQuery + tmpMap.toString() + "' ";
                try {
                    stmt = this.permanentConnection.createStatement();
                    ResultSet rs = null;
                    if (debug) {
                        System.out.println(query);
                    }
                    boolean results = stmt.execute(query);
                    do {
                        if (!results) continue;
                        rs = stmt.getResultSet();
                        int rowNum = 1;
                        while (rs.next()) {
                            String tmpColumn = rs.getString(1);
                            String tmpKeyword = rs.getString(2);
                            if (tmpColumn != null && tmpKeyword != null) {
                                if (debug) {
                                    System.out.println(tmpColumn + " =>  " + Keyword.convertFullNameToDot(tmpKeyword));
                                }
                                tmpMap.put(tmpColumn, Keyword.convertFullNameToDot(tmpKeyword));
                            }
                            ++rowNum;
                        }
                    } while (results = stmt.getMoreResults());
                    stmt.close();
                }
                catch (SQLException sqe) {
                    this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
                    this.connectionLost(sqe);
                }
                this.tableToMap.put(tmpMap.toString(), tmpMap);
            }
        }
    }

    void loadPrimaryKeywords(DBOBComponent dbComp, ResultSet rs) {
        boolean debug = false;
        if (DBDataModel.isDebug(8)) {
            debug = true;
        }
        try {
            for (int z = 0; z < this.translationTable.size(); ++z) {
                String key = this.translationTable.getKeyAt(z);
                String value = rs.getString((String)this.translationTable.get(key));
                Keyword keyW = new Keyword(key, value);
                dbComp.addKeyword(keyW);
            }
        }
        catch (SQLException sqle) {
            System.err.println(sqle);
        }
    }

    void addExtendedKeywords(DBOBComponent dbComp) {
        String instSelection = PropertyDB.getInstance().getProperty("DBOBS_INSTRUMENT");
        Statement stmt = null;
        boolean debug = false;
        boolean allInstruments = false;
        String oneQuery = "select * from observations..";
        String twoQuery = " where dp_id = '";
        String dp_id = dbComp.getKeyword("ARCFILE").getValue();
        if (DBDataModel.isDebug(8)) {
            debug = true;
        }
        if (instSelection.equals("All")) {
            instSelection = dbComp.getKeyword("INSTRUME").getValue();
        }
        Vector tmpVector = (Vector)this.instToTable.get(instSelection);
        for (int j = 0; j < tmpVector.size(); ++j) {
            SortedHashtable tmpMap = (SortedHashtable)tmpVector.elementAt(j);
            String query = oneQuery + tmpMap.toString() + twoQuery + dp_id + "'";
            try {
                stmt = this.permanentConnection.createStatement();
                ResultSet rs = null;
                if (debug) {
                    System.out.println(query);
                }
                boolean results = stmt.execute(query);
                do {
                    if (!results) continue;
                    rs = stmt.getResultSet();
                    int rowNum = 1;
                    while (rs.next()) {
                        Enumeration e2 = tmpMap.keys();
                        while (e2.hasMoreElements()) {
                            String tmpColumn = (String)e2.nextElement();
                            String tmpKey = (String)tmpMap.get(tmpColumn);
                            String tmpValue = rs.getString(tmpColumn);
                            if (tmpValue == null) continue;
                            dbComp.addKeyword(new Keyword(tmpKey, tmpValue));
                            if (!debug) continue;
                            System.out.println("== " + tmpKey + " " + tmpValue);
                        }
                        ++rowNum;
                    }
                } while (results = stmt.getMoreResults());
                stmt.close();
                continue;
            }
            catch (SQLException sqe) {
                this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
                this.connectionLost(sqe);
            }
        }
    }

    public boolean selectSingleFrame(DBOBComponent dbob) {
        boolean rc = false;
        String queryTwo = null;
        Object observation = null;
        Statement stmt = null;
        boolean treeTelescope = true;
        queryTwo = "select * from observations..data_products where dp_id = '" + dbob.getId() + "'";
        if (DBDataModel.isDebug(8)) {
            System.err.println("selecting single frame" + dbob.getId());
        }
        try {
            stmt = this.permanentConnection.createStatement();
            ResultSet rs = null;
            if (DBDataModel.isDebug(8)) {
                System.err.println(queryTwo);
            }
            boolean results = stmt.execute(queryTwo);
            do {
                if (!results) continue;
                rs = stmt.getResultSet();
                int rowNum = 1;
                while (rs.next()) {
                    this.loadPrimaryKeywords(dbob, rs);
                    if (this.extendedDatabase) {
                        this.addExtendedKeywords(dbob);
                    }
                    ++rowNum;
                }
                results = stmt.getMoreResults();
            } while (results);
            stmt.close();
        }
        catch (SQLException sqe) {
            this.errorMessage = new String(sqe.toString() + ", sqlstate = " + sqe.getSQLState());
            rc = false;
            this.connectionLost(sqe);
        }
        return rc;
    }
}

