/*
 * Decompiled with CFR 0.152.
 */
package org.eso.cpl;

import java.io.File;
import java.util.List;
import org.eso.cpl.Frame;
import org.eso.cpl.FrameGroup;
import org.eso.cpl.FrameLevel;
import org.eso.cpl.FrameList;
import org.eso.cpl.FrameType;
import org.eso.dfs.services.ServiceException;
import org.eso.dfs.services.data.AssociationNode;
import org.eso.dfs.services.data.AssociationService;
import org.eso.dfs.services.data.FileAssociationNode;

public class AssociationUtils {
    public static FileAssociationNode[] classifyFiles(List files) {
        AssociationService service = AssociationService.getInstance();
        AssociationNode[] nodes = new FileAssociationNode[files.size()];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = new FileAssociationNode((File)files.get(i));
        }
        try {
            service.processNodes(nodes);
        }
        catch (ServiceException e2) {
            e2.printStackTrace();
        }
        return nodes;
    }

    public static FrameList classifyFrames(List files) {
        return AssociationUtils.getFramesFromNodes(AssociationUtils.classifyFiles(files));
    }

    public static FrameList getFramesFromNodes(FileAssociationNode[] nodes) {
        FrameList rc = new FrameList();
        for (int i = 0; i < nodes.length; ++i) {
            Frame frm = AssociationUtils.getFrameFromNode(nodes[i]);
            if (frm.getTag() == null) continue;
            rc.add(frm);
        }
        return rc;
    }

    public static Frame getFrameFromNode(FileAssociationNode node) {
        Frame frm = new Frame(node.getAddress());
        String classification = null;
        if (node.getClassification() != null && node.getClassification().length > 0) {
            classification = node.getClassification()[0];
        }
        if (classification != null) {
            frm.setTag(classification);
        }
        frm.setGroup(node.getCategory() != null && node.getCategory().equals("CALIB") ? FrameGroup.CALIB : FrameGroup.RAW);
        frm.setLevel(FrameLevel.INTERMEDIATE);
        frm.setType(FrameType.IMAGE);
        return frm;
    }
}

