/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.UndefinedData;
import nom.tam.util.ArrayFuncs;

public class UndefinedHDU
extends BasicHDU {
    public UndefinedHDU(Header h, Data d2) throws FitsException {
        this.myData = d2;
        this.myHeader = h;
    }

    public static boolean isHeader(Header hdr) {
        return hdr.getStringValue("XTENSION") != null && hdr.getIntValue("NAXIS", -1) >= 0;
    }

    public static boolean isData(Object o) {
        return ArrayFuncs.computeLSize(o) > 0L;
    }

    @Override
    public Data manufactureData() throws FitsException {
        return UndefinedHDU.manufactureData(this.myHeader);
    }

    public static Data manufactureData(Header hdr) throws FitsException {
        return new UndefinedData(hdr);
    }

    public static Header manufactureHeader(Data d2) throws FitsException {
        Header h = new Header();
        d2.fillHeader(h);
        return h;
    }

    public static Data encapsulate(Object o) throws FitsException {
        return new UndefinedData(o);
    }

    @Override
    public void info() {
        System.out.println("  Unhandled/Undefined/Unknown Type");
        System.out.println("  XTENSION=" + this.myHeader.getStringValue("XTENSION").trim());
        System.out.println("  Apparent size:" + this.myData.getTrueSize());
    }
}

