/*
 * Decompiled with CFR 0.152.
 */
package nom.tam.fits;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.NoSuchElementException;
import java.util.Vector;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.Data;
import nom.tam.fits.FitsException;
import nom.tam.fits.FitsFactory;
import nom.tam.fits.FitsUtil;
import nom.tam.fits.Header;
import nom.tam.fits.HeaderCardException;
import nom.tam.fits.HeaderCommentsMap;
import nom.tam.fits.PaddingException;
import nom.tam.util.ArrayDataInput;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.AsciiFuncs;
import nom.tam.util.BufferedDataInputStream;
import nom.tam.util.BufferedDataOutputStream;
import nom.tam.util.BufferedFile;
import nom.tam.util.RandomAccess;

public class Fits {
    private ArrayDataInput dataStr;
    private Vector hduList = new Vector();
    private boolean atEOF;
    private long lastFileOffset = -1L;

    public static String version() {
        return "1.080";
    }

    public Fits() {
    }

    public Fits(InputStream str) throws FitsException {
        this.streamInit(str, false);
    }

    public Fits(InputStream str, boolean compressed) throws FitsException {
        this.streamInit(str);
    }

    protected void streamInit(InputStream str, boolean seekable) throws FitsException {
        this.streamInit(str);
    }

    protected void streamInit(InputStream str, boolean compressed, boolean seekable) throws FitsException {
        this.streamInit(str);
    }

    protected void streamInit(InputStream str) throws FitsException {
        this.dataStr = (str = FitsUtil.decompress(str)) instanceof ArrayDataInput ? (ArrayDataInput)((Object)str) : new BufferedDataInputStream(str);
    }

    protected void randomInit(File f) throws FitsException {
        String permissions = "r";
        if (!f.exists() || !f.canRead()) {
            throw new FitsException("Non-existent or unreadable file");
        }
        if (f.canWrite()) {
            permissions = String.valueOf(permissions) + "w";
        }
        try {
            this.dataStr = new BufferedFile(f, permissions);
            ((BufferedFile)this.dataStr).seek(0L);
        }
        catch (IOException e2) {
            throw new FitsException("Unable to open file " + f.getPath());
        }
    }

    public Fits(File myFile) throws FitsException {
        this(myFile, FitsUtil.isCompressed(myFile));
    }

    public Fits(File myFile, boolean compressed) throws FitsException {
        this.fileInit(myFile, compressed);
    }

    protected void fileInit(File myFile, boolean compressed) throws FitsException {
        try {
            if (compressed) {
                FileInputStream str = new FileInputStream(myFile);
                this.streamInit(str);
            } else {
                this.randomInit(myFile);
            }
        }
        catch (IOException e2) {
            throw new FitsException("Unable to create Input Stream from File: " + myFile);
        }
    }

    public Fits(String filename) throws FitsException {
        this(filename, FitsUtil.isCompressed(filename));
    }

    public Fits(String filename, boolean compressed) throws FitsException {
        if (filename == null) {
            throw new FitsException("Null FITS Identifier String");
        }
        int len = filename.length();
        String lc = filename.toLowerCase();
        try {
            URL test = new URL(filename);
            InputStream is = FitsUtil.getURLStream(new URL(filename), 0);
            this.streamInit(is);
            return;
        }
        catch (Exception test) {
            File fil = new File(filename);
            if (fil.exists()) {
                this.fileInit(fil, compressed);
                return;
            }
            try {
                InputStream str = ClassLoader.getSystemClassLoader().getResourceAsStream(filename);
                this.streamInit(str);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return;
        }
    }

    public Fits(URL myURL, boolean compressed) throws FitsException {
        this(myURL);
    }

    public Fits(URL myURL) throws FitsException {
        try {
            this.streamInit(FitsUtil.getURLStream(myURL, 0));
        }
        catch (IOException e2) {
            throw new FitsException("Unable to open input from URL:" + myURL);
        }
    }

    public BasicHDU[] read() throws FitsException {
        this.readToEnd();
        int size = this.getNumberOfHDUs();
        if (size == 0) {
            return null;
        }
        Object[] hdus = new BasicHDU[size];
        this.hduList.copyInto(hdus);
        return hdus;
    }

    public BasicHDU readHDU() throws FitsException, IOException {
        Header hdr;
        if (this.dataStr == null || this.atEOF) {
            return null;
        }
        if (this.dataStr instanceof RandomAccess && this.lastFileOffset > 0L) {
            FitsUtil.reposition(this.dataStr, this.lastFileOffset);
        }
        if ((hdr = Header.readHeader(this.dataStr)) == null) {
            this.atEOF = true;
            return null;
        }
        Data datum = hdr.makeData();
        try {
            datum.read(this.dataStr);
        }
        catch (PaddingException e2) {
            e2.updateHeader(hdr);
            throw e2;
        }
        this.lastFileOffset = FitsUtil.findOffset(this.dataStr);
        BasicHDU nextHDU = FitsFactory.HDUFactory(hdr, datum);
        this.hduList.addElement(nextHDU);
        return nextHDU;
    }

    public void skipHDU(int n) throws FitsException, IOException {
        int i = 0;
        while (i < n) {
            this.skipHDU();
            ++i;
        }
    }

    public void skipHDU() throws FitsException, IOException {
        if (this.atEOF) {
            return;
        }
        Header hdr = new Header(this.dataStr);
        if (hdr == null) {
            this.atEOF = true;
            return;
        }
        int dataSize = (int)hdr.getDataSize();
        this.dataStr.skip(dataSize);
    }

    public BasicHDU getHDU(int n) throws FitsException, IOException {
        int size;
        int i = size = this.getNumberOfHDUs();
        while (i <= n) {
            BasicHDU hdu = this.readHDU();
            if (hdu == null) {
                return null;
            }
            ++i;
        }
        try {
            return (BasicHDU)this.hduList.elementAt(n);
        }
        catch (NoSuchElementException e2) {
            throw new FitsException("Internal Error: hduList build failed");
        }
    }

    private void readToEnd() throws FitsException {
        while (this.dataStr != null && !this.atEOF) {
            try {
                if (this.readHDU() != null) continue;
                break;
            }
            catch (IOException e2) {
                throw new FitsException("IO error: " + e2);
            }
        }
    }

    public int size() throws FitsException {
        this.readToEnd();
        return this.getNumberOfHDUs();
    }

    public void addHDU(BasicHDU myHDU) throws FitsException {
        this.insertHDU(myHDU, this.getNumberOfHDUs());
    }

    public void insertHDU(BasicHDU myHDU, int n) throws FitsException {
        if (myHDU == null) {
            return;
        }
        if (n < 0 || n > this.getNumberOfHDUs()) {
            throw new FitsException("Attempt to insert HDU at invalid location: " + n);
        }
        try {
            if (n == 0) {
                if (this.getNumberOfHDUs() > 0) {
                    ((BasicHDU)this.hduList.elementAt(0)).setPrimaryHDU(false);
                }
                if (myHDU.canBePrimary()) {
                    myHDU.setPrimaryHDU(true);
                    this.hduList.insertElementAt(myHDU, 0);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                    myHDU.setPrimaryHDU(false);
                    this.hduList.insertElementAt(myHDU, 1);
                }
            } else {
                myHDU.setPrimaryHDU(false);
                this.hduList.insertElementAt(myHDU, n);
            }
        }
        catch (NoSuchElementException e2) {
            throw new FitsException("hduList inconsistency in insertHDU");
        }
    }

    public void deleteHDU(int n) throws FitsException {
        int size = this.getNumberOfHDUs();
        if (n < 0 || n >= size) {
            throw new FitsException("Attempt to delete non-existent HDU:" + n);
        }
        try {
            this.hduList.removeElementAt(n);
            if (n == 0 && size > 1) {
                BasicHDU newFirst = (BasicHDU)this.hduList.elementAt(0);
                if (newFirst.canBePrimary()) {
                    newFirst.setPrimaryHDU(true);
                } else {
                    this.insertHDU(BasicHDU.getDummyHDU(), 0);
                }
            }
        }
        catch (NoSuchElementException e2) {
            throw new FitsException("Internal Error: hduList Vector Inconsitency");
        }
    }

    public void write(DataOutput os) throws FitsException {
        ArrayDataOutput obs;
        boolean newOS = false;
        if (os instanceof ArrayDataOutput) {
            obs = (ArrayDataOutput)os;
        } else if (os instanceof DataOutputStream) {
            newOS = true;
            obs = new BufferedDataOutputStream((DataOutputStream)os);
        } else {
            throw new FitsException("Cannot create ArrayDataOutput from class " + os.getClass().getName());
        }
        int i = 0;
        while (i < this.getNumberOfHDUs()) {
            try {
                BasicHDU hh = (BasicHDU)this.hduList.elementAt(i);
                hh.write(obs);
            }
            catch (ArrayIndexOutOfBoundsException e2) {
                e2.printStackTrace();
                throw new FitsException("Internal Error: Vector Inconsistency" + e2);
            }
            ++i;
        }
        if (newOS) {
            try {
                obs.flush();
                obs.close();
            }
            catch (IOException e3) {
                System.err.println("Warning: error closing FITS output stream");
            }
        }
        try {
            if (obs instanceof BufferedFile) {
                ((BufferedFile)obs).setLength(((BufferedFile)obs).getFilePointer());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void read(InputStream is) throws FitsException, IOException {
        boolean newIS = false;
        this.dataStr = is instanceof ArrayDataInput ? (ArrayDataInput)((Object)is) : new BufferedDataInputStream(is);
        this.read();
        if (newIS) {
            this.dataStr.close();
            this.dataStr = null;
        }
    }

    public int currentSize() {
        return this.hduList.size();
    }

    public int getNumberOfHDUs() {
        return this.hduList.size();
    }

    public ArrayDataInput getStream() {
        return this.dataStr;
    }

    public void setStream(ArrayDataInput stream) {
        this.dataStr = stream;
        this.atEOF = false;
        this.lastFileOffset = -1L;
    }

    public static BasicHDU makeHDU(Header h) throws FitsException {
        Data d2 = FitsFactory.dataFactory(h);
        return FitsFactory.HDUFactory(h, d2);
    }

    public static BasicHDU makeHDU(Object o) throws FitsException {
        return FitsFactory.HDUFactory(o);
    }

    public static BasicHDU makeHDU(Data datum) throws FitsException {
        Header hdr = new Header();
        datum.fillHeader(hdr);
        return FitsFactory.HDUFactory(hdr, datum);
    }

    public static void setChecksum(BasicHDU hdu) throws HeaderCardException, FitsException, IOException {
        Header hdr = hdu.getHeader();
        hdr.deleteKey("CHECKSUM");
        String doneAt = HeaderCommentsMap.getComment("fits:checksum:1");
        hdr.addValue("CHECKSUM", "0000000000000000", doneAt);
        ByteArrayOutputStream hduByteImage = new ByteArrayOutputStream();
        BufferedDataOutputStream bdos = new BufferedDataOutputStream(hduByteImage);
        hdu.getData().write(bdos);
        bdos.flush();
        byte[] data = hduByteImage.toByteArray();
        long checksum = Fits.checksum(data);
        hdu.write(new BufferedDataOutputStream(hduByteImage));
        long csd = Fits.checksum(data);
        hdu.getHeader().addValue("DATASUM", "" + csd, "Checksum of data");
        hduByteImage.reset();
        hdu.getHeader().write(bdos);
        bdos.flush();
        data = hduByteImage.toByteArray();
        long csh = Fits.checksum(data);
        long cshdu = csh + csd;
        while ((cshdu & 0xFFFFFFFF00000000L) != 0L) {
            cshdu = (cshdu & 0xFFFFFFFFL) + 1L;
        }
        hdr.addValue("CHECKSUM", Fits.checksumEnc(cshdu, true), doneAt);
    }

    public void setChecksum() throws HeaderCardException, FitsException, IOException {
        int i = 0;
        while (i < this.getNumberOfHDUs()) {
            Fits.setChecksum(this.getHDU(i));
            ++i;
        }
    }

    public static long checksum(byte[] data) {
        long hi = 0L;
        long lo = 0L;
        int len = 2 * (data.length / 4);
        int remain = data.length % 4;
        int i = 0;
        while (i < len) {
            hi += (long)(data[2 * i] << 8) & 0xFF00L | (long)data[2 * i + 1] & 0xFFL;
            lo += (long)(data[2 * i + 2] << 8) & 0xFF00L | (long)data[2 * i + 3] & 0xFFL;
            i += 2;
        }
        if (remain >= 1) {
            hi += (long)(data[2 * len] << 8) & 0xFF00L;
        }
        if (remain >= 2) {
            hi += (long)data[2 * len + 1] & 0xFFL;
        }
        if (remain >= 3) {
            lo += (long)(data[2 * len + 2] << 8) & 0xFF00L;
        }
        long hicarry = hi >>> 16;
        long locarry = lo >>> 16;
        while (hicarry != 0L || locarry != 0L) {
            hi = (hi & 0xFFFFL) + locarry;
            lo = (lo & 0xFFFFL) + hicarry;
            hicarry = hi >>> 16;
            locarry = lo >>> 16;
        }
        return (hi << 16) + lo;
    }

    private static String checksumEnc(long c2, boolean compl) {
        byte[] asc = new byte[16];
        int[] exclude = new int[]{58, 59, 60, 61, 62, 63, 64, 91, 92, 93, 94, 95, 96};
        long[] mask = new long[]{0xFF000000L, 0xFF0000L, 65280L, 255L};
        int offset = 48;
        long value = compl ? c2 ^ 0xFFFFFFFFFFFFFFFFL : c2;
        int i = 0;
        while (i < 4) {
            int byt = (int)((value & mask[i]) >>> 24 - 8 * i);
            int quotient = byt / 4 + 48;
            int remainder = byt % 4;
            int[] ch = new int[4];
            int j = 0;
            while (j < 4) {
                ch[j] = quotient;
                ++j;
            }
            ch[0] = ch[0] + remainder;
            boolean check = true;
            while (check) {
                check = false;
                int k = 0;
                while (k < exclude.length) {
                    int j2 = 0;
                    while (j2 < 4) {
                        if (ch[j2] == exclude[k] || ch[j2 + 1] == exclude[k]) {
                            int n = j2;
                            ch[n] = ch[n] + 1;
                            int n2 = j2 + 1;
                            ch[n2] = ch[n2] - 1;
                            check = true;
                        }
                        j2 += 2;
                    }
                    ++k;
                }
            }
            int j3 = 0;
            while (j3 < 4) {
                asc[4 * j3 + i] = (byte)ch[j3];
                ++j3;
            }
            ++i;
        }
        try {
            String resul = AsciiFuncs.asciiString(asc, 15, 1);
            return resul.concat(AsciiFuncs.asciiString(asc, 0, 15));
        }
        catch (Exception e2) {
            System.err.println("CheckSum Error finding ASCII encoding");
            return null;
        }
    }
}

