/*
 * Decompiled with CFR 0.152.
 */
package org.olsr.v1.info.api.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.InetAddress;
import org.olsr.v1.info.api.util.CompareUtils;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public class JsonInfoTopologyEntry
implements Comparable<JsonInfoTopologyEntry> {
    private String lastHopIP = "";
    private double pathCost = Double.POSITIVE_INFINITY;
    private long validityTime = 0L;
    private long refCount = 0L;
    private int msgSeq = 0;
    private int msgHops = 0;
    private int hops = 0;
    private int ansn = 0;
    private int tcIgnored = 0;
    private int errSeq = 0;
    private boolean errSeqValid = false;
    private String destinationIP = "";
    private double tcEdgeCost = Double.POSITIVE_INFINITY;
    private int ansnEdge = 0;
    private double linkQuality = 0.0;
    private double neighborLinkQuality = 0.0;

    public String getLastHopIP() {
        return this.lastHopIP;
    }

    @JsonProperty(value="lastHopIP")
    public void setLastHopIP(InetAddress lastHopIP) {
        this.lastHopIP = lastHopIP == null ? "" : lastHopIP.getHostAddress();
    }

    public double getPathCost() {
        return this.pathCost;
    }

    @JsonProperty(value="pathCost")
    public void setPathCost(double pathCost) {
        this.pathCost = Double.compare(pathCost, 4.294967295E9) >= 0 ? Double.POSITIVE_INFINITY : pathCost;
    }

    public long getValidityTime() {
        return this.validityTime;
    }

    @JsonProperty(value="validityTime")
    public void setValidityTime(long validityTime) {
        this.validityTime = validityTime;
    }

    public long getRefCount() {
        return this.refCount;
    }

    @JsonProperty(value="refCount")
    public void setRefCount(long refCount) {
        this.refCount = refCount;
    }

    public int getMsgSeq() {
        return this.msgSeq;
    }

    @JsonProperty(value="msgSeq")
    public void setMsgSeq(int msgSeq) {
        this.msgSeq = msgSeq;
    }

    public int getMsgHops() {
        return this.msgHops;
    }

    @JsonProperty(value="msgHops")
    public void setMsgHops(int msgHops) {
        this.msgHops = msgHops;
    }

    public int getHops() {
        return this.hops;
    }

    @JsonProperty(value="hops")
    public void setHops(int hops) {
        this.hops = hops;
    }

    public int getAnsn() {
        return this.ansn;
    }

    @JsonProperty(value="ansn")
    public void setAnsn(int ansn) {
        this.ansn = ansn;
    }

    public int getTcIgnored() {
        return this.tcIgnored;
    }

    @JsonProperty(value="tcIgnored")
    public void setTcIgnored(int tcIgnored) {
        this.tcIgnored = tcIgnored;
    }

    public int getErrSeq() {
        return this.errSeq;
    }

    @JsonProperty(value="errSeq")
    public void setErrSeq(int errSeq) {
        this.errSeq = errSeq;
    }

    public boolean getErrSeqValid() {
        return this.errSeqValid;
    }

    @JsonProperty(value="errSeqValid")
    public void setErrSeqValid(boolean errSeqValid) {
        this.errSeqValid = errSeqValid;
    }

    public String getDestinationIP() {
        return this.destinationIP;
    }

    @JsonProperty(value="destinationIP")
    public void setDestinationIP(InetAddress destinationIP) {
        this.destinationIP = destinationIP == null ? "" : destinationIP.getHostAddress();
    }

    public double getTcEdgeCost() {
        return this.tcEdgeCost;
    }

    @JsonProperty(value="tcEdgeCost")
    public void setTcEdgeCost(double tcEdgeCost) {
        this.tcEdgeCost = Double.compare(tcEdgeCost, 4.294967295E9) >= 0 ? Double.POSITIVE_INFINITY : tcEdgeCost;
    }

    public int getAnsnEdge() {
        return this.ansnEdge;
    }

    @JsonProperty(value="ansnEdge")
    public void setAnsnEdge(int ansnEdge) {
        this.ansnEdge = ansnEdge;
    }

    public double getLinkQuality() {
        return this.linkQuality;
    }

    @JsonProperty(value="linkQuality")
    public void setLinkQuality(double linkQuality) {
        this.linkQuality = linkQuality;
    }

    public double getNeighborLinkQuality() {
        return this.neighborLinkQuality;
    }

    @JsonProperty(value="neighborLinkQuality")
    public void setNeighborLinkQuality(double neighborLinkQuality) {
        this.neighborLinkQuality = neighborLinkQuality;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.lastHopIP.hashCode();
        long temp = Double.doubleToLongBits(this.pathCost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + (int)(this.validityTime ^ this.validityTime >>> 32);
        result = 31 * result + (int)(this.refCount ^ this.refCount >>> 32);
        result = 31 * result + this.msgSeq;
        result = 31 * result + this.msgHops;
        result = 31 * result + this.hops;
        result = 31 * result + this.ansn;
        result = 31 * result + this.tcIgnored;
        result = 31 * result + this.errSeq;
        result = 31 * result + (this.errSeqValid ? 1231 : 1237);
        result = 31 * result + this.destinationIP.hashCode();
        temp = Double.doubleToLongBits(this.tcEdgeCost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.ansnEdge;
        temp = Double.doubleToLongBits(this.linkQuality);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.neighborLinkQuality);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.compareTo((JsonInfoTopologyEntry)other) == 0;
    }

    @Override
    public int compareTo(JsonInfoTopologyEntry other) {
        if (other == null) {
            return -1;
        }
        int result = this.lastHopIP.compareTo(other.lastHopIP);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = Double.compare(this.pathCost, other.pathCost);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.validityTime, other.validityTime);
        if (result != 0) {
            return result;
        }
        result = Long.compare(this.refCount, other.refCount);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.msgSeq, other.msgSeq);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.msgHops, other.msgHops);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.hops, other.hops);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.ansn, other.ansn);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.tcIgnored, other.tcIgnored);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.errSeq, other.errSeq);
        if (result != 0) {
            return result;
        }
        result = Boolean.compare(this.errSeqValid, other.errSeqValid);
        if (result != 0) {
            return result;
        }
        result = this.destinationIP.compareTo(other.destinationIP);
        if (result != 0) {
            return CompareUtils.clip(result);
        }
        result = Double.compare(this.tcEdgeCost, other.tcEdgeCost);
        if (result != 0) {
            return result;
        }
        result = Integer.compare(this.ansnEdge, other.ansnEdge);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.linkQuality, other.linkQuality);
        if (result != 0) {
            return result;
        }
        result = Double.compare(this.neighborLinkQuality, other.neighborLinkQuality);
        if (result != 0) {
            return result;
        }
        return 0;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("JsonInfoTopologyEntry [lastHopIP=");
        builder.append(this.lastHopIP);
        builder.append(", pathCost=");
        builder.append(this.pathCost);
        builder.append(", validityTime=");
        builder.append(this.validityTime);
        builder.append(", refCount=");
        builder.append(this.refCount);
        builder.append(", msgSeq=");
        builder.append(this.msgSeq);
        builder.append(", msgHops=");
        builder.append(this.msgHops);
        builder.append(", hops=");
        builder.append(this.hops);
        builder.append(", ansn=");
        builder.append(this.ansn);
        builder.append(", tcIgnored=");
        builder.append(this.tcIgnored);
        builder.append(", errSeq=");
        builder.append(this.errSeq);
        builder.append(", errSeqValid=");
        builder.append(this.errSeqValid);
        builder.append(", destinationIP=");
        builder.append(this.destinationIP);
        builder.append(", tcEdgeCost=");
        builder.append(this.tcEdgeCost);
        builder.append(", ansnEdge=");
        builder.append(this.ansnEdge);
        builder.append(", linkQuality=");
        builder.append(this.linkQuality);
        builder.append(", neighborLinkQuality=");
        builder.append(this.neighborLinkQuality);
        builder.append("]");
        return builder.toString();
    }
}

